/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.EmptyQueryException;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.ROXStepEvent;
import com.raplix.rolloutexpress.event.query.bean.ProgressBean;
import com.raplix.rolloutexpress.event.query.bean.ProgressInterface;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.util.logger.Logger;
import java.util.Date;

public class ROXStepProgressEvent
extends ROXStepEvent
implements ROXEventFactoryInterface,
ProgressInterface,
Messages {
    private ProgressBean mProgress = new ProgressBean();

    public ROXStepProgressEvent(Date inDate, String inMessage, StepInfo inStepInfo, double inProgress, int inSubPlanIndex) {
        super(inDate, inMessage, 1, inStepInfo, inStepInfo.getRunLevel().equals(RunLevel.PREFLIGHT), inSubPlanIndex);
        this.setProgress(inProgress);
    }

    public ROXStepProgressEvent() {
        this.setSeverity(1);
    }

    public double getProgress() {
        return this.mProgress.getProgress();
    }

    public void setProgress(double inProgress) {
        this.mProgress.setProgress(inProgress);
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setPercentDone(this.getProgress());
        return ref;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.setProgress(inFactory.getPercentDone());
    }

    protected boolean beforeSave(NotificationManager inNM) {
        ROXEvent[] input = new ROXEvent[1];
        try {
            input[0] = this.getKeyObject(false);
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("event.PROGRESS_KEY_CREATION_ERROR"), e, this);
            }
            return false;
        }
        try {
            ROXEvent[] output = inNM.query(input);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("ProgressEvent " + this + " has a precursor(" + output[0] + ") - proceed with update", this);
            }
            this.setEventID(output[0].getEventID());
            this.shouldInsert = false;
        }
        catch (EmptyQueryException eqe) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("ProgressEvent " + this + " has no precursor - continue with add", this);
            }
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("event.PROGRESS_EVENT_RETRIEVAL_ERROR"), e, this);
            }
            return false;
        }
        return true;
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.STEPPROGRESS_DESCRIPTION");
    }

    protected void doLookup() {
        this.mProgress.doLookup();
    }

    public String formatMessage() {
        String planName = "*";
        String targetName = "*";
        if (null != this.getExecutionPlanID()) {
            planName = this.getExecutionPlanID().toString() + "*";
        }
        if (null != this.getTargetID()) {
            targetName = this.getTargetID().toString() + "*";
        }
        if (null != this.getExecutionPlan()) {
            planName = this.getExecutionPlan().getName();
        }
        if (null != this.getTarget()) {
            targetName = this.getTarget().getInitialHost().getName();
        }
        return ROXMessageManager.messageAsString("event.STEPPROGRESS_MESSAGE", new Object[]{this.getStepTypeDescription(), planName, new Double(this.getIsPreflight() ? 1.0 : 0.0), targetName, new Double(this.getProgress()), this.getDate()});
    }
}

