/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.ROXStepEvent;
import com.raplix.rolloutexpress.event.query.bean.ExceptionBean;
import com.raplix.rolloutexpress.event.query.bean.ExceptionInterface;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import java.util.Date;

public class ROXStepFailedEvent
extends ROXStepEvent
implements ExceptionInterface,
ROXEventFactoryInterface,
Messages {
    private ExceptionBean mException = new ExceptionBean();

    public ROXStepFailedEvent() {
        this.setSeverity(4);
    }

    public ROXStepFailedEvent(Date inDate, String inMessage, int inSeverity, StepInfo inStepInfo, CommandException inEx, int inSubPlanIndex, boolean inHandled) {
        super(inDate, inMessage, inSeverity, inStepInfo, inStepInfo.getRunLevel().equals(RunLevel.PREFLIGHT), inSubPlanIndex);
        this.setException(inEx);
        this.setHandled(inHandled);
    }

    public ROXStepFailedEvent(Date inDate, String inMessage, int inSeverity, StepInfo inStepInfo, int inSubPlanIndex, boolean inHandled) {
        super(inDate, inMessage, inSeverity, inStepInfo, inStepInfo.getRunLevel().equals(RunLevel.PREFLIGHT), inSubPlanIndex);
        this.setHandled(inHandled);
    }

    public boolean getHandled() {
        return this.mException.getHandled();
    }

    public void setHandled(boolean inHandled) {
        this.mException.setHandled(inHandled);
    }

    public CommandException getException() {
        return this.mException.getException();
    }

    public void setException(CommandException inException) {
        this.mException.setException(inException);
    }

    public String getExceptionDescription() {
        return this.mException.getExceptionDescription();
    }

    public void setExceptionDescription(String inDescription) {
        this.mException.setExceptionDescription(inDescription);
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setExceptionDescription(this.getExceptionDescription());
        ref.setException(this.getException());
        ref.setHandled(this.getHandled());
        return ref;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mException = new ExceptionBean();
        this.setExceptionDescription(inFactory.getExceptionDescription());
        if (null != inFactory.getException()) {
            this.setException(inFactory.getException());
        }
        this.setHandled(inFactory.getHandled());
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.STEPFAILED_DESCRIPTION");
    }

    protected void doLookup() {
        this.mException.doLookup();
    }

    public String formatMessage() {
        String planName = "*";
        String targetName = "*";
        if (null != this.getExecutionPlanID()) {
            planName = this.getExecutionPlanID().toString() + "*";
        }
        if (null != this.getTargetID()) {
            targetName = this.getTargetID().toString() + "*";
        }
        if (null != this.getExecutionPlan()) {
            planName = this.getExecutionPlan().getName();
        }
        if (null != this.getTarget()) {
            targetName = this.getTarget().getInitialHost().getName();
        }
        CommandException e = this.getException();
        return ROXMessageManager.messageAsString("event.STEPFAILED_MESSAGE", new Object[]{this.getStepTypeDescription(), planName, new Double(this.getIsPreflight() ? 1.0 : 0.0), targetName, new Double(null == e ? 0.0 : 1.0), null == e ? null : ((Throwable)e).getMessage(), this.getDate()});
    }
}

