/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXStepAbortEvent;
import com.raplix.rolloutexpress.event.ROXStepCompleteEvent;
import com.raplix.rolloutexpress.event.ROXStepCustomStepEvent;
import com.raplix.rolloutexpress.event.ROXStepFailedEvent;
import com.raplix.rolloutexpress.event.ROXStepProgressEvent;
import com.raplix.rolloutexpress.event.ROXStepStartEvent;
import com.raplix.rolloutexpress.event.ROXTaskEvent;
import com.raplix.rolloutexpress.event.query.bean.StepBean;
import com.raplix.rolloutexpress.event.query.bean.StepInterface;
import com.raplix.rolloutexpress.event.query.bean.TargetBean;
import com.raplix.rolloutexpress.event.query.bean.TargetInterface;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.target.SummaryTarget;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import java.util.Date;

public abstract class ROXStepEvent
extends ROXTaskEvent
implements StepInterface,
TargetInterface {
    private StepBean mStep = new StepBean();
    private TargetBean mTarget = new TargetBean();
    private int mSubPlanIndex = -1;
    private int mQueryStepType = -1;

    protected ROXStepEvent() {
    }

    public ROXStepEvent(Date inDate, String inMessage, int inSeverity, StepInfo inStepInfo, boolean isPreflight, int inSubPlanIndex) {
        super(inDate, inMessage, inSeverity, inStepInfo.getTaskID(), inStepInfo.getExecutionPlanID(), isPreflight);
        this.setTargetID(inStepInfo.getTargetID());
        this.setStepInfo(inStepInfo);
        this.setSubPlanIndex(inSubPlanIndex);
    }

    public void setSubPlanIndex(int inSubPlanIndex) {
        this.mSubPlanIndex = inSubPlanIndex;
    }

    public int getSubPlanIndex() {
        return this.mSubPlanIndex;
    }

    public void setStepID(StepID inStepID) {
        this.mStep.setStepID(inStepID);
    }

    public void setStepInfo(StepInfo inStepInfo) {
        this.mStep = new StepBean(inStepInfo);
    }

    public StepID getStepID() {
        return this.mStep.getStepID();
    }

    public int getStepType() {
        return this.mStep.getStepType();
    }

    public void setStepType(int inStepType) {
        this.mQueryStepType = inStepType;
    }

    public StepInfo getStepInfo() {
        return this.mStep.getStepInfo();
    }

    public String getStepTypeDescription() {
        String theDesc = "";
        try {
            theDesc = ExecStep.getStepTypeStringRepresentation(this.getStepType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theDesc;
    }

    public TargetID getTargetID() {
        return this.mTarget.getTargetID();
    }

    public HostID getHostID() {
        return this.mTarget.getHostID();
    }

    public void setTargetID(TargetID inTargetID) {
        this.mTarget.setTargetID(inTargetID);
    }

    public SummaryTarget getSummaryTarget() {
        return this.mTarget.getSummaryTarget();
    }

    public Target getTarget() {
        return this.mTarget.getTarget();
    }

    public static ROXStepStartEvent start(StepInfo inStepInfo, int inSubPlanIndex) {
        return new ROXStepStartEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inStepInfo, inSubPlanIndex);
    }

    public static ROXStepCompleteEvent complete(StepInfo inStepInfo, int inSubPlanIndex) {
        return new ROXStepCompleteEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inStepInfo, inSubPlanIndex);
    }

    public static ROXStepAbortEvent abort(StepInfo inStepInfo, int inSubPlanIndex) {
        return new ROXStepAbortEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inStepInfo, inSubPlanIndex);
    }

    public static ROXStepFailedEvent failed(int inSeverity, StepInfo inStepInfo, int inSubPlanIndex) {
        return new ROXStepFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inSeverity, inStepInfo, inSubPlanIndex, false);
    }

    public static ROXStepFailedEvent failed(int inSeverity, StepInfo inStepInfo, CommandException inException, int inSubPlanIndex) {
        return new ROXStepFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inSeverity, inStepInfo, inException, inSubPlanIndex, false);
    }

    public static ROXStepFailedEvent failed(int inSeverity, StepInfo inStepInfo, int inSubPlanIndex, boolean inHandled) {
        return new ROXStepFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inSeverity, inStepInfo, inSubPlanIndex, inHandled);
    }

    public static ROXStepFailedEvent failed(int inSeverity, StepInfo inStepInfo, CommandException inException, int inSubPlanIndex, boolean inHandled) {
        return new ROXStepFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inSeverity, inStepInfo, inException, inSubPlanIndex, inHandled);
    }

    public static ROXStepProgressEvent progress(StepInfo inStepInfo, double inProgress, int inSubPlanIndex) {
        return new ROXStepProgressEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inStepInfo, inProgress, inSubPlanIndex);
    }

    public static ROXStepCustomStepEvent customStep(String inMessage, StepInfo inStepInfo, int inSubPlanIndex) {
        return new ROXStepCustomStepEvent(new Date(), inMessage, inStepInfo, inSubPlanIndex);
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mStep = new StepBean();
        this.mTarget = new TargetBean();
        String id = inFactory.getStepID();
        if (null != id) {
            this.setStepID(new StepID(id));
        }
        this.setSubPlanIndex(inFactory.getSubPlanIndex());
        id = inFactory.getTargetID();
        if (null != id) {
            this.setTargetID(new TargetID(id));
        }
        if (this.getStepID() != null || this.getTargetID() != null) {
            // empty if block
        }
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setStepID(this.getStepID());
        ref.setType(this.mQueryStepType == -1 ? this.getStepType() : this.mQueryStepType);
        ref.setTargetID(this.getTargetID());
        ref.setSubPlanIndex(this.getSubPlanIndex());
        if (this.getStepInfo() != null) {
            ref.setMap(this.getStepInfo().getStepMap());
            ref.setHostMap(this.getStepInfo().getHostStepMap());
            ref.setSkipped(this.getStepInfo().getSkipped());
            ref.setMappable(this.getStepInfo().getMappable());
        }
        return ref;
    }

    protected void formatKey(ROXEvent inoutRox, boolean inUseEventID) {
        super.formatKey(inoutRox, inUseEventID);
        ((ROXStepEvent)inoutRox).setStepID(this.getStepID());
    }

    protected void doLookup() {
        this.mStep.doLookup();
        this.mTarget.doLookup();
    }
}

