/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.ROXResourceEvent;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;
import java.util.Date;

public class ROXResourceUninstallEvent
extends ROXResourceEvent
implements ROXEventFactoryInterface {
    public ROXResourceUninstallEvent(Date inDate, String inMessage, InstalledResource installedResource, boolean isPreflight) {
        super(inDate, inMessage, installedResource, isPreflight);
    }

    public ROXResourceUninstallEvent() {
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.RESOURCEUNINSTALL_DESCRIPTION");
    }

    public String formatMessage() {
        String resourceName = "*";
        String componentName = "*";
        String targetName = "*";
        String planName = "*";
        if (null != this.getResourceID()) {
            resourceName = this.getResourceID().toString() + "*";
        }
        if (null != this.getComponentID()) {
            componentName = this.getComponentID().toString() + "*";
        }
        if (null != this.getTargetID()) {
            targetName = this.getTargetID().toString() + "*";
        }
        if (null != this.getExecutionPlanID()) {
            planName = this.getExecutionPlanID().toString() + "*";
        }
        if (null != this.getResourceInfo()) {
            resourceName = this.getResourceInfo().getResourceSpec().getName();
        }
        if (null != this.getComponent()) {
            componentName = this.getComponent().getName();
        }
        if (null != this.getTarget()) {
            targetName = this.getTarget().getCurrentHost().getName();
        }
        if (null != this.getExecutionPlan()) {
            planName = this.getExecutionPlan().getName();
        }
        return ROXMessageManager.messageAsString("event.RESOURCEUNINSTALL_MESSAGE", new Object[]{resourceName, componentName, targetName, planName, new Double(this.getIsPreflight() ? 1.0 : 0.0), this.getDate()});
    }
}

