/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXResourceInstallEvent;
import com.raplix.rolloutexpress.event.ROXResourceUninstallEvent;
import com.raplix.rolloutexpress.event.query.bean.InstalledResourceBean;
import com.raplix.rolloutexpress.event.query.bean.InstalledResourceInterface;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResourceID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import java.util.Date;

public abstract class ROXResourceEvent
extends ROXEvent
implements InstalledResourceInterface {
    private InstalledResourceBean mResource = new InstalledResourceBean();

    protected ROXResourceEvent(Date inDate, String inMessage, InstalledResource inInstalledResource, boolean isPreflight) {
        super(inDate, inMessage);
        this.setInstalledResource(inInstalledResource);
        this.setIsPreflight(isPreflight);
    }

    protected ROXResourceEvent() {
    }

    public InstalledResource getInstalledResource() {
        return this.mResource.getInstalledResource();
    }

    public InstalledResourceID getInstalledResourceID() {
        return this.mResource.getInstalledResourceID();
    }

    public void setInstalledResourceID(InstalledResourceID installedResourceID) {
        this.mResource.setInstalledResourceID(installedResourceID);
    }

    public void setInstalledResource(InstalledResource installedResource) {
        this.mResource.setInstalledResource(installedResource);
    }

    public ResourceID getResourceID() {
        return this.mResource.getResourceID();
    }

    public RsrcInfo getResourceInfo() {
        return this.mResource.getResourceInfo();
    }

    public String getResourceInstallPath() {
        return this.mResource.getResourceInstallPath();
    }

    public String getResourceRAInstallPath() {
        return this.mResource.getResourceRAInstallPath();
    }

    public String getComponentInstallPath() {
        return this.mResource.getComponentInstallPath();
    }

    public String getComponentRAInstallPath() {
        return this.mResource.getComponentRAInstallPath();
    }

    public InstalledComponent getInstalledComponent() {
        return this.mResource.getInstalledComponent();
    }

    public InstalledComponentID getInstalledComponentID() {
        return this.mResource.getInstalledComponentID();
    }

    public GeneratedVariableSettingsID getGeneratedVariableSettingsID() {
        return this.mResource.getGeneratedVariableSettingsID();
    }

    public TaskID getTaskID() {
        return this.mResource.getTaskID();
    }

    public ExecutionPlanID getExecutionPlanID() {
        return this.mResource.getExecutionPlanID();
    }

    public SummaryExecutionPlan getExecutionPlan() {
        return this.mResource.getExecutionPlan();
    }

    public TargetID getTargetID() {
        return this.mResource.getTargetID();
    }

    public Target getTarget() {
        return this.mResource.getTarget();
    }

    public ComponentID getComponentID() {
        return this.mResource.getComponentID();
    }

    public SummaryComponent getComponent() {
        return this.mResource.getComponent();
    }

    public static ROXResourceInstallEvent install(InstalledResource inInstalledResource, boolean isPreflight) {
        return new ROXResourceInstallEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inInstalledResource, isPreflight);
    }

    public static ROXResourceUninstallEvent uninstall(InstalledResource inInstalledResource, boolean isPreflight) {
        return new ROXResourceUninstallEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inInstalledResource, isPreflight);
    }

    public boolean getIsPreflight() {
        return this.mResource.getIsPreflight();
    }

    public void setIsPreflight(boolean isPreflight) {
        this.mResource.setIsPreflight(isPreflight);
    }

    public boolean preflightInUse() {
        return this.mResource.preflightInUse();
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mResource = new InstalledResourceBean();
        this.setIsPreflight(inFactory.getIsPreflight());
        String id = inFactory.getInstalledResourceID();
        if (null != id) {
            this.setInstalledResourceID(new InstalledResourceID(id));
        }
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setInstalledResourceID(this.getInstalledResourceID());
        ref.setPath(this.getResourceInstallPath());
        ref.setInstalledComponentID(this.getInstalledComponentID());
        if (this.preflightInUse()) {
            ref.setIsPreflight(this.getIsPreflight());
        }
        return ref;
    }

    protected String getClassSubsystemName() {
        return ResourceSubsystem.getClassSubsystemName();
    }

    protected void doLookup() {
        this.mResource.doLookup();
    }
}

