/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.difference.DifferenceID;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.ROXEventID;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.persist.ReEntrantTransaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResourceID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.logger.Logger;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;

public class ROXEventFactory
extends PersistentObject {
    private String mEventType;
    private Date mDate;
    private String mMessage;
    private HostID mHostID;
    private TargetID mTargetID;
    private int mSeverityCode;
    private String mSubsystemName;
    private String mControlServiceName;
    private TaskID mTaskID;
    private ExecutionPlanID mPlanID;
    private UserID mUserID;
    private String mUsername;
    private String mExceptionDescription;
    private CommandException mException;
    private DifferenceID mDifferenceID;
    private DifferenceJobID mDifferenceJobID;
    private DifferenceSettingsID mDifferenceSettingsID;
    private String mPath;
    private StepID mStepID;
    private int mType = -1;
    private boolean mIsPreflight;
    private boolean mUsePreflight = false;
    private boolean mSkipped;
    private boolean mMappable;
    private double mPercentDone;
    private int mMap = -1;
    private int mHostMap = -1;
    private int mSubPlanIndex = -1;
    private InstalledComponentID mInstalledComponentID;
    private InstalledResourceID mInstalledResourceID;
    private String mHostname;
    private String mHostIP;
    private String mNodeType;
    private Boolean mHandled = null;
    private static IDFactory idFactory = new IDFactory();

    public String getWhereSubclause() {
        StringBuffer output = new StringBuffer();
        String AND = " AND ";
        boolean andNeeded = false;
        if (this.mEventType != null && this.mEventType.length() != 0) {
            output.append("c_eventtype='").append(this.mEventType).append("'");
            andNeeded = true;
        }
        if (null != this.getObjectID()) {
            if (andNeeded) {
                output.append(" AND ");
            }
            output.append("objectid='").append(this.getObjectID()).append("'");
            andNeeded = true;
        }
        if (this.mMessage != null && this.mMessage.length() != 0) {
            if (andNeeded) {
                output.append(" AND ");
            }
            output.append("c_message like '").append(this.mMessage).append("%'");
            andNeeded = true;
        }
        if (null != this.mHostID) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_hostid='").append(this.mHostID.toString()).append("'");
        }
        if (null != this.mTargetID) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_targetid='").append(this.mTargetID.toString()).append("'");
        }
        if (null != this.mInstalledComponentID) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_installedcomponentid='").append(this.mInstalledComponentID.toString()).append("'");
        }
        if (null != this.mInstalledResourceID) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_installedresourceid='").append(this.mInstalledResourceID.toString()).append("'");
        }
        if (0 != this.mSeverityCode) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_severity=").append(this.mSeverityCode);
        }
        if (null != this.mSubsystemName && this.mSubsystemName.length() != 0) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_subsystem='").append(this.mSubsystemName).append("'");
        }
        if (null != this.mControlServiceName && this.mControlServiceName.length() != 0) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_controlservice='").append(this.mControlServiceName).append("'");
        }
        if (null != this.mTaskID) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_taskid='").append(this.mTaskID).append("'");
        }
        if (null != this.mStepID) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_stepid='").append(this.mStepID).append("'");
        }
        if (null != this.mPlanID) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_planid='").append(this.mPlanID).append("'");
        }
        if (null != this.mUserID) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_userid='").append(this.mUserID).append("'");
        }
        if (null != this.mUsername && this.mUsername.length() != 0) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_username='").append(this.mUsername).append("'");
        }
        if (null != this.mExceptionDescription && this.mExceptionDescription.length() != 0) {
            if (andNeeded) {
                output.append(" AND ");
            }
            output.append("c_exceptiondescription like '").append(this.mExceptionDescription).append("%'");
        }
        if (null != this.mDifferenceID) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_differenceid='").append(this.mDifferenceID).append("'");
        }
        if (null != this.mDifferenceJobID) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_differencejobid='").append(this.mDifferenceJobID).append("'");
        }
        if (null != this.mDifferenceSettingsID) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_differencesettingsid='").append(this.mDifferenceSettingsID).append("'");
        }
        if (null != this.mPath && this.mPath.length() != 0) {
            if (andNeeded) {
                output.append(" AND ");
            }
            output.append("c_path='").append(this.mPath).append("'");
        }
        if (-1 != this.mType) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_type=").append(this.mType);
        }
        if (-1 != this.mMap) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_map=").append(this.mMap);
        }
        if (-1 != this.mHostMap) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_hostmap=").append(this.mHostMap);
        }
        if (this.mUsePreflight) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_preflight=").append(this.mIsPreflight ? "true" : "false");
        }
        if (-1 != this.mSubPlanIndex) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_subplanindex=").append(this.mSubPlanIndex);
        }
        if (null != this.mHostname && this.mHostname.length() != 0) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_hostname='").append(this.mHostname).append("'");
        }
        if (null != this.mHostIP && this.mHostIP.length() != 0) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_hostip='").append(this.mHostIP).append("'");
        }
        if (null != this.mNodeType && this.mNodeType.length() != 0) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_nodetype='").append(this.mNodeType).append("'");
        }
        if (null != this.mHandled) {
            if (andNeeded) {
                output.append(" AND ");
            }
            andNeeded = true;
            output.append("c_handled=").append(this.mHandled);
        }
        return output.toString();
    }

    public ROXEvent instantiate() {
        ROXEventFactoryInterface re;
        try {
            re = (ROXEventFactoryInterface)Class.forName(this.mEventType).newInstance();
            re.reconstitute(this);
        }
        catch (ClassNotFoundException cnfe) {
            if (Logger.isDebugEnabled(this.getClass())) {
                Logger.debug(cnfe.toString(), this.getClass());
            }
            return null;
        }
        catch (InstantiationException ie) {
            if (Logger.isDebugEnabled(this.getClass())) {
                Logger.debug(ie.toString(), this.getClass());
            }
            return null;
        }
        catch (IllegalAccessException iae) {
            if (Logger.isDebugEnabled(this.getClass())) {
                Logger.debug(iae.toString(), this.getClass());
            }
            return null;
        }
        catch (ClassCastException cce) {
            if (Logger.isDebugEnabled(this.getClass())) {
                Logger.debug(cce.toString(), this.getClass());
            }
            return null;
        }
        return (ROXEvent)((Object)re);
    }

    public void setEventType(Class inEventType) {
        this.mEventType = inEventType == null ? "" : inEventType.getName();
    }

    public void setEventType(String inEventType) {
        this.mEventType = inEventType;
    }

    public String getEventType() {
        return this.mEventType;
    }

    public void setDate(Date inDate) {
        this.mDate = inDate;
    }

    public Date getDate() {
        return this.mDate;
    }

    public void setMessage(String inMessage) {
        this.mMessage = inMessage;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setHostID(HostID inHostID) {
        this.mHostID = inHostID;
    }

    public void setHostID(String inHostID) {
        this.mHostID = null == inHostID ? null : new HostID(inHostID);
    }

    public String getHostID() {
        if (null == this.mHostID) {
            return null;
        }
        return this.mHostID.toString();
    }

    public void setTargetID(TargetID inTargetID) {
        this.mTargetID = inTargetID;
    }

    public void setTargetID(String inTargetID) {
        this.mTargetID = null == inTargetID ? null : new TargetID(inTargetID);
    }

    public String getTargetID() {
        if (null == this.mTargetID) {
            return null;
        }
        return this.mTargetID.toString();
    }

    public void setInstalledComponentID(InstalledComponentID inInstalledComponentID) {
        this.mInstalledComponentID = inInstalledComponentID;
    }

    public void setInstalledComponentID(String inInstalledComponentID) {
        this.mInstalledComponentID = inInstalledComponentID == null ? null : new InstalledComponentID(inInstalledComponentID);
    }

    public String getInstalledComponentID() {
        if (null == this.mInstalledComponentID) {
            return null;
        }
        return this.mInstalledComponentID.toString();
    }

    public void setInstalledResourceID(InstalledResourceID inInstalledResourceID) {
        this.mInstalledResourceID = inInstalledResourceID;
    }

    public void setInstalledResourceID(String inInstalledResourceID) {
        this.mInstalledResourceID = inInstalledResourceID == null ? null : new InstalledResourceID(inInstalledResourceID);
    }

    public String getInstalledResourceID() {
        if (null == this.mInstalledResourceID) {
            return null;
        }
        return this.mInstalledResourceID.toString();
    }

    public void setSeverityCode(int inSeverityCode) {
        this.mSeverityCode = inSeverityCode;
    }

    public int getSeverityCode() {
        return this.mSeverityCode;
    }

    public void setSubsystemName(String inSubsystemName) {
        this.mSubsystemName = inSubsystemName;
    }

    public String getSubsystemName() {
        return this.mSubsystemName;
    }

    public void setControlServiceName(String inControlServiceName) {
        this.mControlServiceName = inControlServiceName;
    }

    public String getControlServiceName() {
        return this.mControlServiceName;
    }

    public void setTaskID(TaskID inTaskID) {
        this.mTaskID = inTaskID;
    }

    public void setTaskID(String inTaskID) {
        this.mTaskID = inTaskID == null ? null : new TaskID(inTaskID);
    }

    public String getTaskID() {
        if (null == this.mTaskID) {
            return null;
        }
        return this.mTaskID.toString();
    }

    public void setPlanID(ExecutionPlanID inPlanID) {
        this.mPlanID = inPlanID;
    }

    public void setPlanID(String inPlanID) {
        this.mPlanID = inPlanID == null ? null : new ExecutionPlanID(inPlanID);
    }

    public String getPlanID() {
        if (null == this.mPlanID) {
            return null;
        }
        return this.mPlanID.toString();
    }

    public void setUserID(UserID inUserID) {
        this.mUserID = inUserID;
    }

    public void setUserID(String inUserID) {
        this.mUserID = inUserID == null ? null : new UserID(inUserID);
    }

    public String getUserID() {
        if (null == this.mUserID) {
            return null;
        }
        return this.mUserID.toString();
    }

    public void setUsername(String inUsername) {
        this.mUsername = inUsername;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setDifferenceJobID(DifferenceJobID inDifferenceJobID) {
        this.mDifferenceJobID = inDifferenceJobID;
    }

    public void setDifferenceJobID(String inDifferenceJobID) {
        if (null != inDifferenceJobID) {
            this.mDifferenceJobID = new DifferenceJobID(inDifferenceJobID);
        }
    }

    public String getDifferenceJobID() {
        if (null == this.mDifferenceJobID) {
            return "";
        }
        return this.mDifferenceJobID.toString();
    }

    public void setDifferenceID(DifferenceID inDifferenceID) {
        this.mDifferenceID = inDifferenceID;
    }

    public void setDifferenceID(String inDifferenceID) {
        this.mDifferenceID = inDifferenceID == null ? null : new DifferenceID(inDifferenceID);
    }

    public String getDifferenceID() {
        if (null == this.mDifferenceID) {
            return null;
        }
        return this.mDifferenceID.toString();
    }

    public void setDifferenceSettingsID(DifferenceSettingsID inDifferenceSettingsID) {
        this.mDifferenceSettingsID = inDifferenceSettingsID;
    }

    public void setDifferenceSettingsID(String inDifferenceSettingsID) {
        this.mDifferenceSettingsID = inDifferenceSettingsID == null ? null : new DifferenceSettingsID(inDifferenceSettingsID);
    }

    public String getDifferenceSettingsID() {
        if (null == this.mDifferenceSettingsID) {
            return null;
        }
        return this.mDifferenceSettingsID.toString();
    }

    public void setExceptionDescription(String inExceptionDescription) {
        this.mExceptionDescription = inExceptionDescription;
    }

    public String getExceptionDescription() {
        return this.mExceptionDescription;
    }

    public void setException(CommandException inException) {
        this.mException = inException;
    }

    public CommandException getException() {
        return this.mException;
    }

    public void setPath(String inPath) {
        this.mPath = inPath;
    }

    public String getPath() {
        return this.mPath;
    }

    public void setStepID(StepID inStepID) {
        this.mStepID = inStepID;
    }

    public void setStepID(String inStepID) {
        this.mStepID = inStepID == null ? null : new StepID(inStepID);
    }

    public String getStepID() {
        if (null == this.mStepID) {
            return null;
        }
        return this.mStepID.toString();
    }

    public void setType(int inType) {
        this.mType = inType;
    }

    public int getType() {
        return this.mType;
    }

    public void setIsPreflight(boolean inIsPreflight) {
        this.mUsePreflight = true;
        this.mIsPreflight = inIsPreflight;
    }

    public boolean getIsPreflight() {
        return this.mIsPreflight;
    }

    public double getPercentDone() {
        return this.mPercentDone;
    }

    public void setPercentDone(double inPercentDone) {
        this.mPercentDone = inPercentDone;
    }

    public int getMap() {
        return this.mMap;
    }

    public void setMap(int inMap) {
        this.mMap = inMap;
    }

    public int getHostMap() {
        return this.mHostMap;
    }

    public boolean getSkipped() {
        return this.mSkipped;
    }

    public void setSkipped(boolean inSkipped) {
        this.mSkipped = inSkipped;
    }

    public boolean getMappable() {
        return this.mMappable;
    }

    public void setMappable(boolean inMappable) {
        this.mMappable = inMappable;
    }

    public void setHostMap(int inHostMap) {
        this.mHostMap = inHostMap;
    }

    public int getSubPlanIndex() {
        return this.mSubPlanIndex;
    }

    public void setSubPlanIndex(int inSubPlanIndex) {
        this.mSubPlanIndex = inSubPlanIndex;
    }

    public void setHostname(String inHostname) {
        this.mHostname = inHostname;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public void setHostIP(String inHostIP) {
        this.mHostIP = inHostIP;
    }

    public String getHostIP() {
        return this.mHostIP;
    }

    public void setNodeType(String inNodeType) {
        this.mNodeType = inNodeType;
    }

    public String getNodeType() {
        return this.mNodeType;
    }

    public boolean getHandled() {
        return this.mHandled == null ? false : this.mHandled;
    }

    public void setHandled(boolean inHandled) {
        this.mHandled = new Boolean(inHandled);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString()).append('\n');
        buf.append('\t').append("EventID: ").append(this.getObjectID()).append('\n');
        buf.append('\t').append("Type: ").append(this.getEventType()).append('\n');
        buf.append('\t').append("InstalledResourceID: ").append(this.getInstalledResourceID()).append('\n');
        buf.append('\t').append("InstalledComponentID: ").append(this.getInstalledComponentID()).append('\n');
        buf.append('\t').append("HostID: ").append(this.getHostID()).append('\n');
        buf.append('\t').append("TargetID: ").append(this.getTargetID()).append('\n');
        buf.append('\t').append("InstallPath: ").append(this.getPath()).append('\n');
        buf.append('\t').append("Handled: ").append(this.getHandled()).append('\n');
        return buf.toString();
    }

    static void saveMultipleEvents(LinkedList inEvents) throws PersistenceManagerException {
        ROXEventFactory[] events = new ROXEventFactory[inEvents.size()];
        ListIterator it = inEvents.listIterator(0);
        int i = 0;
        while (it.hasNext()) {
            events[i++] = ((ROXEvent)it.next()).prepareForPersist();
        }
        ROXEventFactory.retryOnDeadlock(new ReEntrantSave(events));
        it = inEvents.listIterator(0);
        i = 0;
        while (it.hasNext()) {
            ROXEvent event = (ROXEvent)it.next();
            event.reconstitute(events[i++]);
            event.setState(1);
        }
    }

    private static class ReEntrantSave
    implements ReEntrantTransaction {
        private ROXEventFactory[] mEvents;

        ReEntrantSave(ROXEventFactory[] inEvents) {
            this.mEvents = inEvents;
        }

        public Object execute() throws PersistenceManagerException {
            ROXEventFactory.saveMultipleMS(this.mEvents);
            return null;
        }
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new ROXEventID(inID);
        }
    }
}

