/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.NotificationManagerException;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.ROXEventID;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.util.logger.Logger;
import java.util.Comparator;
import java.util.Date;

public abstract class ROXEvent
implements RPCSerializable,
Messages,
HasObjectID {
    private ROXEventID mEventID;
    private long mDate;
    private String mMessage;
    private int mSeverityCode;
    private transient Exception mProcessException = null;
    private transient int mState = 0;
    private Visibility mVisibility = Visibility.VISIBLE;
    public boolean shouldInsert = true;
    public static final int DEFAULT = 0;
    public static final int SAVED = 1;
    public static final int NOTIFIED = 2;
    public static final int ERROR = 4;
    public static final int WARNING = 3;
    public static final int INFO = 2;
    public static final int DEBUG = 1;
    public static final int ALL = 0;
    public static final String LOOKUP_MESSAGE = "EXECUTE LOOKUP ON THIS MESSAGE";
    protected static final String USING_ID = "*";

    public int getSeverity() {
        return this.mSeverityCode;
    }

    public Date getDate() {
        return new Date(this.mDate);
    }

    public void setDate(Date inDate) {
        this.mDate = null == inDate ? 0L : inDate.getTime();
    }

    public ROXEventID getEventID() {
        return this.mEventID;
    }

    public void setEventID(ROXEventID inEventID) {
        this.mEventID = inEventID;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setMessage(String inMessage) {
        this.mMessage = inMessage != null && inMessage.length() > 512 ? inMessage.substring(0, 512) : inMessage;
    }

    public void setSeverity(int inSeverityCode) {
        this.mSeverityCode = inSeverityCode;
    }

    protected ROXEvent() {
        this.setSeverity(2);
    }

    public ROXEvent(Date inDate, String inMessage) {
        this();
        this.setDate(inDate);
        this.setMessage(inMessage);
    }

    public ROXEvent(Date inDate, String inMessage, int inSeverity) {
        this();
        this.setDate(inDate);
        this.setMessage(inMessage);
        this.setSeverity(inSeverity);
    }

    public static Comparator getDateComparator() {
        return new Comparator(){

            public int compare(Object a, Object b) {
                long timeB;
                long timeA = ((ROXEvent)a).getDate().getTime();
                if (timeA == (timeB = ((ROXEvent)b).getDate().getTime())) {
                    return 0;
                }
                if (timeA > timeB) {
                    return 1;
                }
                return -1;
            }
        };
    }

    public void reconstitute(ROXEventFactory inFactory) {
        this.setDate(inFactory.getDate());
        this.setMessage(inFactory.getMessage());
        this.setSeverity(inFactory.getSeverityCode());
        this.setEventID((ROXEventID)inFactory.getObjectID());
        this.setVisibility(inFactory.getVisibility());
    }

    protected abstract void doLookup();

    protected void checkMessage() {
        if (null != this.getMessage() && this.getMessage().equals(LOOKUP_MESSAGE)) {
            this.doLookup();
            this.setMessage(this.formatMessage());
        }
    }

    protected String formatMessage() {
        StringBuffer output = new StringBuffer(this.describe());
        String stamp = ROXMessageManager.messageAsString("general.SHORTDATE", new Object[]{this.getDate()});
        output.append(" (").append(stamp).append(")");
        return output.toString();
    }

    public void welcomeToTheServer(NotificationManager inNotificationManager) {
        this.checkMessage();
    }

    public void notify(NotificationManager inNM) {
        this.notify(true, inNM);
    }

    public void notify(boolean inWait, NotificationManager inNM) {
        if (inWait) {
            inNM.notifyAndWait(this);
        } else {
            inNM.notify(this);
        }
    }

    public void save(NotificationManager inNM) throws NotificationManagerException {
        ROXEventFactoryInterface rox = null;
        ROXEventFactory factory = null;
        if (!this.beforeSave(inNM)) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("event.PRESAVE_FAILED"), this);
            }
            return;
        }
        try {
            rox = (ROXEventFactoryInterface)((Object)this);
            factory = rox.prepareForPersist();
            factory.setPersistent(!this.shouldInsert);
            factory.save();
            this.setEventID((ROXEventID)factory.getObjectID());
        }
        catch (ClassCastException cce) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Event " + this + " does not want to persist", this);
            }
        }
        catch (Exception e) {
            throw new NotificationManagerException("event.SAVE_FAILED", (Throwable)e);
        }
        this.afterSave(inNM);
    }

    protected boolean beforeSave(NotificationManager inNM) {
        return true;
    }

    protected void afterSave(NotificationManager inNM) {
    }

    protected ROXEvent getKeyObject(boolean inUseEventID) throws InstantiationException, IllegalAccessException, IllegalArgumentException {
        ROXEvent output = (ROXEvent)this.getClass().newInstance();
        this.formatKey(output, inUseEventID);
        return output;
    }

    protected void formatKey(ROXEvent inoutRox, boolean inUseEventID) throws IllegalArgumentException {
        if (inUseEventID) {
            inoutRox.setEventID(this.getEventID());
        }
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = new ROXEventFactory();
        ref.setDate(this.getDate());
        ref.setMessage(this.getMessage());
        ref.setEventType(this.getClass());
        ref.setObjectID(this.getEventID());
        ref.setSeverityCode(this.getSeverity());
        ref.setVisibility(this.mVisibility);
        return ref;
    }

    public boolean equals(ROXEvent inObject) {
        return inObject != null && this.mEventID.equals(inObject.getEventID());
    }

    public boolean equals(Object inObject) {
        if (this == inObject) {
            return true;
        }
        if (inObject != null && inObject instanceof ROXEvent) {
            return this.equals((ROXEvent)inObject);
        }
        return false;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append(this.getEventID()).append("|").append(this.describe()).append("|").append(this.getMessage()).append("|").append(this.getClass());
        return output.toString();
    }

    public abstract String describe();

    public String getEmailContent() {
        String url;
        String endl;
        StringBuffer output;
        block5: {
            output = new StringBuffer();
            endl = "\r\n";
            String stamp = ROXMessageManager.messageAsString("general.LONGDATE", new Object[]{this.getDate()});
            output.append(this.describe()).append(" - ").append(stamp);
            int len = output.length();
            output.append(endl);
            for (int count = 1; count <= len; ++count) {
                output.append('=');
            }
            output.append(endl);
            this.checkMessage();
            output.append(this.getMessage()).append(endl);
            output.append(endl);
            url = ROXMessageManager.messageAsString("event.CANT_FIND_URL");
            try {
                url = Application.getApp().getNotificationManager().getUrl();
            }
            catch (ConfigurationException ce) {
                if (Logger.isWarnEnabled(this)) {
                    Logger.warn(ROXMessageManager.messageAsString("event.CANT_RETRIEVE_URL", new Object[]{Application.getApp().getDefaultConfigurationFileName()}), ce, this);
                }
            }
            catch (UnsupportedSubsystemException use) {
                if (!Logger.isWarnEnabled(this)) break block5;
                Logger.warn(ROXMessageManager.messageAsString("event.CANT_RETRIEVE_URL", new Object[]{Application.getApp().getDefaultConfigurationFileName()}), use, this);
            }
        }
        output.append(ROXMessageManager.messageAsString("event.EMAIL_FOOTER", new Object[]{url})).append(endl);
        return output.toString();
    }

    public synchronized Exception getProcessException() {
        return this.mProcessException;
    }

    protected synchronized void setProcessException(Exception inException) {
        this.mProcessException = inException;
        if (inException != null) {
            this.notify();
        }
    }

    public synchronized int getState() {
        return this.mState;
    }

    protected synchronized void setState(int inState) {
        this.mState = inState;
        if (inState == 2) {
            this.notify();
        }
    }

    protected synchronized void waitForNotification() throws InterruptedException {
        while (!this.isNotified()) {
            this.wait();
        }
    }

    private boolean isNotified() {
        return this.getState() == 2 || this.getProcessException() != null;
    }

    public static int chooseSeverity(int inS1, int inS2) {
        if (inS1 == 4 || inS2 == 4) {
            return 4;
        }
        if (inS1 == 3 || inS2 == 3) {
            return 3;
        }
        if (inS1 == 2 || inS2 == 2) {
            return 2;
        }
        if (inS1 == 1 || inS2 == 1) {
            return 1;
        }
        return 0;
    }

    public void setVisibility(Visibility inVisibility) {
        this.mVisibility = inVisibility;
    }

    public Visibility getVisibility() {
        return this.mVisibility;
    }

    public ObjectID getObjectID() {
        return this.getEventID();
    }

    public ROXEventID getID() {
        return this.getEventID();
    }
}

