/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.ROXAbnormalEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.query.bean.ExceptionBean;
import com.raplix.rolloutexpress.event.query.bean.ExceptionInterface;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import java.util.Date;

public class ROXErrorEvent
extends ROXAbnormalEvent
implements ExceptionInterface,
ROXEventFactoryInterface,
Messages {
    private ExceptionBean mException = new ExceptionBean();

    public ROXErrorEvent(Date inDate, String inMessage, String inSubsystemName, CommandException inException) {
        this(inDate, inMessage, inSubsystemName);
        this.mException.setException(inException);
    }

    public ROXErrorEvent(Date inDate, String inMessage, String inSubsystemName) {
        super(inDate, inMessage, 4, inSubsystemName);
    }

    public ROXErrorEvent() {
        this.setSeverity(4);
    }

    public void setException(CommandException inException) {
        this.mException.setException(inException);
    }

    public CommandException getException() {
        return this.mException.getException();
    }

    public void setExceptionDescription(String inExceptionDescription) {
        this.mException.setExceptionDescription(inExceptionDescription);
    }

    public String getExceptionDescription() {
        return this.mException.getExceptionDescription();
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setExceptionDescription(this.getExceptionDescription());
        ref.setException(this.getException());
        return ref;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mException = new ExceptionBean();
        this.setExceptionDescription(inFactory.getExceptionDescription());
        if (null != inFactory.getException()) {
            this.setException(inFactory.getException());
        }
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.ERROR_DESCRIPTION");
    }

    protected void doLookup() {
        this.mException.doLookup();
    }
}

