/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.AffectedHost;
import com.raplix.rolloutexpress.event.HostStatus;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.ROXDifferenceEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import java.util.Date;
import java.util.Vector;

public class ROXDifferenceStartEvent
extends ROXDifferenceEvent
implements ROXEventFactoryInterface,
Messages,
AffectedHost {
    public ROXDifferenceStartEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID) {
        super(inDate, inMessage, 2, inDifferenceJobID);
        this.setDifferenceSettingsID(inDifferenceSettingsID);
    }

    public ROXDifferenceStartEvent() {
        this.setSeverity(2);
    }

    protected ROXEvent getKeyObject(boolean inUseEventID) throws InstantiationException, IllegalAccessException {
        ROXDifferenceStartEvent output = (ROXDifferenceStartEvent)super.getKeyObject(inUseEventID);
        output.setDifferenceSettingsID(this.getDifferenceSettingsID());
        return output;
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.DIFFERENCESTART_DESCRIPTION");
    }

    public String formatMessage() {
        String differenceName = this.getDifferenceSettingsID().toString() + "*";
        if (null != this.getDifferenceSettings()) {
            differenceName = this.getDifferenceSettings().getName();
        }
        return ROXMessageManager.messageAsString("event.DIFFERENCESTART_MESSAGE", new Object[]{this.getDate(), differenceName});
    }

    public HostStatus[] getAllAffectedHosts() {
        Vector theHosts = this.getDifferenceSettings().getAffectedHosts();
        HostStatus[] theStatus = new HostStatus[theHosts.size()];
        for (int i = 0; i < theHosts.size(); ++i) {
            HostID currHostID = (HostID)theHosts.get(i);
            theStatus[i] = new HostStatus(currHostID, 3);
        }
        return theStatus;
    }

    public HostStatus getHostStatus(HostID inID) {
        Vector theHosts = this.getDifferenceSettings().getAffectedHosts();
        HostStatus theStatus = null;
        if (theHosts.contains(inID)) {
            theStatus = new HostStatus(inID, 3);
        }
        return theStatus;
    }
}

