/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.EmptyQueryException;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.ROXDifferenceEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.query.bean.ProgressBean;
import com.raplix.rolloutexpress.event.query.bean.ProgressInterface;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.util.logger.Logger;
import java.util.Date;

public class ROXDifferenceProgressEvent
extends ROXDifferenceEvent
implements ROXEventFactoryInterface,
ProgressInterface,
Messages {
    private ProgressBean mProgress = new ProgressBean();

    public ROXDifferenceProgressEvent() {
        this.setSeverity(1);
    }

    public ROXDifferenceProgressEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID, double inProgress) {
        super(inDate, inMessage, 1, inDifferenceJobID);
        this.mProgress.setProgress(inProgress);
    }

    public ROXDifferenceProgressEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID, double inProgress) {
        super(inDate, inMessage, 1, inDifferenceJobID, inDifferenceSettingsID);
        this.mProgress.setProgress(inProgress);
    }

    public double getProgress() {
        return this.mProgress.getProgress();
    }

    public void setProgress(double inProgress) {
        this.mProgress.setProgress(inProgress);
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setPercentDone(this.getProgress());
        return ref;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mProgress = new ProgressBean();
        this.setProgress(inFactory.getPercentDone());
    }

    protected boolean beforeSave(NotificationManager inNM) {
        ROXEvent[] input = new ROXEvent[1];
        try {
            input[0] = this.getKeyObject(false);
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("event.PROGRESS_KEY_CREATION_ERROR"), e, this);
            }
            return false;
        }
        try {
            ROXEvent[] output = inNM.query(input);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("ProgressEvent " + this + " has a precursor(" + output[0] + ") - proceed with update", this);
            }
            this.setEventID(output[0].getEventID());
            this.shouldInsert = false;
        }
        catch (EmptyQueryException eqe) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("ProgressEvent " + this + " has no precursor - continue with add", this);
            }
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(ROXMessageManager.messageAsString("event.PROGRESS_EVENT_RETRIEVAL_ERROR"), e, this);
            }
            return false;
        }
        return true;
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.DIFFERENCEPROGRESS_DESCRIPTION");
    }

    protected void doLookup() {
        this.mProgress.doLookup();
    }

    public String formatMessage() {
        String differenceName = ROXMessageManager.messageAsString("event.NO_DIFFERENCE_SETTINGS");
        if (null != this.getDifferenceSettingsID()) {
            differenceName = this.getDifferenceSettingsID().toString() + "*";
        }
        if (null != this.getDifferenceSettings()) {
            differenceName = this.getDifferenceSettings().getName();
        }
        return ROXMessageManager.messageAsString("event.DIFFERENCEPROGRESS_MESSAGE", new Object[]{new Double(this.getProgress()), this.getDate(), differenceName});
    }
}

