/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.ROXDifferenceEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.query.bean.ExceptionBean;
import com.raplix.rolloutexpress.event.query.bean.ExceptionInterface;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import java.util.Date;

public class ROXDifferenceJobFailedEvent
extends ROXDifferenceEvent
implements ExceptionInterface,
ROXEventFactoryInterface,
Messages {
    private ExceptionBean mException = new ExceptionBean();

    public ROXDifferenceJobFailedEvent() {
        this.setSeverity(4);
    }

    public ROXDifferenceJobFailedEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID, CommandException inEx) {
        super(inDate, inMessage, 4, inDifferenceJobID, inDifferenceSettingsID);
        this.mException.setException(inEx);
    }

    public ROXDifferenceJobFailedEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID, CommandException inEx) {
        super(inDate, inMessage, 4, inDifferenceJobID);
        this.mException.setException(inEx);
    }

    public ROXDifferenceJobFailedEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID) {
        super(inDate, inMessage, 4, inDifferenceJobID, inDifferenceSettingsID);
    }

    public ROXDifferenceJobFailedEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID) {
        super(inDate, inMessage, 4, inDifferenceJobID);
    }

    public void setException(CommandException inException) {
        this.mException.setException(inException);
    }

    public CommandException getException() {
        return this.mException.getException();
    }

    public void setExceptionDescription(String inExceptionDescription) {
        this.mException.setExceptionDescription(inExceptionDescription);
    }

    public String getExceptionDescription() {
        return this.mException.getExceptionDescription();
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setExceptionDescription(this.getExceptionDescription());
        return ref;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mException = new ExceptionBean();
        this.setExceptionDescription(inFactory.getExceptionDescription());
        if (null != inFactory.getException()) {
            this.setException(inFactory.getException());
        }
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.DIFFERENCEJOBFAILED_DESCRIPTION");
    }

    protected void doLookup() {
        this.mException.doLookup();
    }

    public String formatMessage() {
        String differenceName = ROXMessageManager.messageAsString("event.NO_DIFFERENCE_SETTINGS");
        if (null != this.getDifferenceSettingsID()) {
            differenceName = this.getDifferenceSettingsID().toString() + "*";
        }
        if (null != this.getDifferenceSettings()) {
            differenceName = this.getDifferenceSettings().getName();
        }
        CommandException e = this.getException();
        return ROXMessageManager.messageAsString("event.DIFFERENCEJOBFAILED_MESSAGE", new Object[]{new Double(null == e ? 0.0 : 1.0), null == e ? null : ((Throwable)e).getMessage(), this.getDate(), differenceName});
    }
}

