/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.DifferenceID;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.ROXDifferenceEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.query.bean.DifferenceBean;
import com.raplix.rolloutexpress.event.query.bean.DifferenceInterface;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import java.util.Date;

public class ROXDifferenceFoundEvent
extends ROXDifferenceEvent
implements ROXEventFactoryInterface,
DifferenceInterface,
Messages {
    private DifferenceBean mDifference = new DifferenceBean();

    public ROXDifferenceFoundEvent() {
        this.setSeverity(3);
    }

    public ROXDifferenceFoundEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID, DifferenceID inDifferenceID, DifferenceSettingsID inDifferenceSettingsID, String inPath, int inType) {
        super(inDate, inMessage, 3, inDifferenceJobID, inDifferenceSettingsID);
        this.mDifference.setDifferenceID(inDifferenceID);
        this.mDifference.setDifferencePath(inPath);
        this.mDifference.setDifferenceType(inType);
    }

    public ROXDifferenceFoundEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID, DifferenceID inDifferenceID, String inPath, int inType) {
        super(inDate, inMessage, 3, inDifferenceJobID);
        this.mDifference.setDifferenceID(inDifferenceID);
        this.mDifference.setDifferencePath(inPath);
        this.mDifference.setDifferenceType(inType);
    }

    public DifferenceID getDifferenceID() {
        return this.mDifference.getDifferenceID();
    }

    public void setDifferenceID(DifferenceID inDifferenceID) {
        this.mDifference.setDifferenceID(inDifferenceID);
    }

    public Difference getDifference() {
        return this.mDifference.getDifference();
    }

    public String getDifferencePath() {
        return this.mDifference.getDifferencePath();
    }

    public void setDifferencePath(String inPath) {
        this.mDifference.setDifferencePath(inPath);
    }

    public int getDifferenceType() {
        return this.mDifference.getDifferenceType();
    }

    public void setDifferenceType(int inDifferenceType) {
        this.mDifference.setDifferenceType(inDifferenceType);
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setDifferenceID(this.getDifferenceID());
        ref.setPath(this.getDifferencePath());
        ref.setType(this.getDifferenceType());
        return ref;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mDifference = new DifferenceBean();
        this.setDifferencePath(inFactory.getPath());
        this.setDifferenceType(inFactory.getType());
        String id = inFactory.getDifferenceID();
        if ("" != id) {
            this.setDifferenceID(new DifferenceID(inFactory.getDifferenceID()));
        }
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.DIFFERENCEFOUND_DESCRIPTION");
    }

    protected void doLookup() {
        super.doLookup();
        this.mDifference.doLookup();
    }

    public String formatMessage() {
        String differenceName = "*";
        String differenceSettingsName = ROXMessageManager.messageAsString("event.NO_DIFFERENCE_SETTINGS");
        if (null != this.getDifferenceID()) {
            differenceName = this.getDifferenceID().toString() + "*";
        }
        if (null != this.getDifferenceSettingsID()) {
            differenceSettingsName = this.getDifferenceSettingsID().toString() + "*";
        }
        if (null != this.getDifference() && null != this.getDifference().getIdentifier()) {
            differenceName = this.getDifference().getIdentifier();
        }
        if (null != this.getDifferenceSettings()) {
            differenceSettingsName = this.getDifferenceSettings().getName();
        }
        return ROXMessageManager.messageAsString("event.DIFFERENCEFOUND_MESSAGE", new Object[]{differenceName, this.getDifferencePath(), this.getDate(), differenceSettingsName});
    }
}

