/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.AffectedHost;
import com.raplix.rolloutexpress.event.HostStatus;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.ROXDifferenceEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceStartEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.query.bean.ExceptionBean;
import com.raplix.rolloutexpress.event.query.bean.ExceptionInterface;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.util.logger.Logger;
import java.util.Date;
import java.util.Vector;

public class ROXDifferenceFailedEvent
extends ROXDifferenceEvent
implements ExceptionInterface,
ROXEventFactoryInterface,
Messages,
AffectedHost {
    private ExceptionBean mException = new ExceptionBean();

    public ROXDifferenceFailedEvent() {
        this.setSeverity(4);
    }

    public ROXDifferenceFailedEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID, CommandException inEx) {
        super(inDate, inMessage, 4, inDifferenceJobID, inDifferenceSettingsID);
        this.mException.setException(inEx);
    }

    public ROXDifferenceFailedEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID, CommandException inEx) {
        super(inDate, inMessage, 4, inDifferenceJobID);
        this.mException.setException(inEx);
    }

    public ROXDifferenceFailedEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID) {
        super(inDate, inMessage, 4, inDifferenceJobID, inDifferenceSettingsID);
    }

    public ROXDifferenceFailedEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID) {
        super(inDate, inMessage, 4, inDifferenceJobID);
    }

    public void setException(CommandException inException) {
        this.mException.setException(inException);
    }

    public CommandException getException() {
        return this.mException.getException();
    }

    public void setExceptionDescription(String inExceptionDescription) {
        this.mException.setExceptionDescription(inExceptionDescription);
    }

    public String getExceptionDescription() {
        return this.mException.getExceptionDescription();
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setExceptionDescription(this.getExceptionDescription());
        ref.setException(this.getException());
        return ref;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mException = new ExceptionBean();
        this.setExceptionDescription(inFactory.getExceptionDescription());
        if (null != inFactory.getException()) {
            this.setException(inFactory.getException());
        }
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.DIFFERENCEFAILED_DESCRIPTION");
    }

    protected void doLookup() {
        this.mException.doLookup();
    }

    public String formatMessage() {
        String differenceName = ROXMessageManager.messageAsString("event.NO_DIFFERENCE_SETTINGS");
        if (null != this.getDifferenceSettingsID()) {
            differenceName = this.getDifferenceSettingsID().toString() + "*";
        }
        if (null != this.getDifferenceSettings()) {
            differenceName = this.getDifferenceSettings().getName();
        }
        String e = this.getExceptionDescription();
        return ROXMessageManager.messageAsString("event.DIFFERENCEFAILED_MESSAGE", new Object[]{new Integer(null == e ? 0 : 1), null == e ? null : e, this.getDate(), differenceName});
    }

    public HostStatus getHostStatus(HostID inID) {
        Vector theHosts = this.getAffectedHosts();
        HostStatus theHostStatus = null;
        if (theHosts != null && theHosts.contains(inID)) {
            theHostStatus = new HostStatus(inID, 2);
        }
        return theHostStatus;
    }

    public HostStatus[] getAllAffectedHosts() {
        Vector theHosts = this.getAffectedHosts();
        if (theHosts == null) {
            return new HostStatus[0];
        }
        HostStatus[] theHostStatus = new HostStatus[theHosts.size()];
        for (int i = 0; i < theHosts.size(); ++i) {
            HostID currHostID = (HostID)theHosts.get(i);
            theHostStatus[i] = new HostStatus(currHostID, 2);
        }
        return theHostStatus;
    }

    public Vector getAffectedHosts() {
        DifferenceSettings settings;
        Object[] events;
        block4: {
            ROXDifferenceStartEvent theQuery = new ROXDifferenceStartEvent();
            theQuery.setDifferenceJobID(this.getDifferenceJobID());
            ROXEvent[] queryArray = new ROXEvent[]{theQuery};
            events = null;
            try {
                NotificationManager theNM = Application.getApp().getNotificationManager();
                events = theNM.query(queryArray);
            }
            catch (Exception e) {
                if (!Logger.isErrorEnabled(this)) break block4;
                Logger.error(ROXMessageManager.messageAsString("event.EVENTQUERY_FAILED"), e, this);
            }
        }
        if (Logger.isWarnEnabled(this)) {
            Logger.warn(ROXMessageManager.messageAsString("event.FOUND_EVENTS", events), this);
        }
        if (events != null && events.length > 0 && events[0] != null && (settings = ((ROXDifferenceStartEvent)events[0]).getDifferenceSettings()) != null) {
            return settings.getAffectedHosts();
        }
        return null;
    }
}

