/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.difference.DifferenceID;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.EmptyQueryException;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.NotificationManagerException;
import com.raplix.rolloutexpress.event.ROXDifferenceAbortEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceAbortRequestedEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceCompleteEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceFailedEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceFoundEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceJobFailedEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceProgressEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceStartEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.query.bean.DifferenceJobBean;
import com.raplix.rolloutexpress.event.query.bean.DifferenceJobInterface;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import java.util.Date;
import java.util.Vector;

public abstract class ROXDifferenceEvent
extends ROXEvent
implements DifferenceJobInterface {
    private DifferenceJobBean mDifferenceJob = new DifferenceJobBean();

    protected ROXDifferenceEvent() {
    }

    public ROXDifferenceEvent(Date inDate, String inMessage, int inSeverity, DifferenceJobID inDifferenceJobID) {
        super(inDate, inMessage, inSeverity);
        this.setDifferenceJobID(inDifferenceJobID);
        this.findDifferenceSettingsID();
    }

    public ROXDifferenceEvent(Date inDate, String inMessage, int inSeverity, DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID) {
        super(inDate, inMessage, inSeverity);
        this.setDifferenceJobID(inDifferenceJobID);
        this.setDifferenceSettingsID(inDifferenceSettingsID);
    }

    public DifferenceJobID getDifferenceJobID() {
        return this.mDifferenceJob.getDifferenceJobID();
    }

    public void setDifferenceJobID(DifferenceJobID inDifferenceJobID) {
        this.mDifferenceJob.setDifferenceJobID(inDifferenceJobID);
    }

    public DifferenceSettings getDifferenceSettings() {
        return this.mDifferenceJob.getDifferenceSettings();
    }

    public DifferenceSettingsID getDifferenceSettingsID() {
        return this.mDifferenceJob.getDifferenceSettingsID();
    }

    public void setDifferenceSettingsID(DifferenceSettingsID inDifferenceSettingsID) {
        this.mDifferenceJob.setDifferenceSettingsID(inDifferenceSettingsID);
    }

    public static ROXDifferenceStartEvent start(DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID) {
        return new ROXDifferenceStartEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID, inDifferenceSettingsID);
    }

    public static ROXDifferenceAbortEvent abort(DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID) {
        return new ROXDifferenceAbortEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID, inDifferenceSettingsID);
    }

    public static ROXDifferenceAbortEvent abort(DifferenceJobID inDifferenceJobID) {
        return new ROXDifferenceAbortEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID);
    }

    public static ROXDifferenceAbortRequestedEvent abortRequested(DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID) {
        return new ROXDifferenceAbortRequestedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID, inDifferenceSettingsID);
    }

    public static ROXDifferenceAbortRequestedEvent abortRequested(DifferenceJobID inDifferenceJobID) {
        return new ROXDifferenceAbortRequestedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID);
    }

    public static ROXDifferenceFailedEvent failed(DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID) {
        return new ROXDifferenceFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID, inDifferenceSettingsID);
    }

    public static ROXDifferenceJobFailedEvent jobFailed(DifferenceJobID inDifferenceJobID, CommandException inException) {
        return new ROXDifferenceJobFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID, inException);
    }

    public static ROXDifferenceFailedEvent failed(DifferenceJobID inDifferenceJobID) {
        return new ROXDifferenceFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID);
    }

    public static ROXDifferenceFailedEvent failed(DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID, CommandException inException) {
        return new ROXDifferenceFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID, inDifferenceSettingsID, inException);
    }

    public static ROXDifferenceFailedEvent failed(DifferenceJobID inDifferenceJobID, CommandException inException) {
        return new ROXDifferenceFailedEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID, inException);
    }

    public static ROXDifferenceCompleteEvent complete(DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID) {
        return new ROXDifferenceCompleteEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID, inDifferenceSettingsID);
    }

    public static ROXDifferenceCompleteEvent complete(DifferenceJobID inDifferenceJobID) {
        return new ROXDifferenceCompleteEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID);
    }

    public static ROXDifferenceFoundEvent found(DifferenceJobID inDifferenceJobID, DifferenceID inDifferenceID, DifferenceSettingsID inDifferenceSettingsID, String inPath, int inType) {
        return new ROXDifferenceFoundEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID, inDifferenceID, inDifferenceSettingsID, inPath, inType);
    }

    public static ROXDifferenceFoundEvent found(DifferenceJobID inDifferenceJobID, DifferenceID inDifferenceID, String inPath, int inType) {
        return new ROXDifferenceFoundEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID, inDifferenceID, inPath, inType);
    }

    public static ROXDifferenceProgressEvent progress(DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID, double inPercentDone) {
        return new ROXDifferenceProgressEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID, inDifferenceSettingsID, inPercentDone);
    }

    public static ROXDifferenceProgressEvent progress(DifferenceJobID inDifferenceJobID, double inPercentDone) {
        return new ROXDifferenceProgressEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inDifferenceJobID, inPercentDone);
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mDifferenceJob = new DifferenceJobBean();
        String id = inFactory.getDifferenceJobID();
        if ("" != id) {
            this.setDifferenceJobID(new DifferenceJobID(id));
        }
        if (null != (id = inFactory.getDifferenceSettingsID())) {
            this.setDifferenceSettingsID(new DifferenceSettingsID(id));
        }
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setDifferenceJobID(this.getDifferenceJobID());
        ref.setDifferenceSettingsID(this.getDifferenceSettingsID());
        return ref;
    }

    protected ROXEvent getKeyObject(boolean inUseEventID) throws InstantiationException, IllegalAccessException {
        ROXDifferenceEvent output = (ROXDifferenceEvent)super.getKeyObject(inUseEventID);
        output.setDifferenceJobID(this.getDifferenceJobID());
        return output;
    }

    protected void doLookup() {
        this.findDifferenceSettingsID();
        this.mDifferenceJob.doLookup();
    }

    private void findDifferenceSettingsID() {
        Application app = Server.getApp();
        if (null != app) {
            try {
                NotificationManager nm = app.getNotificationManager();
                ROXDifferenceStartEvent rox = new ROXDifferenceStartEvent();
                rox.setDifferenceJobID(this.getDifferenceJobID());
                Vector<ROXDifferenceStartEvent> input = new Vector<ROXDifferenceStartEvent>();
                input.add(rox);
                Vector output = nm.query(input);
                if (!output.isEmpty()) {
                    rox = (ROXDifferenceStartEvent)output.get(0);
                    this.setDifferenceSettingsID(rox.getDifferenceSettingsID());
                }
            }
            catch (UnsupportedSubsystemException use) {
            }
            catch (NotificationManagerException nme) {
            }
            catch (RPCException rpce) {
            }
            catch (EmptyQueryException emptyQueryException) {
                // empty catch block
            }
        }
    }
}

