/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.AffectedHost;
import com.raplix.rolloutexpress.event.HostStatus;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.ROXDifferenceEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceFailedEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import java.util.Date;
import java.util.Vector;

public class ROXDifferenceCompleteEvent
extends ROXDifferenceEvent
implements ROXEventFactoryInterface,
Messages,
AffectedHost {
    public ROXDifferenceCompleteEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID, DifferenceSettingsID inDifferenceSettingsID) {
        super(inDate, inMessage, 2, inDifferenceJobID, inDifferenceSettingsID);
    }

    public ROXDifferenceCompleteEvent(Date inDate, String inMessage, DifferenceJobID inDifferenceJobID) {
        super(inDate, inMessage, 2, inDifferenceJobID);
    }

    public ROXDifferenceCompleteEvent() {
        this.setSeverity(2);
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        String id = inFactory.getDifferenceSettingsID();
        if (null != id) {
            this.setDifferenceSettingsID(new DifferenceSettingsID(id));
        }
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setDifferenceSettingsID(this.getDifferenceSettingsID());
        return ref;
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.DIFFERENCECOMPLETE_DESCRIPTION");
    }

    public String formatMessage() {
        String differenceName = ROXMessageManager.messageAsString("event.NO_DIFFERENCE_SETTINGS");
        if (null != this.getDifferenceSettingsID()) {
            differenceName = this.getDifferenceSettingsID().toString() + "*";
        }
        if (null != this.getDifferenceSettings()) {
            differenceName = this.getDifferenceSettings().getName();
        }
        return ROXMessageManager.messageAsString("event.DIFFERENCECOMPLETE_MESSAGE", new Object[]{this.getDate(), differenceName});
    }

    public HostStatus[] getAllAffectedHosts() {
        Vector theHosts = this.getDifferenceSettings().getAffectedHosts();
        HostStatus[] theHostStatus = new HostStatus[theHosts.size()];
        int theStatus = this.getGlobalHostStatus(this.getDifferenceJobID());
        for (int i = 0; i < theHosts.size(); ++i) {
            HostID currHostID = (HostID)theHosts.get(i);
            theHostStatus[i] = new HostStatus(currHostID, theStatus);
        }
        return theHostStatus;
    }

    public HostStatus getHostStatus(HostID inID) {
        Vector theHosts = this.getDifferenceSettings().getAffectedHosts();
        HostStatus theHostStatus = null;
        int theStatus = this.getGlobalHostStatus(this.getDifferenceJobID());
        if (theHosts.contains(inID)) {
            theHostStatus = new HostStatus(inID, theStatus);
        }
        return theHostStatus;
    }

    private int getGlobalHostStatus(DifferenceJobID inJobID) {
        ROXDifferenceFailedEvent theQuery = new ROXDifferenceFailedEvent();
        theQuery.setDifferenceJobID(inJobID);
        ROXEvent[] queryArray = new ROXEvent[]{theQuery};
        ROXEvent[] events = null;
        try {
            NotificationManager theNM = Server.getApp().getNotificationManager();
            events = theNM.query(queryArray);
        }
        catch (Exception e) {
            // empty catch block
        }
        return events == null ? 1 : 2;
    }
}

