/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.ROXComponentEvent;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import java.util.Date;

public class ROXComponentInstallEvent
extends ROXComponentEvent
implements ROXEventFactoryInterface {
    public ROXComponentInstallEvent(Date inDate, String inMessage, InstalledComponentID inInstalledComponentID, boolean isPreflight) {
        super(inDate, inMessage, inInstalledComponentID, isPreflight);
    }

    public ROXComponentInstallEvent() {
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.COMPONENTINSTALL_DESCRIPTION");
    }

    public String formatMessage() {
        String componentName = "*";
        String targetName = "*";
        String planName = "*";
        if (null != this.getComponentID()) {
            componentName = this.getComponentID().toString() + "*";
        }
        if (null != this.getComponent()) {
            componentName = this.getComponent().getName();
        }
        if (null != this.getTargetID()) {
            targetName = this.getTargetID().toString() + "*";
        }
        if (null != this.getTarget()) {
            targetName = this.getTarget().getCurrentHost().getName();
        }
        if (null != this.getExecutionPlanID()) {
            planName = this.getExecutionPlanID().toString() + "*";
        }
        if (null != this.getExecutionPlan()) {
            planName = this.getExecutionPlan().getName();
        }
        return ROXMessageManager.messageAsString("event.COMPONENTINSTALL_MESSAGE", new Object[]{planName, new Double(this.getIsPreflight() ? 1.0 : 0.0), componentName, targetName, this.getDate()});
    }
}

