/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.ROXComponentControlServiceEvent;
import com.raplix.rolloutexpress.event.ROXComponentInstallEvent;
import com.raplix.rolloutexpress.event.ROXComponentUninstallEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentInterface;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import java.util.Date;

public abstract class ROXComponentEvent
extends ROXEvent
implements InstalledComponentInterface {
    private InstalledComponentBean mInstalledComponent = new InstalledComponentBean();

    public ROXComponentEvent(Date inDate, String inMessage, InstalledComponentID inInstalledComponentID, boolean inPreflight) {
        super(inDate, inMessage);
        this.setInstalledComponentID(inInstalledComponentID);
        this.setIsPreflight(inPreflight);
    }

    protected ROXComponentEvent() {
    }

    public InstalledComponent getInstalledComponent() {
        return this.mInstalledComponent.getInstalledComponent();
    }

    public InstalledComponentID getInstalledComponentID() {
        return this.mInstalledComponent.getInstalledComponentID();
    }

    public void setInstalledComponentID(InstalledComponentID installedComponentID) {
        this.mInstalledComponent.setInstalledComponentID(installedComponentID);
    }

    public String getComponentInstallPath() {
        return this.mInstalledComponent.getComponentInstallPath();
    }

    public String getComponentRAInstallPath() {
        return this.mInstalledComponent.getComponentRAInstallPath();
    }

    public TaskID getTaskID() {
        return this.mInstalledComponent.getTaskID();
    }

    public ExecutionPlanID getExecutionPlanID() {
        return this.mInstalledComponent.getExecutionPlanID();
    }

    public SummaryExecutionPlan getExecutionPlan() {
        return this.mInstalledComponent.getExecutionPlan();
    }

    public TargetID getTargetID() {
        return this.mInstalledComponent.getTargetID();
    }

    public Target getTarget() {
        return this.mInstalledComponent.getTarget();
    }

    public ComponentID getComponentID() {
        return this.mInstalledComponent.getComponentID();
    }

    public SummaryComponent getComponent() {
        return this.mInstalledComponent.getComponent();
    }

    public static ROXComponentInstallEvent install(InstalledComponentID inInstalledComponentID, boolean isPreflight) {
        return new ROXComponentInstallEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inInstalledComponentID, isPreflight);
    }

    public static ROXComponentUninstallEvent uninstall(InstalledComponentID inInstalledComponentID, boolean isPreflight) {
        return new ROXComponentUninstallEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inInstalledComponentID, isPreflight);
    }

    public static ROXComponentControlServiceEvent controlService(InstalledComponentID inInstalledComponentID, String inControlServiceName, boolean isPreflight) {
        return new ROXComponentControlServiceEvent(new Date(), "EXECUTE LOOKUP ON THIS MESSAGE", inInstalledComponentID, inControlServiceName, isPreflight);
    }

    public boolean getIsPreflight() {
        return this.mInstalledComponent.getIsPreflight();
    }

    public void setIsPreflight(boolean isPreflight) {
        this.mInstalledComponent.setIsPreflight(isPreflight);
    }

    public boolean preflightInUse() {
        return this.mInstalledComponent.preflightInUse();
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.mInstalledComponent = new InstalledComponentBean();
        this.setIsPreflight(inFactory.getIsPreflight());
        String id = inFactory.getInstalledComponentID();
        if (null != id) {
            this.setInstalledComponentID(new InstalledComponentID(id));
        }
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setInstalledComponentID(this.getInstalledComponentID());
        if (this.preflightInUse()) {
            ref.setIsPreflight(this.getIsPreflight());
        }
        return ref;
    }

    protected void doLookup() {
        this.mInstalledComponent.doLookup();
    }
}

