/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.ROXComponentEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import java.util.Date;

public class ROXComponentControlServiceEvent
extends ROXComponentEvent
implements ROXEventFactoryInterface {
    private String mControlServiceName;

    public ROXComponentControlServiceEvent(Date inDate, String inMessage, InstalledComponentID inInstalledComponentID, String inControlServiceName, boolean isPreflight) {
        super(inDate, inMessage, inInstalledComponentID, isPreflight);
        this.mControlServiceName = inControlServiceName;
    }

    public ROXComponentControlServiceEvent() {
    }

    public String getControlServiceName() {
        return this.mControlServiceName;
    }

    public void setControlServiceName(String inControlServiceName) {
        this.mControlServiceName = inControlServiceName;
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setControlServiceName(this.getControlServiceName());
        return ref;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.setControlServiceName(inFactory.getControlServiceName());
    }

    public String describe() {
        return ROXMessageManager.messageAsString("event.COMPONENTCONTROLSERVICE_DESCRIPTION");
    }

    public String formatMessage() {
        String componentName = "*";
        String targetName = "*";
        String planName = "*";
        if (null != this.getComponentID()) {
            componentName = this.getComponentID().toString() + "*";
        }
        if (null != this.getComponent()) {
            componentName = this.getComponent().getName();
        }
        if (null != this.getTargetID()) {
            targetName = this.getTargetID().toString() + "*";
        }
        if (null != this.getTarget()) {
            targetName = this.getTarget().getCurrentHost().getName();
        }
        if (null != this.getExecutionPlanID()) {
            planName = this.getExecutionPlanID().toString() + "*";
        }
        if (null != this.getExecutionPlan()) {
            planName = this.getExecutionPlan().getName();
        }
        return ROXMessageManager.messageAsString("event.COMPONENTCONTROLSERVICE_MESSAGE", new Object[]{planName, new Double(this.getIsPreflight() ? 1.0 : 0.0), this.getControlServiceName(), componentName, targetName, this.getDate()});
    }
}

