/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.event.ROXErrorEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXInfoEvent;
import com.raplix.rolloutexpress.event.ROXWarningEvent;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import java.util.Date;

public abstract class ROXAbnormalEvent
extends ROXEvent {
    private String mSubsystemName;

    public ROXAbnormalEvent(Date inDate, String inMessage, int inSeverity, String inSubsystemName) {
        super(inDate, inMessage, inSeverity);
        this.mSubsystemName = inSubsystemName;
    }

    protected ROXAbnormalEvent() {
    }

    public static ROXErrorEvent error(String inMessage, String inSubsystemName) {
        return new ROXErrorEvent(new Date(), inMessage, inSubsystemName);
    }

    public static ROXErrorEvent error(String inMessage, String inSubsystemName, CommandException inException) {
        return new ROXErrorEvent(new Date(), inMessage, inSubsystemName, inException);
    }

    public static ROXWarningEvent warning(String inMessage, String inSubsystemName) {
        return new ROXWarningEvent(new Date(), inMessage, inSubsystemName);
    }

    public static ROXInfoEvent info(String inMessage, String inSubsystemName) {
        return new ROXInfoEvent(new Date(), inMessage, inSubsystemName);
    }

    public String getSubsystemName() {
        return this.mSubsystemName;
    }

    public void setSubsystemName(String inSubsystemName) {
        this.mSubsystemName = inSubsystemName;
    }

    public void reconstitute(ROXEventFactory inFactory) {
        super.reconstitute(inFactory);
        this.setSubsystemName(inFactory.getSubsystemName());
    }

    public ROXEventFactory prepareForPersist() {
        ROXEventFactory ref = super.prepareForPersist();
        ref.setSubsystemName(this.getSubsystemName());
        return ref;
    }

    protected String getClassSubsystemName() {
        return Subsystem.getClassSubsystemName();
    }

    protected String formatMessage() {
        return this.getMessage();
    }

    protected void doLookup() {
    }
}

