/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.NotificationManagerException;
import com.raplix.rolloutexpress.event.ROXAbnormalEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventListener;
import com.raplix.rolloutexpress.event.ROXNotificationRule;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.SafeThread;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public abstract class NotificationThread
extends SafeThread
implements Messages {
    protected NotificationManager mNotificationManager;
    private boolean mKeepRunning;
    private Exception mException;

    protected abstract void store(ROXEvent var1) throws NotificationManagerException;

    public NotificationThread(NotificationManager inNotificationManager) {
        this.mNotificationManager = inNotificationManager;
        this.mKeepRunning = true;
        this.mException = null;
    }

    protected void managerShutdown() {
        this.mKeepRunning = false;
        this.interruptSafe();
    }

    protected void beforeNotify(ROXEvent anEvent) {
        anEvent.setState(0);
        anEvent.setProcessException(null);
    }

    protected void afterNotify(ROXEvent anEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvents(LinkedList inEvents) throws NotificationManagerException {
        ListIterator it = inEvents.listIterator(0);
        while (it.hasNext()) {
            this.beforeNotify((ROXEvent)it.next());
        }
        try {
            ROXEventFactory.saveMultipleEvents(inEvents);
        }
        catch (Exception e) {
            String msg = ROXMessageManager.messageAsString("event.SAVE_FAILED", new Object[]{e.toString()});
            if (Logger.isWarnEnabled(this)) {
                Logger.warn(msg, this);
            }
            it = inEvents.listIterator(0);
            while (it.hasNext()) {
                ROXEvent rox = (ROXEvent)it.next();
                try {
                    this.store(rox);
                }
                catch (Exception ne) {
                    rox.setProcessException(ne);
                }
            }
        }
        HashMap listeners = new HashMap();
        this.mNotificationManager.getListeners(listeners);
        Set theEntries = listeners.entrySet();
        it = inEvents.listIterator(0);
        while (it.hasNext()) {
            ROXEvent anEvent = (ROXEvent)it.next();
            if (anEvent.getProcessException() == null) {
                try {
                    Iterator theEntriesIterator = theEntries.iterator();
                    while (theEntriesIterator.hasNext()) {
                        try {
                            Map.Entry anEntry = theEntriesIterator.next();
                            ROXEventListener aListener = (ROXEventListener)anEntry.getKey();
                            ROXNotificationRule aNotificationRule = (ROXNotificationRule)anEntry.getValue();
                            if (!aNotificationRule.isInteresting(anEvent)) continue;
                            aListener.eventHappened(anEvent);
                            if (!Logger.isDebugEnabled(this)) continue;
                            Logger.debug("Sent event " + anEvent + " to " + aListener, this);
                        }
                        catch (Exception e) {
                            String msg = ROXMessageManager.messageAsString("event.NOTIFY_FAILED", new Object[]{e.toString()});
                            if (Logger.isErrorEnabled(this)) {
                                Logger.error(msg, e, this);
                            }
                            this.mException = e;
                            this.mNotificationManager.notify(ROXAbnormalEvent.error(msg, "NotificationManager"));
                            anEvent.setProcessException(e);
                        }
                    }
                }
                finally {
                    anEvent.setState(2);
                }
            }
            this.afterNotify(anEvent);
        }
    }

    protected void doIdle() throws NotificationManagerException {
    }

    public void run() {
        while (true) {
            block10: {
                LinkedList events = null;
                events = this.mNotificationManager.getEvents();
                if (events.isEmpty()) {
                    this.mNotificationManager.queueEmpty();
                    if (!this.mKeepRunning) break;
                    try {
                        this.doIdle();
                    }
                    catch (NotificationManagerException nme) {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error(ROXMessageManager.messageAsString("event.IDLE_LOOP_ERROR", new Object[]{nme.toString()}), this);
                        }
                        break block10;
                    }
                }
                try {
                    this.processEvents(events);
                }
                catch (NotificationManagerException nme) {
                    if (!Logger.isErrorEnabled(this)) break block10;
                    Logger.error(ROXMessageManager.messageAsString("event.IDLE_LOOP_ERROR", new Object[]{nme.toString()}), this);
                }
            }
            try {
                if (!this.mKeepRunning) continue;
                NotificationThread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("NotificationManager Thread stopping", this);
        }
    }

    public Exception getException() {
        return this.mException;
    }
}

