/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.event.ClientNotificationThread;
import com.raplix.rolloutexpress.event.EmptyQueryException;
import com.raplix.rolloutexpress.event.Messages;
import com.raplix.rolloutexpress.event.NotificationManagerException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.NotificationThread;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryInterface;
import com.raplix.rolloutexpress.event.ROXEventListener;
import com.raplix.rolloutexpress.event.ROXNotificationRule;
import com.raplix.rolloutexpress.event.ROXSimpleNotificationRule;
import com.raplix.rolloutexpress.event.ROXTaskNotificationRule;
import com.raplix.rolloutexpress.event.ServerNotificationThread;
import com.raplix.rolloutexpress.event.StringConstants;
import com.raplix.rolloutexpress.event.query.CustomQueryRemover;
import com.raplix.rolloutexpress.event.query.CustomQueryRestricter;
import com.raplix.rolloutexpress.event.query.NotificationQuery;
import com.raplix.rolloutexpress.event.rule.ActionFactoryRegistry;
import com.raplix.rolloutexpress.event.rule.EmailActionFactory;
import com.raplix.rolloutexpress.event.rule.RuleException;
import com.raplix.rolloutexpress.event.rule.RuleManager;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.query.QueryResults;
import com.raplix.rolloutexpress.persist.query.RetrieveObjectsWhereClauseQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.Uninterruptible;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Vector;

public class NotificationManager
extends Subsystem
implements NotificationRPCInterface,
StringConstants,
Messages {
    protected static final String DEFAULT_CONFIG_ROX_NOTIFICATION_MAILSERVER = "localhost";
    protected static final String DEFAULT_CONFIG_ROX_NOTIFICATION_SUBJECT = "CenterRun(tm) Notification";
    protected static final String DEFAULT_CONFIG_ROX_NOTIFICATION_SENDER = "notifications@centerrun.com";
    protected static final String DEFAULT_CONFIG_ROX_NOTIFICATION_URL = "NotificationRules";
    protected static final String DEFAULT_CONFIG_ROX_URL = "localhost:8080";
    protected static final String DEFAULT_CONFIG_ROX_HTTPS = "false";
    protected static final String DEFAULT_SORT = "ORDER BY c_eventdate";
    private HashMap mListeners;
    private LinkedList mEventQueue;
    private LinkedList mSuspendedEventQueue;
    protected NotificationThread mThread;
    boolean mServerFlag;
    RuleManager mRuleManager;
    private Boolean mIsSuspended = new Boolean(false);
    private boolean mIsQueueEmpty;

    public NotificationManager(Application inApplication, boolean inServerFlag) throws ConfigurationException {
        super(inApplication);
        this.mServerFlag = inServerFlag;
        this.mThread = null;
        this.mListeners = new HashMap();
        this.mEventQueue = new LinkedList();
        this.mSuspendedEventQueue = new LinkedList();
        PersistenceManager pm = null;
        if (inServerFlag) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("NotificationManager is part of the Server", this);
            }
            try {
                pm = this.mApplication.getPMSubsystem();
            }
            catch (UnsupportedSubsystemException use) {
                throw new ConfigurationException("event.PM_REQUIRED", (Throwable)use);
            }
            try {
                this.registerRPCInterfaces(this.mApplication.getNetSubsystem().getRPC());
            }
            catch (Exception e) {
                throw new ConfigurationException("event.NET_REQUIRED", (Throwable)e);
            }
            try {
                this.initializeRuleManager();
            }
            catch (Exception e) {
                throw new ConfigurationException("event.RULE_INIT_ERROR", (Throwable)e);
            }
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("NotificationManager is not part of the Server", this);
        }
        if (null == this.mApplication.getNetSubsystem()) {
            throw new ConfigurationException("event.NET_REQUIRED");
        }
        this.postInit();
    }

    public void postInit() throws ConfigurationException {
        this.mThread = this.mServerFlag ? new ServerNotificationThread(this) : new ClientNotificationThread(this);
        this.mThread.start();
    }

    public NotificationManager(Application inApplication) throws ConfigurationException {
        this(inApplication, true);
    }

    private NotificationManager() {
    }

    public NotificationThread getNotificationThread() {
        return this.mThread;
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        DefaultConfiguration[] sDefaultConfiguration = new DefaultConfiguration[]{new DefaultConfiguration("note.notificationMailServer", DEFAULT_CONFIG_ROX_NOTIFICATION_MAILSERVER, "address or hostname of the SMTP server for sending notifications"), new DefaultConfiguration("note.notificationSubject", DEFAULT_CONFIG_ROX_NOTIFICATION_SUBJECT, "email subject line for notifications sent by the system"), new DefaultConfiguration("note.notificationSender", DEFAULT_CONFIG_ROX_NOTIFICATION_SENDER, "return email address for notifications sent by the system - does not have to be a valid address"), new DefaultConfiguration("note.notificationsurl", DEFAULT_CONFIG_ROX_NOTIFICATION_URL, "return url postfix to be appended to system url to reach the notifications system"), new DefaultConfiguration("note.url", DEFAULT_CONFIG_ROX_URL, "return url to reach the rolloutexpress system"), new DefaultConfiguration("note.https", DEFAULT_CONFIG_ROX_HTTPS, "return boolean indicating whether https is in use")};
        return sDefaultConfiguration;
    }

    public void shutdown() throws RaplixShutdownException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("shutdown()", this);
        }
        this.mThread.managerShutdown();
        try {
            this.mThread.join();
        }
        catch (InterruptedException ie) {
            throw new RaplixShutdownException("event.CANT_SHUTDOWN_CLEANLY", (Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ROXEventListener aListener, ROXNotificationRule aRule) {
        if (aListener == null) {
            throw new IllegalArgumentException(ROXMessageManager.messageAsString("event.EVENTLISTERNER_NULL"));
        }
        if (aRule == null) {
            throw new IllegalArgumentException(ROXMessageManager.messageAsString("event.NOTIFICATIONRULE_NULL"));
        }
        HashMap hashMap = this.mListeners;
        synchronized (hashMap) {
            this.doAdd(aListener, aRule);
        }
    }

    public void replaceListener(ROXEventListener oldListener, ROXEventListener newListener) {
        this.replaceListener(oldListener, newListener, new ROXSimpleNotificationRule());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceListener(ROXEventListener oldListener, ROXEventListener newListener, ROXNotificationRule newRule) {
        HashMap hashMap = this.mListeners;
        synchronized (hashMap) {
            this.doRemove(oldListener);
            this.doAdd(newListener, newRule);
        }
    }

    public void addListener(ROXEventListener aListener) {
        this.addListener(aListener, new ROXSimpleNotificationRule());
    }

    public void addTaskListener(ROXEventListener aListener, TaskID aTaskID) {
        this.addListener(aListener, new ROXTaskNotificationRule(aTaskID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ROXEventListener aListener) {
        if (aListener == null) {
            throw new IllegalArgumentException(ROXMessageManager.messageAsString("event.EVENTLISTERNER_NULL"));
        }
        HashMap hashMap = this.mListeners;
        synchronized (hashMap) {
            this.doRemove(aListener);
        }
    }

    protected void doAdd(ROXEventListener aListener, ROXNotificationRule aRule) {
        if (this.mListeners.containsKey(aListener)) {
            throw new IllegalArgumentException(ROXMessageManager.messageAsString("event.LISTENER_ALREADY_REGISTERED"));
        }
        this.mListeners.put(aListener, aRule);
    }

    protected void doRemove(ROXEventListener aListener) {
        if (!this.mListeners.containsKey(aListener)) {
            throw new IllegalArgumentException(ROXMessageManager.messageAsString("event.LISTENER_DOESNT_EXIST"));
        }
        this.mListeners.remove(aListener);
    }

    public boolean notifyAndWait(ROXEvent anEvent) {
        return this.notifyAndWait(anEvent, false);
    }

    public boolean notifyAndWait(final ROXEvent anEvent, boolean inUseServerTimestamp) {
        if (this.notify(anEvent, inUseServerTimestamp)) {
            try {
                new Uninterruptible(){

                    protected Object execute() throws Exception {
                        anEvent.waitForNotification();
                        return null;
                    }
                }.run();
            }
            catch (Exception exception) {}
        } else {
            return false;
        }
        return anEvent.getState() == 2;
    }

    public boolean notify(ROXEvent anEvent) {
        return this.notify(anEvent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notify(ROXEvent anEvent, boolean inUseServerTimestamp) {
        block11: {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("notify(" + anEvent + ")", this);
            }
            if (inUseServerTimestamp) {
                anEvent.setDate(new Date());
            }
            if (!this.mIsShuttingDown) {
                try {
                    if (this.isSuspended()) {
                        LinkedList linkedList = this.mSuspendedEventQueue;
                        synchronized (linkedList) {
                            this.mSuspendedEventQueue.addLast(anEvent);
                            break block11;
                        }
                    }
                    this.addEvent(false, anEvent);
                }
                catch (RPCException rPCException) {}
            } else {
                if (Logger.isWarnEnabled(this)) {
                    Logger.warn(ROXMessageManager.messageAsString("event.EVENT_REJECTED"), this);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ROXEvent getNextEvent() throws NoSuchElementException {
        LinkedList linkedList = this.mEventQueue;
        synchronized (linkedList) {
            ROXEvent anEvent = (ROXEvent)this.mEventQueue.removeFirst();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("getNextEvent RETURNS " + anEvent, this);
            }
            return anEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedList getEvents() {
        LinkedList linkedList = this.mEventQueue;
        synchronized (linkedList) {
            LinkedList events = (LinkedList)this.mEventQueue.clone();
            this.mEventQueue.clear();
            return events;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEvent(boolean addToFront, ROXEvent inEvent) {
        LinkedList linkedList = this.mEventQueue;
        synchronized (linkedList) {
            if (addToFront) {
                this.mEventQueue.addFirst(inEvent);
            } else {
                this.mEventQueue.addLast(inEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEvents(LinkedList inEvents) {
        LinkedList linkedList = this.mEventQueue;
        synchronized (linkedList) {
            this.mEventQueue.addAll(inEvents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getListeners(HashMap inoutMap) {
        inoutMap.clear();
        HashMap hashMap = this.mListeners;
        synchronized (hashMap) {
            inoutMap.putAll(this.mListeners);
        }
    }

    protected void store(ROXEvent inEvent) {
        block3: {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("store(" + inEvent + ")", this);
            }
            try {
                inEvent.save(this);
            }
            catch (Exception e) {
                if (!Logger.isErrorEnabled(this)) break block3;
                Logger.error(ROXMessageManager.messageAsString("event.STORE_ERROR", new Object[]{inEvent.toString(), e.toString()}), e, this);
            }
        }
    }

    protected Vector internalQuery(Vector inExamples, String inOrderClause, boolean prefetchData) throws NotificationManagerException, EmptyQueryException {
        Object rox;
        if (null == inExamples) {
            throw new NotificationManagerException("event.NULL_EXAMPLE_LIST");
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug(inExamples.size() + " input examples sent to query", this);
        }
        Vector<Object> outList = new Vector<Object>();
        String whereClause = "WHERE ";
        boolean orNeeded = false;
        Enumeration e = inExamples.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            ROXEventFactory queryObject = null;
            try {
                String subClause;
                rox = (ROXEventFactoryInterface)obj;
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Acting on input example " + rox, this);
                }
                if ((subClause = (queryObject = rox.prepareForPersist()).getWhereSubclause()).length() != 0) {
                    if (orNeeded) {
                        whereClause = whereClause + " OR ";
                    } else {
                        orNeeded = true;
                    }
                    whereClause = whereClause + "(" + subClause + ")";
                    if (!Logger.isDebugEnabled(this)) continue;
                    Logger.debug("Found subclause: " + subClause + " yielding: " + whereClause, this);
                    continue;
                }
                if (!Logger.isDebugEnabled(this)) continue;
                Logger.debug("Subclause for " + queryObject + " empty", this);
            }
            catch (ClassCastException cce) {
                throw new NotificationManagerException("event.CAST_ERROR", new Object[]{obj.toString(), "ROXEventFactoryInterface"});
            }
        }
        whereClause = whereClause + " " + inOrderClause;
        try {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Final WHERE clause: " + whereClause, this);
            }
            RetrieveObjectsWhereClauseQuery roq = new RetrieveObjectsWhereClauseQuery(this.mApplication.getPMSubsystem().getDefaultDatabase(), this.mApplication.getPMSubsystem().getClassMap(ROXEventFactory.class.getName()), whereClause);
            roq.runQuery();
            QueryResults theResults = roq.getQueryResults();
            if (null == theResults) {
                throw new NotificationManagerException("event.NULL_QUERY");
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug(theResults.getSize() + " records selected", this);
            }
            while (theResults.hasNext()) {
                ROXEventFactory ref = (ROXEventFactory)theResults.next();
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Add result: " + ref + "(" + ref.getObjectID() + ")", this);
                }
                rox = ref.instantiate();
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Created: " + rox, this);
                }
                if (prefetchData) {
                    ((ROXEvent)rox).doLookup();
                }
                outList.add(rox);
            }
        }
        catch (UnsupportedSubsystemException use) {
            throw new NotificationManagerException("event.PM_REQUIRED");
        }
        catch (Exception e2) {
            throw new NotificationManagerException("event.QUERY_ERROR", (Throwable)e2);
        }
        if (outList.size() == 0) {
            throw new EmptyQueryException("event.ZERO_ROWS", new Object[]{whereClause});
        }
        return outList;
    }

    public Vector query(Vector inExamples) throws RPCException, NotificationManagerException, EmptyQueryException {
        return this.query(inExamples, false);
    }

    public Vector query(Vector inExamples, boolean inPrefetchData) throws RPCException, NotificationManagerException, EmptyQueryException {
        return this.internalQuery(inExamples, DEFAULT_SORT, inPrefetchData);
    }

    public ROXEvent[] query(ROXEvent[] inExamples) throws RPCException, NotificationManagerException, EmptyQueryException {
        Vector<ROXEvent> input = new Vector<ROXEvent>();
        for (int i = 0; i < inExamples.length; ++i) {
            input.add(inExamples[i]);
        }
        Vector result = this.internalQuery(input, DEFAULT_SORT, false);
        return result.toArray(new ROXEvent[1]);
    }

    public void registerRPCInterfaces(RPCManager inRPCManager) throws RPCException {
        inRPCManager.registerService(NotificationRPCInterface.class, this);
    }

    public Application getApp() {
        return this.mApplication;
    }

    protected void initializeRuleManager() throws UnsupportedSubsystemException, RuleException, RPCException, TransportException, ConfigurationException {
        RPCManager rpc = this.mApplication.getNetSubsystem().getRPC();
        ActionFactoryRegistry registry = new ActionFactoryRegistry();
        registry.registerFactory("EMAIL", new EmailActionFactory(this.getConfigurationAsString("note.notificationMailServer"), this.getConfigurationAsString("note.notificationSubject"), this.getConfigurationAsString("note.notificationSender")));
        this.mRuleManager = new RuleManager(this, rpc, registry);
    }

    public Vector queryRunningPlans(int inMaxBeans) throws RPCException, NotificationManagerException {
        NotificationQuery query = new NotificationQuery(this);
        return query.queryRunningPlans(null, inMaxBeans);
    }

    public Vector queryRunningOrCompletedPlans(String inPlanName, int inMinimumBeans) throws RPCException, NotificationManagerException {
        NotificationQuery query = new NotificationQuery(this);
        Vector runningPlanBeans = query.queryRunningPlans(inPlanName, Integer.MAX_VALUE);
        if (runningPlanBeans.size() < inMinimumBeans) {
            query = new NotificationQuery(this);
            Vector completedPlanBeans = query.queryCompletedPlans(inPlanName, inMinimumBeans - runningPlanBeans.size());
            Iterator completedIt = completedPlanBeans.iterator();
            while (runningPlanBeans.size() < inMinimumBeans && completedIt.hasNext()) {
                runningPlanBeans.add(completedIt.next());
            }
        }
        return runningPlanBeans;
    }

    public Vector queryRunningOrCompletedDiffs(int inMinimumBeans) throws RPCException, NotificationManagerException {
        NotificationQuery query = new NotificationQuery(this);
        Vector runningDiffBeans = query.queryRunningDiffs(Integer.MAX_VALUE);
        if (runningDiffBeans.size() < inMinimumBeans) {
            query = new NotificationQuery(this);
            Vector completedDiffBeans = query.queryCompletedDiffs(inMinimumBeans - runningDiffBeans.size());
            Iterator completedIt = completedDiffBeans.iterator();
            while (runningDiffBeans.size() < inMinimumBeans && completedIt.hasNext()) {
                runningDiffBeans.add(completedIt.next());
            }
        }
        return runningDiffBeans;
    }

    public Vector queryRunningDiffs(int inMaxBeans) throws RPCException, NotificationManagerException {
        NotificationQuery query = new NotificationQuery(this);
        return query.queryRunningDiffs(inMaxBeans);
    }

    public Vector queryHostHistory(HostID inHostID) throws RPCException, NotificationManagerException {
        if (null == inHostID) {
            throw new NullPointerException();
        }
        NotificationQuery query = new NotificationQuery(this);
        return query.queryHostHistory(inHostID);
    }

    public Vector queryIncompleteStepEvents(TaskID inTaskID) throws NotificationManagerException {
        NotificationQuery query = new NotificationQuery(this);
        return query.queryIncompleteStepEvents(inTaskID);
    }

    public Vector queryStepEvents(StepID inStepID, String[] inEventTypes) throws NotificationManagerException {
        NotificationQuery query = new NotificationQuery(this);
        return query.queryStepEvents(inStepID, inEventTypes);
    }

    public Collection executeCustomQuery(Collection inDomainDefinition, Collection inDomainLimitation, CustomQueryRemover inRemover, Comparator inSorter, CustomQueryRestricter inRestricter) throws NotificationManagerException {
        Vector domain = this.selectCustomQueryObjects(inDomainDefinition);
        if (domain.isEmpty()) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Custom query domain is empty", this);
            }
            return domain;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Custom query domain size is " + domain.size(), this);
        }
        if (null != inDomainLimitation && !inDomainLimitation.isEmpty()) {
            Vector limits = this.selectCustomQueryObjects(inDomainLimitation);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Custom query limiter size is " + limits.size(), this);
            }
            if (!limits.isEmpty()) {
                Iterator limitIterator = limits.iterator();
                while (limitIterator.hasNext()) {
                    Iterator domainIterator = domain.iterator();
                    ROXEvent limitObject = (ROXEvent)limitIterator.next();
                    while (domainIterator.hasNext()) {
                        ROXEvent domainObject = (ROXEvent)domainIterator.next();
                        if (!inRemover.removeFromDomain(domainObject, limitObject)) continue;
                        domainIterator.remove();
                    }
                }
            }
        }
        if (null != inSorter) {
            Collections.sort(domain, inSorter);
        }
        if (null != inRestricter) {
            return inRestricter.restrictOutput(domain);
        }
        return domain;
    }

    protected Vector selectCustomQueryObjects(Collection inSelectionCollection) throws NotificationManagerException {
        Vector selection = new Vector();
        Iterator selectionDefiners = inSelectionCollection.iterator();
        while (selectionDefiners.hasNext()) {
            Collection selectionDefiner = null;
            try {
                selectionDefiner = (Collection)selectionDefiners.next();
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException(ROXMessageManager.messageAsString("event.BAD_QUERY_DEFINITION"));
            }
            Vector definerVector = selectionDefiner instanceof Vector ? (Vector)selectionDefiner : new Vector(selectionDefiner);
            try {
                selection.addAll(this.internalQuery(definerVector, DEFAULT_SORT, false));
            }
            catch (EmptyQueryException eqe) {}
        }
        return selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Resetting notification manager...", this);
        }
        Cloneable cloneable = this.mListeners;
        synchronized (cloneable) {
            this.mListeners.clear();
        }
        cloneable = this.mEventQueue;
        synchronized (cloneable) {
            this.mEventQueue.clear();
        }
    }

    public String getUrl() throws ConfigurationException {
        StringBuffer url = new StringBuffer();
        boolean httpsInUse = this.getConfigurationAsBoolean("note.https");
        url.append(httpsInUse ? "https://" : "http://");
        url.append(this.getConfigurationAsString("note.url"));
        url.append("/");
        url.append(this.getConfigurationAsString("note.notificationsurl"));
        return url.toString();
    }

    public String getSubsystemName() {
        return ROXMessageManager.messageAsString("event.SUBSYSTEM_NAME");
    }

    public boolean performLookup() {
        return !this.mIsShuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueEmpty() {
        LinkedList linkedList = this.mEventQueue;
        synchronized (linkedList) {
            this.mIsQueueEmpty = true;
            this.mEventQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws RPCException {
        if (!this.mServerFlag) {
            throw new UnsupportedOperationException(ROXMessageManager.messageAsString("event.SERVICE_UNAVAILABLE"));
        }
        Serializable serializable = this.mIsSuspended;
        synchronized (serializable) {
            this.mIsSuspended = new Boolean(true);
        }
        try {
            serializable = this.mEventQueue;
            synchronized (serializable) {
                this.mIsQueueEmpty = false;
                while (!(!this.mThread.isAlive() || this.mEventQueue.isEmpty() && this.mIsQueueEmpty)) {
                    this.mEventQueue.wait(1000L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Suspended", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws RPCException {
        if (!this.mServerFlag) {
            throw new UnsupportedOperationException(ROXMessageManager.messageAsString("event.SERVICE_UNAVAILABLE"));
        }
        LinkedList linkedList = this.mSuspendedEventQueue;
        synchronized (linkedList) {
            LinkedList linkedList2 = this.mEventQueue;
            synchronized (linkedList2) {
                Boolean bl = this.mIsSuspended;
                synchronized (bl) {
                    this.mIsSuspended = new Boolean(false);
                    this.mEventQueue.addAll(this.mSuspendedEventQueue);
                    this.mSuspendedEventQueue.clear();
                }
            }
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Resumed", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() throws RPCException {
        Boolean bl = this.mIsSuspended;
        synchronized (bl) {
            return this.mIsSuspended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queueSize() {
        int eventCount = 0;
        LinkedList linkedList = this.mEventQueue;
        synchronized (linkedList) {
            eventCount = this.mEventQueue.size();
        }
        linkedList = this.mSuspendedEventQueue;
        synchronized (linkedList) {
        }
        return eventCount += this.mSuspendedEventQueue.size();
    }

    public RuleManager getRuleManager() {
        return this.mRuleManager;
    }
}

