/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;

public class HostStatus
implements RPCSerializable {
    public static final int NONE = 0;
    public static final int SUCCESS = 1;
    public static final int FAILURE = 2;
    public static final int INPROGRESS = 3;
    public static final int ABORTED = 4;
    public static final int TIMED_OUT = 5;
    private int mStatus;
    private HostID mHostID;

    public HostStatus() {
    }

    public HostStatus(HostID inHostID, int inStatus) {
        this.mHostID = inHostID;
        this.mStatus = inStatus;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public HostID getHostID() {
        return this.mHostID;
    }

    public void setStatus(int inStatus) {
        this.mStatus = inStatus;
    }

    public void setHostID(HostID inHostID) {
        this.mHostID = inHostID;
    }

    public boolean equals(Object inObject) {
        if (inObject == this) {
            return true;
        }
        if (inObject != null && inObject instanceof HostStatus) {
            HostStatus inStatus = (HostStatus)inObject;
            if (this.mHostID != null) {
                return this.mHostID.equals(inStatus.getHostID()) && this.mStatus == inStatus.getStatus();
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(", Host[").append(this.mHostID.toString()).append("], Status[").append(this.getStringStatus(this.mStatus)).append(" ]");
        return buf.toString();
    }

    private String getStringStatus(int inStatus) {
        String result = null;
        switch (inStatus) {
            case 2: {
                result = "FAILURE";
                break;
            }
            case 1: {
                result = "SUCCESS";
                break;
            }
            case 3: {
                result = "INPROGRESS";
            }
        }
        return result;
    }
}

