/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.event;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.NotificationManagerException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.NotificationThread;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ClientNotificationThread
extends NotificationThread {
    private NotificationRPCInterface mRadioToGod;
    private LinkedList mEvents;
    private File mDirectory;
    private File mFailedMsgDir;
    private File mInProcess;
    protected static final String FILE_PREFIX = "note";
    protected static final String FILE_SUFFIX = "data";
    protected static final String DIRECTORY_NAME = "notifications";
    protected static final String FAILED_MSG_DIRECTORY_NAME = "failedNotifications";

    public ClientNotificationThread(NotificationManager inNotificationManager) throws ConfigurationException {
        super(inNotificationManager);
        this.initEventList();
    }

    protected void initEventList() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Initializing client thread event list", this);
        }
        this.mEvents = new LinkedList();
        this.mDirectory = this.getDataDirectory(DIRECTORY_NAME);
        this.mFailedMsgDir = this.getDataDirectory(FAILED_MSG_DIRECTORY_NAME);
        this.mDirectory.mkdirs();
        this.mFailedMsgDir.mkdirs();
        String[] eventFiles = this.mDirectory.list();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Found " + eventFiles.length + " queued events", this);
        }
        for (int i = 0; i < eventFiles.length; ++i) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Examining file " + eventFiles[i], this);
            }
            this.doAdd(eventFiles[i], true);
        }
    }

    protected File getDataDirectory(String inChildDir) {
        return new File(this.mNotificationManager.getApp().getDataDirAbsPath(), inChildDir);
    }

    protected String writeToDisk(ROXEvent anEvent) throws IOException, RPCException {
        String prefix = FILE_PREFIX + new Date().getTime();
        File outputFile = File.createTempFile(prefix, FILE_SUFFIX, this.mDirectory);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Writing " + anEvent + " to disk in " + outputFile.getName(), this);
        }
        RPCManager rpc = this.mNotificationManager.getApp().getNetSubsystem().getRPC();
        FileWriter output = new FileWriter(outputFile);
        rpc.serializeObject(outputFile.getName(), anEvent, output);
        try {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Removing " + this.mInProcess.getName() + " as obsolete", this);
            }
            this.deleteCurrentFile();
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return outputFile.getName();
    }

    protected ROXEvent readFromDisk(String filename) throws IOException, RPCException {
        File inputFile = new File(this.mDirectory, filename);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Reading from " + inputFile.getName(), this);
        }
        RPCManager rpc = this.mNotificationManager.getApp().getNetSubsystem().getRPC();
        FileReader input = new FileReader(inputFile);
        ROXEvent event = (ROXEvent)rpc.deSerializeObject(filename, input);
        this.mInProcess = inputFile;
        return event;
    }

    protected boolean deleteCurrentFile() throws NullPointerException {
        boolean result = this.mInProcess.delete();
        if (result) {
            this.mInProcess = null;
        }
        return result;
    }

    protected void addEvent(ROXEvent anEvent) throws NotificationManagerException {
        this.addEvent(anEvent, true);
    }

    protected void addEvent(ROXEvent anEvent, boolean addLast) throws NotificationManagerException {
        String filename = "";
        try {
            filename = this.writeToDisk(anEvent);
        }
        catch (Exception e) {
            String msg = "Error while storing " + anEvent + "(" + e + ") - " + RaplixException.stackTraceToString(e);
            if (Logger.isErrorEnabled(this)) {
                Logger.error(msg, this);
            }
            throw new NotificationManagerException(msg, (Throwable)e);
        }
        this.doAdd(filename, addLast);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAdd(String filename, boolean addLast) {
        LinkedList linkedList = this.mEvents;
        synchronized (linkedList) {
            if (addLast) {
                this.mEvents.addLast(filename);
            } else {
                this.mEvents.addFirst(filename);
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Added event in ClientThread, now has size: " + this.mEvents.size(), this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ROXEvent getNextEvent() throws NoSuchElementException, NotificationManagerException {
        ROXEvent event = null;
        LinkedList linkedList = this.mEvents;
        synchronized (linkedList) {
            String filename = (String)this.mEvents.getFirst();
            try {
                event = this.readFromDisk(filename);
            }
            catch (Exception e) {
                File destFile = new File(this.mFailedMsgDir, filename);
                ROXMessage msg = new ROXMessage("event.MALFORMED_FILE_EVENT", filename, e.toString(), destFile.getAbsolutePath());
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(msg.getMessageString(), this);
                }
                File inputFile = new File(this.mDirectory, filename);
                inputFile.renameTo(destFile);
                this.mEvents.removeFirst();
                throw new NotificationManagerException(msg, (Throwable)e);
            }
            this.mEvents.removeFirst();
        }
        return event;
    }

    protected void doIdle() throws NotificationManagerException {
        block5: {
            try {
                ROXEvent eventToSend;
                while (true) {
                    eventToSend = this.getNextEvent();
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug(eventToSend + " is waiting - send to MS", this);
                    }
                    if (!this.sendToMS(eventToSend)) break;
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Removing " + this.mInProcess.getName() + " as obsolete", this);
                    }
                    this.deleteCurrentFile();
                }
                this.addEvent(eventToSend, false);
            }
            catch (NoSuchElementException nsee) {
                if (!Logger.isDebugEnabled(this)) break block5;
                Logger.debug("No more waiting events", this);
            }
        }
    }

    protected boolean sendToMS(ROXEvent anEvent) {
        if (Logger.isErrorEnabled(this)) {
            Logger.debug("Entering sendToMS with " + anEvent, this);
        }
        try {
            if (null == this.mRadioToGod) {
                this.mRadioToGod = (NotificationRPCInterface)this.mNotificationManager.getApp().getNetSubsystem().getRPC().getService(this.mNotificationManager.getApp().getNetSubsystem().getMSAddress(), NotificationRPCInterface.class);
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Preparing to send " + anEvent, this);
            }
            this.mRadioToGod.notify(anEvent);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Successfully sent " + anEvent, this);
            }
        }
        catch (Exception e) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Unable to send " + anEvent + "(" + e + ")", this);
            }
            return false;
        }
        return true;
    }

    protected void processEvents(LinkedList inEvents) throws NotificationManagerException {
        ListIterator it = inEvents.listIterator(0);
        while (it.hasNext()) {
            this.store((ROXEvent)it.next());
        }
    }

    protected void store(ROXEvent anEvent) throws NotificationManagerException {
        if (this.sendToMS(anEvent)) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Sent " + anEvent + " to the MS", this);
            }
        } else {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Cannot send " + anEvent + " at this time - will try again later", this);
            }
            this.addEvent(anEvent);
        }
    }
}

