/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference.differencedb;

import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsOrder;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsTable;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsToCategoryLinkTable;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;

public class MultiDifferenceSettingsQuery
extends MultiObjectQueryImpl
implements MultiSelectableObjectQuery {
    private static final DifferenceSettingsTable TABLE = new DifferenceSettingsTable("dT");
    private static final DifferenceSettingsToCategoryLinkTable LINK_T = DifferenceSettingsToCategoryLinkTable.DEFAULT;
    private CategoryID mCategoryFilter;

    public static MultiDifferenceSettingsQuery all() {
        MultiDifferenceSettingsQuery result = new MultiDifferenceSettingsQuery(TABLE.isLatest());
        result.setObjectOrder(DifferenceSettingsOrder.BY_NAME_ASC);
        return result;
    }

    public static MultiDifferenceSettingsQuery allVersions() {
        MultiDifferenceSettingsQuery result = new MultiDifferenceSettingsQuery((ConditionalExpression)null);
        result.setObjectOrder(DifferenceSettingsOrder.BY_NAME_VERSION_DESC);
        return result;
    }

    public static MultiDifferenceSettingsQuery byName(String inName) {
        MultiDifferenceSettingsQuery result = new MultiDifferenceSettingsQuery(DifferenceSettingsTable.and(TABLE.isLatest(), DifferenceSettingsTable.equals(MultiDifferenceSettingsQuery.TABLE.Name, inName)));
        return result;
    }

    public static MultiDifferenceSettingsQuery allVersionsOf(DifferenceSettingsID inSettingsID) {
        MultiDifferenceSettingsQuery result = new MultiDifferenceSettingsQuery(TABLE.isVersionOf(inSettingsID));
        result.setObjectOrder(DifferenceSettingsOrder.BY_VERSION_DESC);
        return result;
    }

    public static MultiDifferenceSettingsQuery byIDs(DifferenceSettingsID[] IDs) {
        MultiDifferenceSettingsQuery result = new MultiDifferenceSettingsQuery(IDs);
        result.setObjectOrder(DifferenceSettingsOrder.BY_VERSION_DESC);
        return result;
    }

    private MultiDifferenceSettingsQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, DifferenceSettingsOrder.FACTORY);
    }

    private MultiDifferenceSettingsQuery(DifferenceSettingsID[] ids) {
        super((Table)TABLE, ids, DifferenceSettingsOrder.FACTORY);
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((DifferenceSettingsOrder)order);
    }

    public CategoryID getCategoryFilter() {
        return this.mCategoryFilter;
    }

    public void setCategoryFilter(CategoryID categoryFilter) {
        this.mCategoryFilter = categoryFilter;
    }

    public DifferenceSettings[] select() throws RPCException, PersistenceManagerException {
        return (DifferenceSettings[])this.selectBeans(DifferenceSettings.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.select();
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        super.addFilterCondition(ctx);
        if (this.getCategoryFilter() != null) {
            ConditionalExpression matchesCat = LINK_T.matchesCategoryID(this.getCategoryFilter(), MultiDifferenceSettingsQuery.TABLE.ID);
            ctx.addAndWhereCondition(matchesCat);
        }
    }

    public int updateCategories(CategoryUpdateContext ctx) throws PersistenceManagerException, RPCException {
        return LINK_T.updateCategories(this.selectIDs(), ctx);
    }

    public CategoryIDSet selectSharedCategories() throws PersistenceManagerException, RPCException {
        return LINK_T.getSharedCategories(this.selectIDs());
    }
}

