/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference.differencedb;

import com.raplix.rolloutexpress.difference.differencedb.DiffSettingsObserverQuery;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsIDSet;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsToCategoryLinkTable;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsToComponentNameRefTable;
import com.raplix.rolloutexpress.difference.differencedb.MultiDifferenceJobQuery;
import com.raplix.rolloutexpress.difference.differencedb.SingleDifferenceSettingsQuery;
import com.raplix.rolloutexpress.event.query.MultiEventQuery;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.VersionedObjectID;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;

public class DifferenceSettingsID
extends VersionedObjectID
implements RPCSerializable {
    private static IDFactory idFactory = new IDFactory();

    private DifferenceSettingsID() {
    }

    public DifferenceSettingsID(String sID) {
        super(sID);
    }

    public int updateCategories(CategoryUpdateContext ctx) throws RPCException, PersistenceManagerException {
        return DifferenceSettingsToCategoryLinkTable.DEFAULT.updateCategories(this, ctx);
    }

    public SingleDifferenceSettingsQuery getByIDQuery() {
        return new SingleDifferenceSettingsQuery(this);
    }

    public static DifferenceSettingsID generateDifferenceSettingsID() {
        return (DifferenceSettingsID)idFactory.generateObjectID();
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        try {
            this.checkVersionedObjectInUse(inContext);
            MultiDifferenceJobQuery query = MultiDifferenceJobQuery.bySettings(this);
            query.setRunningFilter(new Boolean(true));
            UsingObject[] jobs = query.select();
            if (jobs.length > 0) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), jobs);
            }
            query.setRunningFilter(null);
            inDependentContainer.addAllDependentObjects(query.select());
            inDependentContainer.addAllDependentObjects(MultiEventQuery.byDifferenceSettingsID(this).select());
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        DifferenceSettingsIDSet idset = new DifferenceSettingsIDSet();
        idset.add(this);
        return idset;
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        DifferenceSettingsToCategoryLinkTable.DEFAULT.removeByChildID(this);
        DifferenceSettingsToComponentNameRefTable.DEFAULT.removeByParentID(this);
        super.deleteMS(context);
    }

    private static class IDFactory
    extends ObjectIDFactory {
        private IDFactory() {
        }

        protected ObjectID newInstance(String inID) {
            return new DifferenceSettingsID(inID);
        }

        public void registerCaches(ClassMap classMap, ObjectCache objectCache) {
            ComponentID.registerObserverQuery(DiffSettingsObserverQuery.getInstance());
        }
    }
}

