/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference.differencedb;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.DifferenceMessages;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBException;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsToCategoryLinkTable;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsToComponentNameRefTable;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.AcquireReadLockTransaction;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.VersionedPersistentBean;
import com.raplix.rolloutexpress.persist.VersionedPersistentObject;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.NameRefSet;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentNameRefAdder;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentNameRefUpdater;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentObserver;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentReferrer;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.CallStep;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecNativeStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.PauseStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.util.DOMElementEnumeration;
import com.raplix.util.Validate;
import com.raplix.util.file.XMLUtil;
import com.raplix.util.message.MessageManager;
import com.raplix.util.string.Replace;
import com.raplix.util.string.StringUtil;
import com.sun.n1.sps.model.difference.Level;
import com.sun.n1.sps.model.difference.Scope;
import com.sun.n1.sps.model.difference.Style;
import java.util.Arrays;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DifferenceSettings
extends VersionedPersistentObject
implements RPCSerializable,
Cloneable,
DifferenceMessages,
UsingObject,
ComponentReferrer {
    private static final String STEPS_TAG = "simpleSteps";
    public static final int INDEFINITE_TIMEOUT = -1;
    public static final int DIFF_STYLE_MODEL_MODEL = 0;
    public static final int DIFF_STYLE_MODEL_INSTALL = 1;
    public static final int DIFF_STYLE_INSTALL_INSTALL = 2;
    public static final int DIFF_STYLE_UNDEFINED = -1;
    public static final int DIFF_LEVEL_HOST = 0;
    public static final int DIFF_LEVEL_DIR = 1;
    public static final int DIFF_LEVEL_FILE = 2;
    public static final int DIFF_LEVEL_UNDEFINED = -1;
    public static final int DIFF_SCOPE_HOSTSET = 3;
    public static final int DIFF_SCOPE_HOST = 2;
    public static final int DIFF_SCOPE_COMPONENT = 0;
    public static final int DIFF_SCOPE_UNDEFINED = -1;
    private String mName = "";
    private String mDescription = "";
    private int mStyle = -1;
    private int mLevel = -1;
    private int mScope = -1;
    private String mSrcHostID;
    private String mDstHostID;
    private String mDstHostSetID;
    private String mSrcDir;
    private String mDstDir;
    private String mSrcPrepare = "";
    private String mSrcCleanup = "";
    private String mDstPrepare = "";
    private String mDstCleanup = "";
    private boolean mUseMiniPlans;
    private boolean mDstUseSrcP = true;
    private boolean mDstUseSrcC = true;
    private boolean mFollowSymlinks = true;
    private String[] mIgnorePaths = new String[0];
    private InstalledComponentID mInstalledComponentID;
    private int mTimeoutSecs = -1;
    private boolean mIncludeSubdirectories;
    private String[] mGlobalIgnorePaths = new String[0];
    private String[] mTextPaths = new String[0];
    private String[] mOraPaths = new String[0];
    private String[] mXMLPaths = new String[0];
    private String[] mXMLOrderedNames = new String[0];
    private String[] mApachePaths = new String[0];
    private String[] mConfPaths = new String[0];
    private String[] mPropertiesPaths = new String[0];
    private String[] mZipPaths = new String[0];
    private CategoryIDSet mCategories;
    private DiffSettingsCompObserver mDscr = new DiffSettingsCompObserver(this);

    public DifferenceSettings() {
    }

    public DifferenceSettings(DifferenceSettings s) {
        this.mName = s.getName();
        this.mDescription = s.getDescription();
        this.mStyle = s.getDiffStyle();
        this.mLevel = s.getDiffLevel();
        this.mScope = s.getDiffScope();
        this.mSrcHostID = s.getSrcHostID();
        this.mDstHostID = s.getDstHostID();
        this.mDstHostSetID = s.getDstHostSetID();
        this.mSrcDir = s.getSrcDir();
        this.mDstDir = s.getDstDir();
        this.mSrcPrepare = s.getSrcPrepare();
        this.mSrcCleanup = s.getSrcCleanup();
        this.mDstPrepare = s.getDstPrepare();
        this.mDstCleanup = s.getDstCleanup();
        this.mUseMiniPlans = s.getUseMiniPlans();
        this.mDstUseSrcP = s.getDstUseSrcP();
        this.mDstUseSrcC = s.getDstUseSrcC();
        this.mFollowSymlinks = s.getFollowSymlinks();
        this.mIgnorePaths = s.getIgnorePaths();
        this.mInstalledComponentID = s.getInstalledComponentID();
        this.mTimeoutSecs = s.getTimeoutSecs();
        this.mIncludeSubdirectories = s.getIncludeSubdirectories();
        this.mGlobalIgnorePaths = s.getGlobalIgnorePaths();
        this.mTextPaths = s.getTextPaths();
        this.mOraPaths = s.getOraPaths();
        this.mXMLPaths = s.getXMLPaths();
        this.mXMLOrderedNames = s.getXMLOrderedNames();
        this.mApachePaths = s.getApachePaths();
        this.mConfPaths = s.getConfPaths();
        this.mPropertiesPaths = s.getPropertiesPaths();
        this.mZipPaths = s.getZipPaths();
        this.mCategories = s.mCategories;
        this.setObjectID(s.getObjectID());
    }

    public DifferenceSettings(String name, String description) {
        this.mName = name;
        this.mDescription = description;
    }

    private void validateMiniPlan(boolean prepare, String miniPlan) throws DifferenceDBException {
        if (StringUtil.isEmpty(miniPlan)) {
            return;
        }
        String expecting = prepare ? "prepare" : "cleanup";
        this.assembleMiniPlanSteps(prepare, miniPlan);
        ExecutionPlan p = new ExecutionPlan();
        p.setName("miniPlanValidator");
        p.setExecSteps(new ExecStep[]{new PauseStep(0)});
        String base = p.writeToXML();
        try {
            p.readFromXML(base.substring(0, base.indexOf("<simpleSteps>")) + Replace.replace(miniPlan, expecting, STEPS_TAG) + base.substring(base.indexOf("</simpleSteps>") + "</simpleSteps>".length()));
        }
        catch (PlanDBException ex) {
            throw new DifferenceDBException("diff.VALIDATE_INVALID_MINIPLAN", (Throwable)ex);
        }
        catch (SystemModelParseException ex) {
            throw new DifferenceDBException("diff.VALIDATE_INVALID_MINIPLAN", (Throwable)ex);
        }
    }

    private Vector assembleMiniPlanSteps(boolean prepare, String miniPlan) throws DifferenceDBException {
        Node first;
        if (StringUtil.isEmpty(miniPlan)) {
            return new Vector();
        }
        String expecting = prepare ? "prepare" : "cleanup";
        try {
            first = XMLUtil.parse(miniPlan).getFirstChild();
        }
        catch (IllegalArgumentException ex) {
            throw new DifferenceDBException("diff.VALIDATE_INVALID_MINIPLAN", (Throwable)ex);
        }
        String rootName = first.getNodeName();
        if (!rootName.equals(expecting)) {
            throw new DifferenceDBException("diff.VALIDATE_INVALID_ROOT_NAME", new Object[]{expecting, rootName});
        }
        if (first.getAttributes().getLength() != 0) {
            throw new DifferenceDBException("diff.VALIDATE_INVALID_ROOT_ATTR");
        }
        Vector<ExecNativeStep> steps = new Vector<ExecNativeStep>();
        DOMElementEnumeration e = new DOMElementEnumeration(first);
        while (e.hasMoreElements()) {
            Element element = e.nextElement();
            String name = element.getTagName();
            ExecStep testStep = null;
            try {
                if (name.equals("execNative")) {
                    testStep = new ExecNativeStep(element);
                } else if (name.equals("call")) {
                    testStep = new CallStep(element);
                }
            }
            catch (RaplixException ex) {
                throw new DifferenceDBException("diff.VALIDATE_INVALID_MINIPLAN", (Throwable)ex);
            }
            if (testStep == null) {
                throw new DifferenceDBException("diff.VALIDATE_UNSUPPORTED_ELEMENT", new Object[]{name});
            }
            steps.add((ExecNativeStep)testStep);
        }
        return steps;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDiffStyle(int style) {
        this.mStyle = style;
        this.getDiffStyleCode();
    }

    public int getDiffStyle() {
        return this.mStyle;
    }

    public Style getDiffStyleCode() {
        if (this.mStyle == -1) {
            return Style.UNDEFINED;
        }
        return Style.FACTORY.get(this.mStyle);
    }

    public void setDiffLevel(int level) {
        this.mLevel = level;
        this.getDiffLevelCode();
    }

    public void forTestOnly_setInvalidDiffLevel() {
        this.mLevel = 7;
    }

    public int getDiffLevel() {
        return this.mLevel;
    }

    public Level getDiffLevelCode() {
        if (this.mLevel == -1) {
            return Level.UNDEFINED;
        }
        return Level.FACTORY.get(this.mLevel);
    }

    public void setDiffScope(int scope) {
        this.mScope = scope;
        this.getDiffScopeCode();
    }

    public int getDiffScope() {
        return this.mScope;
    }

    public Scope getDiffScopeCode() {
        switch (this.mScope) {
            case -1: {
                return Scope.UNDEFINED;
            }
            case 0: {
                return Scope.COMPONENT;
            }
            case 3: {
                return Scope.HOSTSET;
            }
            case 2: {
                return Scope.HOST;
            }
        }
        throw new IllegalStateException(MessageManager.messageAsString("ui.cmp.cnv.EX_UNKNOWN_SCOPE", new Object[]{"" + this.mScope}));
    }

    public void setSrcHostID(String srcHostID) {
        this.mSrcHostID = srcHostID;
    }

    public String getSrcHostID() {
        return this.mSrcHostID;
    }

    public void setDstHostID(String dstHostID) {
        this.mDstHostID = dstHostID;
    }

    public String getDstHostID() {
        return this.mDstHostID;
    }

    public void setDstHostSetID(String dstHostSetID) {
        this.mDstHostSetID = dstHostSetID;
    }

    public String getDstHostSetID() {
        return this.mDstHostSetID;
    }

    public void setSrcDir(String srcDir) {
        this.mSrcDir = srcDir;
    }

    public String getSrcDir() {
        return this.mSrcDir;
    }

    public void setDstDir(String dstDir) {
        this.mDstDir = dstDir;
    }

    public String getDstDir() {
        return this.mDstDir;
    }

    public void setSrcPrepare(String srcPrepare) {
        this.mSrcPrepare = srcPrepare;
    }

    public String getSrcPrepare() {
        return this.mSrcPrepare;
    }

    public void setSrcCleanup(String srcCleanup) {
        this.mSrcCleanup = srcCleanup;
    }

    public String getSrcCleanup() {
        return this.mSrcCleanup;
    }

    public void setDstPrepare(String dstPrepare) {
        this.mDstPrepare = dstPrepare;
    }

    public String getDstPrepare() {
        return this.mDstPrepare;
    }

    public void setDstCleanup(String dstCleanup) {
        this.mDstCleanup = dstCleanup;
    }

    public String getDstCleanup() {
        return this.mDstCleanup;
    }

    public boolean getUseMiniPlans() {
        return this.mUseMiniPlans;
    }

    public void setUseMiniPlans(boolean useMiniPlans) {
        this.mUseMiniPlans = useMiniPlans;
    }

    public boolean getDstUseSrcP() {
        return this.mDstUseSrcP;
    }

    public void setDstUseSrcP(boolean duplicateSteps) {
        this.mDstUseSrcP = duplicateSteps;
    }

    public boolean getDstUseSrcC() {
        return this.mDstUseSrcC;
    }

    public void setDstUseSrcC(boolean duplicateSteps) {
        this.mDstUseSrcC = duplicateSteps;
    }

    public boolean getFollowSymlinks() {
        return this.mFollowSymlinks;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.mFollowSymlinks = followSymlinks;
    }

    public void setIgnorePaths(String[] ignorePaths) {
        this.mIgnorePaths = (String[])ignorePaths.clone();
        Arrays.sort(this.mIgnorePaths);
    }

    public String[] getIgnorePaths() {
        return this.mIgnorePaths;
    }

    public void setInstalledComponentID(InstalledComponentID installedComponentID) {
        this.mInstalledComponentID = installedComponentID;
    }

    public InstalledComponentID getInstalledComponentID() {
        return this.mInstalledComponentID;
    }

    public void setTimeoutSecs(int timeoutSecs) {
        this.mTimeoutSecs = timeoutSecs;
    }

    public int getTimeoutSecs() {
        return this.mTimeoutSecs;
    }

    public void setIncludeSubdirectories(boolean includeSubdirectories) {
        this.mIncludeSubdirectories = includeSubdirectories;
    }

    public boolean getIncludeSubdirectories() {
        return this.mIncludeSubdirectories;
    }

    public void setGlobalIgnorePaths(String[] globalIgnorePaths) {
        this.mGlobalIgnorePaths = globalIgnorePaths;
    }

    public String[] getGlobalIgnorePaths() {
        return this.mGlobalIgnorePaths;
    }

    public void setTextPaths(String[] textPaths) {
        this.mTextPaths = textPaths;
    }

    public String[] getTextPaths() {
        return this.mTextPaths;
    }

    public void setOraPaths(String[] oraPaths) {
        this.mOraPaths = oraPaths;
    }

    public String[] getOraPaths() {
        return this.mOraPaths;
    }

    public void setXMLPaths(String[] xmlPaths) {
        this.mXMLPaths = xmlPaths;
    }

    public String[] getXMLPaths() {
        return this.mXMLPaths;
    }

    public void setXMLOrderedNames(String[] xmlOrderedNames) {
        this.mXMLOrderedNames = xmlOrderedNames;
    }

    public String[] getXMLOrderedNames() {
        return this.mXMLOrderedNames;
    }

    public void setApachePaths(String[] apachePaths) {
        this.mApachePaths = apachePaths;
    }

    public String[] getApachePaths() {
        return this.mApachePaths;
    }

    public void setConfPaths(String[] confPaths) {
        this.mConfPaths = confPaths;
    }

    public String[] getConfPaths() {
        return this.mConfPaths;
    }

    public void setPropertiesPaths(String[] propertiesPaths) {
        this.mPropertiesPaths = propertiesPaths;
    }

    public String[] getPropertiesPaths() {
        return this.mPropertiesPaths;
    }

    public void setZipPaths(String[] zipPaths) {
        this.mZipPaths = zipPaths;
    }

    public String[] getZipPaths() {
        return this.mZipPaths;
    }

    public DifferenceSettingsID getID() {
        return (DifferenceSettingsID)this.getObjectID();
    }

    public Vector getAffectedHosts() {
        Vector<HostID> result = new Vector<HostID>();
        if (!StringUtil.isEmpty(this.getSrcHostID())) {
            result.add(new HostID(this.getSrcHostID()));
        }
        if (!StringUtil.isEmpty(this.getDstHostID())) {
            result.add(new HostID(this.getDstHostID()));
        }
        if (!StringUtil.isEmpty(this.getDstHostSetID())) {
            try {
                HostSetID hostSetID = new HostSetID(this.getDstHostSetID());
                SummaryHost[] hosts = hostSetID.getAllHostsQuery().selectSummaryView();
                for (int i = 0; i < hosts.length; ++i) {
                    result.add(hosts[i].getID());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public void assertValid() throws DifferenceDBException {
        if (!Validate.isValidObjectName(this.getName(), 32)) {
            throw new DifferenceDBException("diff.VALIDATE_BAD_NAME", new Object[]{this.getName()});
        }
        if (this.getTimeoutSecs() != -1) {
            try {
                Validate.assertValidTimeout(this.getTimeoutSecs(), 1);
            }
            catch (IllegalArgumentException ex) {
                throw new DifferenceDBException("diff.VALIDATE_INVALID_TIMEOUT", (Throwable)ex);
            }
        }
        switch (this.getDiffStyle()) {
            case 2: {
                if (StringUtil.isEmpty(this.getSrcDir()) || StringUtil.isEmpty(this.getDstDir())) {
                    throw new DifferenceDBException("diff.VALIDATE_MISSING_DIR");
                }
                if (StringUtil.isEmpty(this.getSrcHostID())) {
                    throw new DifferenceDBException("diff.VALIDATE_MISSING_SRC_HOST");
                }
                if (this.getDiffScope() != 2) {
                    throw new DifferenceDBException("diff.VALIDATE_INVALID_SCOPE_II");
                }
                if (this.getDiffLevel() == 0) {
                    throw new DifferenceDBException("diff.VALIDATE_INVALID_LEVEL_II");
                }
                if (!this.getUseMiniPlans()) break;
                this.validateMiniPlan(true, this.getSrcPrepare());
                if (!this.getDstUseSrcP()) {
                    this.validateMiniPlan(true, this.getDstPrepare());
                }
                this.validateMiniPlan(false, this.getSrcCleanup());
                if (this.getDstUseSrcC()) break;
                this.validateMiniPlan(false, this.getDstCleanup());
                break;
            }
            case 0: {
                if (this.getDiffScope() != 2) {
                    throw new DifferenceDBException("diff.VALIDATE_INVALID_SCOPE_MM");
                }
                if (this.getDiffLevel() != 0) {
                    throw new DifferenceDBException("diff.VALIDATE_INVALID_LEVEL_MM");
                }
                if (!StringUtil.isEmpty(this.getSrcHostID())) break;
                throw new DifferenceDBException("diff.VALIDATE_MISSING_SRC_HOST");
            }
            case 1: {
                if (this.getDiffLevel() == 0) {
                    throw new DifferenceDBException("diff.VALIDATE_INVALID_LEVEL_MI");
                }
                if (!StringUtil.isEmpty(this.getDstHostID()) || !StringUtil.isEmpty(this.getDstHostSetID())) break;
                throw new DifferenceDBException("diff.VALIDATE_MISSING_TARGET");
            }
            default: {
                throw new DifferenceDBException("diff.VALIDATE_INVALID_STYLE");
            }
        }
        switch (this.getDiffScope()) {
            case 0: {
                if (!StringUtil.isEmpty(this.getInstalledComponentID().toString())) break;
                throw new DifferenceDBException("diff.VALIDATE_MISSING_COMPONENT");
            }
            case 2: {
                if (!StringUtil.isEmpty(this.getDstHostID())) break;
                throw new DifferenceDBException("diff.VALIDATE_MISSING_HOST");
            }
            case 3: {
                if (!StringUtil.isEmpty(this.getDstHostSetID())) break;
                throw new DifferenceDBException("diff.VALIDATE_MISSING_HOSTSET");
            }
            default: {
                throw new DifferenceDBException("diff.VALIDATE_INVALID_SCOPE");
            }
        }
        if (this.getDiffLevel() != 0 && this.getDiffLevel() != 1 && this.getDiffLevel() != 2) {
            throw new DifferenceDBException("diff.VALIDATE_INVALID_LEVEL");
        }
    }

    public CategoryIDSet getCategories() throws PersistenceManagerException, RPCException {
        if (this.mCategories == null) {
            this.mCategories = DifferenceSettingsToCategoryLinkTable.DEFAULT.getCategories(this.getID());
        }
        return (CategoryIDSet)this.mCategories.clone();
    }

    public void setCategories(CategoryIDSet categories) {
        this.mCategories = (CategoryIDSet)categories.clone();
    }

    protected void saveMS(final VersionedSaveContext ctx) throws PersistenceManagerException {
        DifferenceSettings.transactMS(new AcquireReadLockTransaction(){

            public Object execute() throws PersistenceManagerException {
                DifferenceSettings.this.executeSaveMS(ctx);
                return null;
            }

            public ROXMessage getLockDescription() {
                return new ROXMessage("diff.SAVING_DIFFSET", DifferenceSettings.this.getName());
            }
        });
    }

    private void executeSaveMS(VersionedSaveContext ctx) throws PersistenceManagerException {
        super.saveMS(ctx);
    }

    protected void trSaveMS(VersionedPersistentBean latest, VersionedSaveContext ctx) throws PersistenceManagerException {
        super.trSaveMS(latest, ctx);
        this.updateCategories();
        this.incrementUpdateCountInSave();
        this.updateComponentNameRefs();
    }

    private void updateCategories() throws PersistenceManagerException {
        try {
            DifferenceSettingsToCategoryLinkTable.DEFAULT.updateCategoriesMS(this.getID(), new CategoryUpdateContext(this.getCategories()), this.getID().equals(this.getRootID()));
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    private void updateComponentNameRefs() throws PersistenceManagerException {
        NameRefSet set = new NameRefSet();
        this.addComponentRefsMS(set);
        DifferenceSettingsToComponentNameRefTable.DEFAULT.addReferences(this.getID(), set);
    }

    public void addComponentRefsMS(NameRefSet set) throws PersistenceManagerException {
        Caller real = new ExecutionPlan().toCaller();
        ComponentNameRefAdder v = new ComponentNameRefAdder(set, real);
        try {
            Vector sp = this.assembleMiniPlanSteps(true, this.getSrcPrepare());
            for (int i = 0; i < sp.size(); ++i) {
                v.visit((ExecStep)sp.get(i));
            }
            Vector dp = this.assembleMiniPlanSteps(true, this.getDstPrepare());
            for (int j = 0; j < dp.size(); ++j) {
                v.visit((ExecStep)dp.get(j));
            }
            Vector sc = this.assembleMiniPlanSteps(false, this.getSrcCleanup());
            for (int k = 0; k < sc.size(); ++k) {
                v.visit((ExecStep)sc.get(k));
            }
            Vector dc = this.assembleMiniPlanSteps(false, this.getDstCleanup());
            for (int m = 0; m < dc.size(); ++m) {
                v.visit((ExecStep)dc.get(m));
            }
        }
        catch (Exception e) {
            throw v.mapException(e);
        }
    }

    DifferenceSettings updateComponentRefsMS(SummaryComponent sc, String newName, SummaryFolder newPath) throws PersistenceManagerException {
        Caller real = new ExecutionPlan().toCaller();
        ComponentNameRefUpdater t = new ComponentNameRefUpdater(sc, real, newName, newPath);
        try {
            DifferenceSettings result = (DifferenceSettings)this.clone();
            Vector sp = this.assembleMiniPlanSteps(true, this.getSrcPrepare());
            for (int i = 0; i < sp.size(); ++i) {
                sp.set(i, t.transform((ExecStep)sp.get(i)));
            }
            result.setSrcPrepare(this.assembleMiniPlan(sp, true));
            Vector dp = this.assembleMiniPlanSteps(true, this.getDstPrepare());
            for (int j = 0; j < dp.size(); ++j) {
                dp.set(j, t.transform((ExecStep)dp.get(j)));
            }
            result.setDstPrepare(this.assembleMiniPlan(dp, true));
            Vector ss = this.assembleMiniPlanSteps(false, this.getSrcCleanup());
            for (int k = 0; k < ss.size(); ++k) {
                ss.set(k, t.transform((ExecStep)ss.get(k)));
            }
            result.setSrcCleanup(this.assembleMiniPlan(ss, false));
            Vector dc = this.assembleMiniPlanSteps(false, this.getDstCleanup());
            for (int m = 0; m < dc.size(); ++m) {
                dc.set(m, t.transform((ExecStep)dc.get(m)));
            }
            result.setDstCleanup(this.assembleMiniPlan(dc, false));
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        catch (DifferenceDBException e) {
            throw new PersistenceManagerException(e);
        }
        catch (Exception e) {
            throw t.mapException(e);
        }
    }

    private String assembleMiniPlan(Vector steps, boolean prepare) {
        StringBuffer result = new StringBuffer(prepare ? "<prepare>" : "<cleanup>");
        for (int i = 0; i < steps.size(); ++i) {
            result.append(((ExecStep)steps.get(i)).toString());
        }
        result.append(prepare ? "</prepare>" : "</cleanup>");
        return result.toString();
    }

    DiffSettingsCompObserver getComponentObserver() {
        return this.mDscr;
    }

    static class DiffSettingsCompObserver
    implements ComponentObserver,
    RPCSerializable {
        DifferenceSettings mDS;

        private DiffSettingsCompObserver() {
        }

        protected DiffSettingsCompObserver(DifferenceSettings ds) {
            this.mDS = ds;
        }

        public void renameComponent(SummaryComponent sc, String name, SummaryFolder path) throws PersistenceManagerException, RPCException {
            this.mDS = this.mDS.updateComponentRefsMS(sc, name, path);
            this.mDS.saveSameVersionMS();
        }
    }
}

