/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference.differencedb;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.DifferenceID;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.DifferenceMessages;
import com.raplix.rolloutexpress.difference.RemoteAgentOperationListener;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBAgentInterface;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBException;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBInterface;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsTable;
import com.raplix.rolloutexpress.difference.differencedb.MultiDifferenceSettingsQuery;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.Comparison;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.util.reflect.ClassUtil;

public class DifferenceDB
extends Subsystem
implements DifferenceDBInterface,
DifferenceDBAgentInterface,
DifferenceMessages {
    private RemoteAgentOperationListener mRemoteAgentOperationListener = null;

    private DifferenceDB() {
    }

    public DifferenceDB(Application inApplication) throws ConfigurationException {
        this(inApplication, false);
    }

    public DifferenceDB(Application inApplication, boolean isTesting) throws ConfigurationException {
        super(inApplication);
        if (!isTesting) {
            try {
                NetSubsystem ns = inApplication.getNetSubsystem();
                ns.getRPC().registerService(DifferenceDBInterface.class, this);
                ns.getRPC().registerService(DifferenceDBAgentInterface.class, this);
            }
            catch (RPCException rpce) {
                throw new ConfigurationException("unable to register the differencedb with RPC: " + rpce);
            }
        }
    }

    public DifferenceSettingsID saveDifferenceSettings(DifferenceSettings s) throws RPCException, DifferenceDBException {
        try {
            s.assertValid();
        }
        catch (DifferenceDBException ex) {
            throw new DifferenceDBException("diff.INVALID_SETTINGS_SAVE", (Throwable)ex);
        }
        DifferenceSettings[] dbSettings = null;
        try {
            dbSettings = MultiDifferenceSettingsQuery.byName(s.getName()).select();
        }
        catch (RaplixException re) {
            throw new DifferenceDBException("diff.VALIDATE_DB_ERROR", (Throwable)re);
        }
        if (dbSettings.length != 0 && !dbSettings[0].getRootID().equals(s.getRootID())) {
            throw new DifferenceDBException("diff.VALIDATE_DUPLICATE_NAME", new Object[]{s.getName()});
        }
        if (s.getRootID() != null && dbSettings.length == 0) {
            throw new DifferenceDBException("diff.RENAME_FORBIDDEN");
        }
        try {
            VersionNumber v = null;
            if (dbSettings.length != 0) {
                v = dbSettings[0].getVersionNumber();
            }
            VersionedSaveContext ctx = new VersionedSaveContext();
            ctx.setLatestVersion(v);
            s.save(ctx);
        }
        catch (ClassMapException cmex) {
            throw new DifferenceDBException("diff.DB_MAPPING_ERR", (Throwable)cmex);
        }
        catch (PersistenceManagerException pmex) {
            throw new DifferenceDBException("diff.ERR_SAVING", (Throwable)pmex);
        }
        return (DifferenceSettingsID)s.getObjectID();
    }

    public DifferenceSettings getDifferenceSettings(DifferenceSettingsID sID) throws RPCException, DifferenceDBException {
        DifferenceSettings s = new DifferenceSettings();
        s.setObjectID(sID);
        try {
            s.retrieve();
        }
        catch (ClassMapException cmex) {
            throw new DifferenceDBException("diff.DB_MAPPING_ERR_RETRIEVE", (Throwable)cmex);
        }
        catch (PersistenceManagerException pmex) {
            throw new DifferenceDBException("diff.ERR_RETRIEVE", (Throwable)pmex);
        }
        return s;
    }

    public DifferenceSettings getDifferenceSettings(String name) throws RPCException, DifferenceDBException {
        if (this.isShuttingDown()) {
            throw new DifferenceDBException("diff.SHUTDOWN_IN_PROGRESS");
        }
        DifferenceSettings s = null;
        try {
            DifferenceSettingsTable t = new DifferenceSettingsTable("a");
            Comparison nameEquals = DifferenceSettingsTable.equals(t.Name, name);
            Select maxQuery = t.select(DifferenceSettingsTable.sList(DifferenceSettingsTable.max(t.Version)), DifferenceSettingsTable.where(nameEquals));
            Select query = t.select(DifferenceSettingsTable.where(DifferenceSettingsTable.and(DifferenceSettingsTable.equals((ColumnNode)t.Version, maxQuery), nameEquals)));
            s = (DifferenceSettings)QueryBuilder.executeSingleResult(query, t);
        }
        catch (PersistenceManagerException ex) {
            throw new DifferenceDBException("diff.COULDNT_GET_SETTINGS", (Throwable)ex);
        }
        if (s == null) {
            throw new DifferenceDBException("diff.COULDNT_GET_SETTINGS");
        }
        return s;
    }

    public DifferenceSettingsID[] getAllDifferenceSettingsIDs() throws RPCException, DifferenceDBException {
        if (this.isShuttingDown()) {
            throw new DifferenceDBException("diff.SHUTDOWN_IN_PROGRESS");
        }
        DifferenceSettings[] ss = this.getAllDifferenceSettings();
        DifferenceSettingsID[] sIDs = new DifferenceSettingsID[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            sIDs[i] = (DifferenceSettingsID)ss[i].getObjectID();
        }
        return sIDs;
    }

    public DifferenceSettings[] getAllDifferenceSettings() throws RPCException, DifferenceDBException {
        if (this.isShuttingDown()) {
            throw new DifferenceDBException("diff.SHUTDOWN_IN_PROGRESS");
        }
        DifferenceSettingsTable ot = new DifferenceSettingsTable("a");
        DifferenceSettingsTable it = new DifferenceSettingsTable("b");
        try {
            PersistentBean[] diffSettings = null;
            Select latestVersion = it.select(DifferenceSettingsTable.sList(DifferenceSettingsTable.max(it.Version)), DifferenceSettingsTable.where(DifferenceSettingsTable.equals((ColumnNode)ot.RootID, it.RootID)));
            Select latest = ot.select((SelectList)ot.allColumns(), DifferenceSettingsTable.where(DifferenceSettingsTable.equals((ColumnNode)ot.Version, latestVersion)), DifferenceSettingsTable.dictOrderAsc(ot.Name));
            diffSettings = DifferenceSettingsTable.executeMultiResult(latest, ot);
            DifferenceSettings[] result = new DifferenceSettings[diffSettings.length];
            System.arraycopy(diffSettings, 0, result, 0, diffSettings.length);
            return result;
        }
        catch (PersistenceManagerException ex) {
            throw new DifferenceDBException("diff.COULDNT_GET_SETTINGS", (Throwable)ex);
        }
    }

    public DifferenceID saveDifference(Difference d, DifferenceJobID jobID) throws RPCException, DifferenceDBException {
        RPCManager rpcManager = this.getApplication().getNetSubsystem().getRPC();
        if (rpcManager.getInvokerTransportInfo().isClientSide()) {
            this.mRemoteAgentOperationListener.operationInvoked(rpcManager.getInvokerAddress(), jobID);
        }
        Difference d2 = new Difference(d.getType(), d.getIdentifier(), d.getSourceVal(), d.getDestVal(), d.getSourceOrder(), d.getDestOrder());
        d2.setObjectID(d.getObjectID());
        d2.setTrueClass(d.getClass().getName());
        try {
            d2.save();
        }
        catch (ClassMapException cmex) {
            throw new DifferenceDBException("diff.DB_MAPPING_ERR", (Throwable)cmex);
        }
        catch (PersistenceManagerException pmex) {
            throw new DifferenceDBException("diff.ERR_SAVING", (Throwable)pmex);
        }
        d.setObjectID(d2.getObjectID());
        return (DifferenceID)d.getObjectID();
    }

    public Difference getDifference(DifferenceID dID) throws RPCException, DifferenceDBException {
        if (this.isShuttingDown()) {
            throw new DifferenceDBException("diff.SHUTDOWN_IN_PROGRESS");
        }
        Difference d = new Difference();
        d.setObjectID(dID);
        try {
            d.retrieve();
        }
        catch (ClassMapException cmex) {
            throw new DifferenceDBException("diff.DB_MAPPING_ERR_RETRIEVE", (Throwable)cmex);
        }
        catch (PersistenceManagerException pmex) {
            throw new DifferenceDBException("diff.ERR_RETRIEVE", (Throwable)pmex);
        }
        Difference d2 = (Difference)ClassUtil.createObject(d.getTrueClass(), Difference.class);
        d2.setObjectID(dID);
        d2.setType(d.getType());
        d2.setIdentifier(d.getIdentifier());
        d2.setSourceVal(d.getSourceVal());
        d2.setDestVal(d.getDestVal());
        d2.setSourceOrder(d.getSourceOrder());
        d2.setDestOrder(d.getDestOrder());
        return d2;
    }

    public Difference[] getDifferences(DifferenceID[] dIDs) throws RPCException, DifferenceDBException {
        if (this.isShuttingDown()) {
            throw new DifferenceDBException("diff.SHUTDOWN_IN_PROGRESS");
        }
        Difference[] result = new Difference[dIDs.length];
        for (int i = 0; i < dIDs.length; ++i) {
            result[i] = this.getDifference(dIDs[i]);
        }
        return result;
    }

    public String getSubsystemName() {
        return ROXMessageManager.messageAsString("diff.SUBSYSTEM_NAME_DB");
    }

    public void setAgentOpListener(RemoteAgentOperationListener inAgentOpListener) {
        this.mRemoteAgentOperationListener = inAgentOpListener;
    }

    public RemoteAgentOperationListener getAgentOpListener() {
        return this.mRemoteAgentOperationListener;
    }
}

