/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference.differencedb;

import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsIDSet;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsToComponentNameRefTable;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.NameRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentObserver;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiCompObserverQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import java.util.ArrayList;

class DiffSettingsObserverQuery
implements MultiCompObserverQuery {
    private static DiffSettingsObserverQuery sInstance = null;

    private DiffSettingsObserverQuery() {
    }

    public static DiffSettingsObserverQuery getInstance() {
        if (sInstance == null) {
            sInstance = new DiffSettingsObserverQuery();
        }
        return sInstance;
    }

    public ComponentObserver[] selectCompObservers(String name, SummaryFolder path) throws PersistenceManagerException {
        try {
            String pathStr = path.getFullPathString();
            NameRef[] nrs = DifferenceSettingsToComponentNameRefTable.DEFAULT.getByChildNameAndPath(name, pathStr);
            DifferenceSettingsIDSet id = new DifferenceSettingsIDSet();
            NameRef.parentIDSet(nrs, id);
            ArrayList<DifferenceSettings.DiffSettingsCompObserver> dsal = new ArrayList<DifferenceSettings.DiffSettingsCompObserver>();
            DifferenceSettings[] dses = id.getByIDsQuery().select();
            for (int i = 0; i < dses.length; ++i) {
                dsal.add(dses[i].getComponentObserver());
            }
            return dsal.toArray(new DifferenceSettings.DiffSettingsCompObserver[0]);
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    public void updateCompRefTable(String oldName, FolderID oldPath, String newName, SummaryFolder newPath) throws PersistenceManagerException {
        DifferenceSettingsToComponentNameRefTable.DEFAULT.updateNameRefs(oldName, oldPath, newName, newPath);
    }
}

