/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.DifferencePath;
import com.raplix.rolloutexpress.difference.DifferenceState;
import com.raplix.rolloutexpress.difference.PackageInfo;
import com.raplix.util.Util;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.collections.Compare;
import com.raplix.util.collections.UnorderedListener;
import com.raplix.util.file.ZipUtil;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.TempFile;
import com.raplix.util.iowrappers.ZipFileWrapper;
import com.raplix.util.string.CaseString;
import com.raplix.util.string.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

class ZipDifferencer
implements UnorderedListener {
    private ZipInfo mSrc;
    private ZipInfo mDst;
    private DifferencePath mPath;
    private DifferenceState mState;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class array$Ljava$lang$String;

    private ZipDifferencer(ZipInfo src, ZipInfo dst, DifferencePath path, DifferenceState state) {
        this.mSrc = src;
        this.mDst = dst;
        this.mPath = path;
        this.mState = state;
    }

    public void missing1(Object o2, int i2) {
        String name = ((CaseString)o2).getValue();
        this.reportMissing(name, (ZipEntry)this.mDst.getMap().get(name), this.mSrc.getExistingDirs(), false);
    }

    public void missing2(Object o1, int i1) {
        String name = ((CaseString)o1).getValue();
        this.reportMissing(name, (ZipEntry)this.mSrc.getMap().get(name), this.mDst.getExistingDirs(), true);
    }

    public void match(Object o1, int i1, Object o2, int i2) {
        String name1 = ((CaseString)o1).getValue();
        ZipEntry entry1 = (ZipEntry)this.mSrc.getMap().get(name1);
        String name2 = ((CaseString)o2).getValue();
        ZipEntry entry2 = (ZipEntry)this.mDst.getMap().get(name2);
        if (entry1.isDirectory() || entry2.isDirectory()) {
            if (entry1.isDirectory() != entry2.isDirectory()) {
                this.reportMissing(name1, entry1, this.mDst.getExistingDirs(), true);
                this.reportMissing(name2, entry2, this.mSrc.getExistingDirs(), false);
            }
            return;
        }
        DifferencePath path = this.mPath.extend(this.mState.getExtendDst() ? name2 : name1);
        try {
            this.mSrc.extract(name1);
            this.mDst.extract(name2);
            this.mState.getComparator().apply(this.mSrc.getTemp(), this.mDst.getTemp(), path);
        }
        catch (IOException ex) {
            this.mState.getReporter().reportError(PackageInfo.createGenericFile(path, ex));
        }
    }

    private void reportMissing(String name, ZipEntry entry, HashSet existingDirs, boolean source) {
        String[] dir;
        int type;
        if (entry.isDirectory() && existingDirs.contains(name)) {
            return;
        }
        int n = type = entry.isDirectory() ? 1 : 0;
        while ((dir = StringUtil.split(name, '/'))[0].length() != 0 && !existingDirs.contains(dir[0])) {
            name = dir[0];
            type = 1;
        }
        Difference d = source ? new Difference(type, dir[1], null) : new Difference(type, null, dir[1]);
        this.mState.getReporter().reportDifference(dir[0].length() > 0 ? this.mPath.extend(dir[0]) : this.mPath, d);
    }

    private void apply() {
        Compare.compareUnordered(this.mSrc.getNames(this.mState.getIgnoreCase()), this.mDst.getNames(this.mState.getIgnoreCase()), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void apply(File src, File dst, DifferencePath path, DifferenceState state) throws IOException, ZipException {
        Closer c = new Closer();
        try {
            ZipFile srcZip = new ZipFile(src);
            c.register(new ZipFileWrapper(srcZip));
            TempFile srcTemp = new TempFile();
            c.register(srcTemp);
            ZipFile dstZip = new ZipFile(dst);
            c.register(new ZipFileWrapper(dstZip));
            TempFile dstTemp = new TempFile();
            c.register(dstTemp);
            new ZipDifferencer(new ZipInfo(srcZip, srcTemp.getFile()), new ZipInfo(dstZip, dstTemp.getFile()), path, state).apply();
        }
        finally {
            c.closeAll();
        }
    }

    private static class ZipInfo {
        private ZipFile mZip;
        private Hashtable mMap = new Hashtable();
        private HashSet mExistingDirs;
        private File mTemp;

        ZipInfo(ZipFile zip, File temp) {
            this.mZip = zip;
            this.mTemp = temp;
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String name = Util.trimTrailingSlash(Util.convertToNetworkFileSeparators(entry.getName()));
                this.mMap.put(name, entry);
            }
            this.mExistingDirs = (HashSet)CollectionUtil.mapClass(ZipUtil.getDirectories(zip), class$java$util$HashSet == null ? (class$java$util$HashSet = ZipDifferencer.class$("java.util.HashSet")) : class$java$util$HashSet);
        }

        ZipFile getZip() {
            return this.mZip;
        }

        Hashtable getMap() {
            return this.mMap;
        }

        CaseString[] getNames(boolean upcase) {
            return CaseString.toCaseArray((String[])CollectionUtil.mapClass(this.mMap.keySet(), array$Ljava$lang$String == null ? (array$Ljava$lang$String = ZipDifferencer.class$("[Ljava.lang.String;")) : array$Ljava$lang$String), upcase);
        }

        HashSet getExistingDirs() {
            return this.mExistingDirs;
        }

        File getTemp() {
            return this.mTemp;
        }

        void extract(String name) throws FileNotFoundException, IOException {
            ZipUtil.extract(this.getZip(), (ZipEntry)this.getMap().get(name), this.getTemp());
        }
    }
}

