/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.difference.DifferencePath;
import com.raplix.rolloutexpress.difference.DifferenceState;
import com.raplix.rolloutexpress.difference.XMLDifference;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.collections.Compare;
import com.raplix.util.collections.OrderedListener;
import com.raplix.util.collections.UnorderedListener;
import com.raplix.util.file.XMLUtil;
import com.raplix.util.regex.REUtil;
import com.raplix.util.regex.RegEx;
import com.raplix.util.string.StringUtil;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class XMLDifferencer {
    private static final String SEPARATOR = ":";
    private XMLInfo mSrc;
    private XMLInfo mDst;
    private DifferencePath mPath;
    private DifferenceState mState;
    private RegEx[] mPatterns;

    private XMLDifferencer(XMLInfo src, XMLInfo dst, DifferencePath path, DifferenceState state) {
        this.mSrc = src;
        this.mDst = dst;
        this.mPath = path;
        this.mState = state;
        this.mPatterns = REUtil.compileWildcards(this.mState.getSettings().getXMLOrderedNames(), true);
    }

    private void apply() {
        Vector<ComparableNode> srcChild = new Vector<ComparableNode>();
        srcChild.addElement(new ComparableNode(new ComparableNode(), this.mSrc.getRoot()));
        Vector<ComparableNode> dstChild = new Vector<ComparableNode>();
        dstChild.addElement(new ComparableNode(new ComparableNode(), this.mDst.getRoot()));
        Compare.compareOrdered(srcChild, dstChild, new NodeListener());
    }

    static void apply(InputStream src, InputStream dst, DifferencePath path, DifferenceState state) {
        new XMLDifferencer(new XMLInfo(src), new XMLInfo(dst), path, state).apply();
    }

    private class NodeListener
    implements OrderedListener,
    UnorderedListener {
        private NodeListener() {
        }

        public void missing1(Object o2, int i2) {
            XMLDifferencer.this.mState.getReporter().reportDifference(XMLDifferencer.this.mPath, new XMLDifference(102, null, o2.toString()));
        }

        public void missing2(Object o1, int i1) {
            XMLDifferencer.this.mState.getReporter().reportDifference(XMLDifferencer.this.mPath, new XMLDifference(102, o1.toString(), null));
        }

        public void match(Object o1, int i1, Object o2, int i2) {
            this.match(o1, o2, 0);
        }

        public void match(Object o1, Object o2, int i) {
            ComparableNode srcNode = (ComparableNode)o1;
            ComparableNode dstNode = (ComparableNode)o2;
            if (srcNode.getType() != 1) {
                return;
            }
            if (srcNode.getOrdered()) {
                Hashtable srcAttr = srcNode.getAttributeTable();
                Hashtable dstAttr = dstNode.getAttributeTable();
                Compare.compareUnordered(srcAttr.keySet(), dstAttr.keySet(), new AttributeListener(srcNode.getNodePath() + XMLDifferencer.SEPARATOR, srcAttr, dstAttr));
            }
            Vector srcChild = srcNode.getChildren();
            Vector dstChild = dstNode.getChildren();
            if (srcNode.getChildrenOrdered()) {
                Compare.compareOrdered(srcChild, dstChild, this);
            } else {
                Compare.compareUnordered(srcChild, dstChild, this);
            }
        }

        public void mismatch(Object o1, Object o2, int i) {
            ComparableNode srcNode = (ComparableNode)o1;
            ComparableNode dstNode = (ComparableNode)o2;
            String srcPrefix = srcNode.getNodePath();
            String dstPrefix = dstNode.getNodePath();
            if (srcNode.getType() != dstNode.getType()) {
                XMLDifferencer.this.mState.getReporter().reportDifference(XMLDifferencer.this.mPath, new XMLDifference(104, srcPrefix + XMLDifferencer.SEPARATOR + srcNode.getType(), dstPrefix + XMLDifferencer.SEPARATOR + dstNode.getType()));
                return;
            }
            if (srcNode.getType() == 3 || srcNode.getType() == 4) {
                XMLDifferencer.this.mState.getReporter().reportDifference(XMLDifferencer.this.mPath, new XMLDifference(105, srcPrefix + XMLDifferencer.SEPARATOR + srcNode.getValue(), dstPrefix + XMLDifferencer.SEPARATOR + dstNode.getValue()));
                return;
            }
            if (srcNode.getType() == 1) {
                XMLDifferencer.this.mState.getReporter().reportDifference(XMLDifferencer.this.mPath, new XMLDifference(103, srcPrefix, dstPrefix));
                return;
            }
        }
    }

    private class AttributeListener
    implements UnorderedListener {
        private String mNodePath;
        private Hashtable mSrcAttr;
        private Hashtable mDstAttr;

        AttributeListener(String nodePath, Hashtable srcAttr, Hashtable dstAttr) {
            this.mNodePath = nodePath;
            this.mSrcAttr = srcAttr;
            this.mDstAttr = dstAttr;
        }

        public void missing1(Object o2, int i2) {
            XMLDifferencer.this.mState.getReporter().reportDifference(XMLDifferencer.this.mPath, new XMLDifference(100, null, this.mNodePath + o2));
        }

        public void missing2(Object o1, int i1) {
            XMLDifferencer.this.mState.getReporter().reportDifference(XMLDifferencer.this.mPath, new XMLDifference(100, this.mNodePath + o1, null));
        }

        public void match(Object o1, int i1, Object o2, int i2) {
            String name = (String)o1;
            String srcValue = (String)this.mSrcAttr.get(name);
            String dstValue = (String)this.mDstAttr.get(name);
            if (!dstValue.equals(srcValue)) {
                String prefix = this.mNodePath + name + "=";
                XMLDifferencer.this.mState.getReporter().reportDifference(XMLDifferencer.this.mPath, new XMLDifference(101, prefix + srcValue, prefix + dstValue));
            }
        }
    }

    private class ComparableNode {
        private ComparableNode mParent;
        private Node mNode;
        private String mNodePath;
        private String mFullName;
        private boolean mChildrenOrdered;
        private Hashtable mAttributesTable;
        private Vector mAttributesVector;
        private Vector mChildren;

        ComparableNode(ComparableNode parent, Node node) {
            this.mParent = parent;
            this.mNode = node;
            this.mNodePath = StringUtil.extend(this.getParent().getNodePath(), XMLDifferencer.SEPARATOR, this.getName());
            if (this.getType() == 1 && !this.getOrdered()) {
                this.mNodePath = this.mNodePath + '[' + CollectionUtil.toString(this.getAttributes()) + ']';
            }
            this.mFullName = StringUtil.extend(this.getParent().getFullName(), XMLDifferencer.SEPARATOR, this.getName());
            this.mChildrenOrdered = false;
            for (int i = 0; i < XMLDifferencer.this.mPatterns.length; ++i) {
                if (!XMLDifferencer.this.mPatterns[i].match(this.getFullName().toUpperCase())) continue;
                this.mChildrenOrdered = true;
                break;
            }
        }

        ComparableNode() {
            this.mParent = null;
            this.mNode = null;
            this.mNodePath = "";
            this.mFullName = XMLDifferencer.this.mPath.toString();
            this.mChildrenOrdered = false;
        }

        ComparableNode getParent() {
            return this.mParent;
        }

        String getName() {
            return this.mNode.getNodeName();
        }

        String getValue() {
            return this.mNode.getNodeValue();
        }

        short getType() {
            return this.mNode.getNodeType();
        }

        String getNodePath() {
            return this.mNodePath;
        }

        String getFullName() {
            return this.mFullName;
        }

        boolean getChildrenOrdered() {
            return this.mChildrenOrdered;
        }

        boolean getOrdered() {
            return this.getParent().getChildrenOrdered();
        }

        Hashtable getAttributeTable() {
            if (this.mAttributesTable != null) {
                return this.mAttributesTable;
            }
            this.mAttributesTable = new Hashtable();
            NamedNodeMap raw = this.mNode.getAttributes();
            for (int i = 0; i < raw.getLength(); ++i) {
                Node n = raw.item(i);
                this.mAttributesTable.put(n.getNodeName(), n.getNodeValue());
            }
            return this.mAttributesTable;
        }

        Vector getAttributes() {
            if (this.mAttributesVector != null) {
                return this.mAttributesVector;
            }
            this.mAttributesVector = new Vector();
            NamedNodeMap raw = this.mNode.getAttributes();
            for (int i = 0; i < raw.getLength(); ++i) {
                Node n = raw.item(i);
                this.mAttributesVector.addElement(n.getNodeName() + "=" + n.getNodeValue());
            }
            return this.mAttributesVector;
        }

        Vector getChildren() {
            if (this.mChildren != null) {
                return this.mChildren;
            }
            this.mChildren = new Vector();
            NodeList raw = this.mNode.getChildNodes();
            for (int i = 0; i < raw.getLength(); ++i) {
                Node n = raw.item(i);
                if (n.getNodeType() != 1 && (n.getNodeType() != 3 && n.getNodeType() != 4 || StringUtil.isEmpty(n.getNodeValue()))) continue;
                this.mChildren.addElement(new ComparableNode(this, n));
            }
            return this.mChildren;
        }

        public boolean equals(Object o) {
            ComparableNode cn = (ComparableNode)o;
            if (this.getType() != cn.getType()) {
                return false;
            }
            if (this.getType() == 3 || this.getType() == 4) {
                return this.getValue().equals(cn.getValue());
            }
            if (this.getType() == 1) {
                if (!this.getName().equals(cn.getName())) {
                    return false;
                }
                return this.getOrdered() || Compare.isPermutation(this.getAttributes(), cn.getAttributes());
            }
            return false;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(this.getNodePath());
            if (this.getType() == 3 || this.getType() == 4) {
                b.append('[');
                b.append(this.getValue());
                b.append(']');
            }
            return b.toString();
        }
    }

    private static class XMLInfo {
        private Element mRoot;

        XMLInfo(InputStream doc) {
            this.mRoot = XMLUtil.parse(new InputSource(doc)).getDocumentElement();
        }

        Element getRoot() {
            return this.mRoot;
        }
    }
}

