/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.DifferenceEngine;
import com.raplix.rolloutexpress.difference.DifferenceException;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.DifferenceMessages;
import com.raplix.rolloutexpress.difference.DifferencePath;
import com.raplix.rolloutexpress.difference.DifferenceUtil;
import com.raplix.rolloutexpress.difference.TeamContext;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.util.threads.RunnableContext;

abstract class TeamWorker
extends RunnableContext
implements DifferenceMessages {
    private DifferenceSettings mSettings;
    private int mWorkerID;

    TeamWorker(TeamContext context, DifferenceSettings settings) {
        super(context.getName() + "-" + settings.getName(), context);
        this.mSettings = settings;
    }

    private TeamContext getTeamContext() {
        return (TeamContext)this.getParent();
    }

    private DifferenceEngine getEngine() {
        return this.getTeamContext().getEngine();
    }

    protected DifferenceSettings getSettings() {
        return this.mSettings;
    }

    protected DifferenceJobID getJobID() {
        return this.getTeamContext().getJobID();
    }

    protected Application getApplication() {
        return this.getTeamContext().getApplication();
    }

    protected void reportProgress(double progress) {
        this.getTeamContext().reportProgress(this.mWorkerID, progress);
    }

    protected void reportDifference(DifferencePath path, Difference d) {
        DifferenceUtil.reportDifference(this.getTeamContext().getApplication(), path, d, this.getJobID());
    }

    protected void reportError(Exception ex) {
        DifferenceUtil.reportError(this.getTeamContext().getApplication(), this.getJobID(), ex);
    }

    protected TeamContext.AgentInfo getAgentInfo(Host host) throws RaplixException {
        return this.getTeamContext().getAgentInfo(host);
    }

    protected void safeRun() throws Exception {
        this.acquire(this.getEngine().getThrottle());
        try {
            this.runSelf();
        }
        catch (InterruptedException ex) {
            this.reportError(new DifferenceException("diff.ERR_TIMEOUT", (Throwable)ex, new Object[]{DifferenceUtil.getHost(new HostID(this.getSettings().getDstHostID())).getName()}));
        }
    }

    protected abstract void runSelf() throws InterruptedException;

    void setWorkerID(int workerID) {
        this.mWorkerID = workerID;
    }
}

