/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.command.stickydata.ItemID;
import com.raplix.rolloutexpress.command.stickydata.StickyInterface;
import com.raplix.rolloutexpress.difference.DifferenceAgentInterface;
import com.raplix.rolloutexpress.difference.DifferenceEngine;
import com.raplix.rolloutexpress.difference.DifferenceException;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.DifferenceMessages;
import com.raplix.rolloutexpress.difference.DifferenceUtil;
import com.raplix.rolloutexpress.difference.TeamWorker;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.util.logger.Logger;
import com.raplix.util.rwlock.LockContext;
import com.raplix.util.rwlock.RWLock;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.ContextThread;
import com.raplix.util.threads.ContextTimeoutMonitor;
import com.raplix.util.threads.RunnableContext;
import com.raplix.util.threads.ThreadAbortedException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class TeamContext
extends RunnableContext
implements DifferenceMessages {
    private static final long WORKER_STATUS_QUANTUM = 5000L;
    private boolean mDidGrabLock = false;
    private DifferenceEngine mEngine;
    private DifferenceSettings mSettings;
    private DifferenceJobID mJobID;
    private Vector mWorkers = new Vector();
    private double[] mWorkerProgress;
    private double mWorkerTotal;
    private boolean mCompleted;
    private Object mNotifyLock = new Object();
    private Hashtable mAgentInfo = new Hashtable();
    static /* synthetic */ Class class$com$raplix$rolloutexpress$difference$DifferenceAgentInterface;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$command$stickydata$StickyInterface;

    TeamContext(Context context, DifferenceEngine engine, DifferenceSettings settings, DifferenceJobID jobID) {
        super(jobID.toString(), context);
        this.mEngine = engine;
        this.mSettings = settings;
        this.mJobID = jobID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportCompletion(boolean aborted) {
        Object object = this.mNotifyLock;
        synchronized (object) {
            this.mCompleted = true;
            DifferenceUtil.reportProgress(this.getApplication(), this.getJobID(), 100);
            if (aborted) {
                DifferenceUtil.reportJobAborted(this.getApplication(), this.getJobID());
            }
            DifferenceUtil.reportJobCompleted(this.getApplication(), this.getJobID(), this.mSettings.getID());
        }
    }

    protected void started() {
        super.started();
        DifferenceUtil.reportJobStarted(this.getApplication(), this.getJobID(), this.mSettings.getID());
    }

    boolean getDidGrabLock() {
        return this.mDidGrabLock;
    }

    protected void ended() {
        super.ended();
        this.reportCompletion(false);
    }

    protected void aborted(ThreadAbortedException ex) {
        super.aborted(ex);
        this.reportCompletion(true);
    }

    protected void failed(Throwable t) {
        super.failed(t);
        this.reportCompletion(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws Exception {
        Hashtable hashtable;
        try {
            super.release();
            Object var2_1 = null;
            hashtable = this.mAgentInfo;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Hashtable hashtable2 = this.mAgentInfo;
            synchronized (hashtable2) {
                Enumeration e = this.mAgentInfo.keys();
                while (e.hasMoreElements()) {
                    ((AgentInfo)this.mAgentInfo.get(e.nextElement())).deleteState();
                }
            }
            this.getEngine().subsystemTaskComplete(this.getName());
            throw throwable;
        }
        synchronized (hashtable) {
            Enumeration e = this.mAgentInfo.keys();
            while (e.hasMoreElements()) {
                ((AgentInfo)this.mAgentInfo.get(e.nextElement())).deleteState();
            }
        }
        this.getEngine().subsystemTaskComplete(this.getName());
    }

    public void abort() {
        DifferenceUtil.checkPermissions(this.mSettings);
        DifferenceUtil.reportJobAbortRequested(this.getApplication(), this.getJobID());
        super.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void safeRun() throws Exception {
        try {
            RWLock theSystemLock = PersistenceManager.getInstance().getSystemLockObject();
            LockContext theLockContext = new LockContext(){

                public Object execute() throws Exception {
                    TeamContext.this.mDidGrabLock = true;
                    DifferenceUtil.reportProgress(TeamContext.this.getApplication(), TeamContext.this.getJobID(), 0);
                    TeamContext.access$202(TeamContext.this, new double[TeamContext.this.mWorkers.size()]);
                    TeamContext.this.testFlow();
                    ContextTimeoutMonitor monitor = new ContextTimeoutMonitor();
                    Enumeration e = TeamContext.this.mWorkers.elements();
                    while (e.hasMoreElements()) {
                        ContextThread t = (ContextThread)e.nextElement();
                        t.start();
                        monitor.addThread(t);
                    }
                    try {
                        if (TeamContext.this.mSettings.getTimeoutSecs() != -1) {
                            monitor.monitor(TeamContext.this.mSettings.getTimeoutSecs() * 1000, 5000L);
                        }
                        monitor.join();
                    }
                    catch (InterruptedException ex) {
                        monitor.monitor(0L, 0L);
                        monitor.join();
                    }
                    return null;
                }
            };
            String theMsg = ROXMessageManager.messageAsString("diff.LOCK_MESSAGE", new Object[]{this.mSettings.getName(), this.mSettings.getDescription()});
            theSystemLock.readLock(theMsg, theLockContext);
        }
        finally {
            this.mDidGrabLock = true;
        }
        this.testFlow();
    }

    protected AgentInfo createAgentInfo(Host host) throws RaplixException {
        return new AgentInfo(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AgentInfo getAgentInfo(Host host) throws RaplixException {
        AgentInfo info;
        Hashtable hashtable = this.mAgentInfo;
        synchronized (hashtable) {
            info = (AgentInfo)this.mAgentInfo.get(host.getID());
            if (info == null) {
                info = this.createAgentInfo(host);
                this.mAgentInfo.put(host.getID(), info);
            }
        }
        return info;
    }

    void addWorker(TeamWorker worker) throws DifferenceException {
        try {
            worker.setWorkerID(this.mWorkers.size());
            this.mWorkers.addElement(this.getApplication().getUserDBSubsystem().getSessionTable().createThreadForCurrentSession(worker));
        }
        catch (UnsupportedSubsystemException ex) {
            throw new DifferenceException("diff.ERR_MISSING_SUBSYS", (Throwable)ex);
        }
    }

    DifferenceEngine getEngine() {
        return this.mEngine;
    }

    Application getApplication() {
        return this.getEngine().getApplication();
    }

    DifferenceJobID getJobID() {
        return this.mJobID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportProgress(int workerID, double progress) {
        double[] dArray = this.mWorkerProgress;
        synchronized (this.mWorkerProgress) {
            this.mWorkerTotal -= this.mWorkerProgress[workerID];
            this.mWorkerProgress[workerID] = progress;
            this.mWorkerTotal += this.mWorkerProgress[workerID];
            DifferenceUtil.reportProgress(this.getApplication(), this.getJobID(), (int)Math.round(this.mWorkerTotal / (double)this.mWorkerProgress.length));
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(ROXEvent event) throws RPCException, DifferenceException {
        Object object = this.mNotifyLock;
        synchronized (object) {
            if (this.mCompleted) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Rejecting event '" + event + "'", this);
                }
                return;
            }
            this.getEngine().notify(event);
        }
    }

    static /* synthetic */ double[] access$202(TeamContext x0, double[] x1) {
        x0.mWorkerProgress = x1;
        return x1;
    }

    class AgentInfo {
        private DifferenceAgentInterface mAgentEngine;
        private ItemID mHandle;

        AgentInfo(Host host) throws RaplixException {
            block2: {
                this.mAgentEngine = (DifferenceAgentInterface)TeamContext.this.getApplication().getRPCInterface(host.getRARoxAddress(), class$com$raplix$rolloutexpress$difference$DifferenceAgentInterface == null ? (class$com$raplix$rolloutexpress$difference$DifferenceAgentInterface = TeamContext.class$("com.raplix.rolloutexpress.difference.DifferenceAgentInterface")) : class$com$raplix$rolloutexpress$difference$DifferenceAgentInterface);
                this.mHandle = this.getAgentEngine().createState(new BagID(TeamContext.this.getJobID().toString()), TeamContext.this.mSettings, TeamContext.this.getJobID());
                try {
                    TeamContext.this.getEngine().removeStaleResources((StickyInterface)TeamContext.this.getApplication().getRPCInterface(host.getRARoxAddress(), class$com$raplix$rolloutexpress$command$stickydata$StickyInterface == null ? (class$com$raplix$rolloutexpress$command$stickydata$StickyInterface = TeamContext.class$("com.raplix.rolloutexpress.command.stickydata.StickyInterface")) : class$com$raplix$rolloutexpress$command$stickydata$StickyInterface));
                }
                catch (RaplixException ex) {
                    if (!Logger.isErrorEnabled(this)) break block2;
                    Logger.error(ROXMessageManager.messageAsString("diff.UNREMOVABLE_STALE"), ex, this);
                }
            }
        }

        DifferenceAgentInterface getAgentEngine() {
            return this.mAgentEngine;
        }

        ItemID getHandle() {
            return this.mHandle;
        }

        void deleteState() {
            block2: {
                try {
                    this.getAgentEngine().deleteState(this.getHandle());
                }
                catch (RPCException ex) {
                    if (!Logger.isErrorEnabled(this)) break block2;
                    Logger.error(ROXMessageManager.messageAsString("diff.UNDELETABLE_STATE"), ex, this);
                }
            }
        }
    }
}

