/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.difference.ContextualDifference;
import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.DifferencePath;
import com.raplix.rolloutexpress.difference.DifferenceState;
import com.raplix.rolloutexpress.difference.Sink;
import com.raplix.util.logger.Logger;
import java.util.HashSet;

public class Reporter
implements Sink {
    private DifferenceState mState;
    private HashSet mReported = new HashSet();

    Reporter(DifferenceState state) {
        this.mState = state;
    }

    public void reportDifference(DifferencePath path, Difference d) {
        if (this.mState.getFilter().match(path)) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Ignoring difference at '" + path + "': " + d, this);
            }
            return;
        }
        ContextualDifference cd = new ContextualDifference(path, d);
        if (this.mReported.contains(cd)) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Blocking difference at '" + path + "': " + d, this);
            }
            return;
        }
        this.mReported.add(cd);
        this.mState.getRawSink().reportDifference(path, d);
    }

    public void reportError(Exception ex) {
        this.mState.getRawSink().reportError(ex);
    }
}

