/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.command.NativePlatformIntegration;
import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.DifferenceException;
import com.raplix.rolloutexpress.difference.DifferencePath;
import com.raplix.rolloutexpress.difference.DifferenceState;
import com.raplix.rolloutexpress.difference.PackageInfo;
import java.io.File;

class PlatformDifferencer {
    private DifferenceState mState;
    private NativePlatformIntegration mPlatform;
    private int mType;

    PlatformDifferencer(DifferenceState state) throws DifferenceException {
        try {
            this.mState = state;
            this.mPlatform = this.mState.getAgent().getNativeSubsystem();
            this.mType = this.mPlatform.getConfigDiffIsDiffOut() ? 6 : 8;
        }
        catch (RaplixException ex) {
            throw PackageInfo.createPlatformInit(ex);
        }
    }

    void apply(File src, File dst, DifferencePath path) {
        try {
            this.mState.getReporter().reportDifference(path, new Difference(this.mType, this.mPlatform.getNativeInterface().execNative(this.mPlatform.getConfigShellDiffCommand() + "\"" + src.getAbsolutePath() + "\" \"" + dst.getAbsolutePath() + "\"").getOutput(), null));
        }
        catch (RaplixException ex) {
            this.mState.getReporter().reportError(PackageInfo.createPlatformDiff(path, ex));
        }
    }
}

