/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.difference.DifferenceException;
import com.raplix.rolloutexpress.difference.DifferencePath;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotID;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "diff";
    public static final String EX_BAD_SNAPSHOT_QUERY = "diff.EX_BAD_SNAPSHOT_QUERY";
    public static final String EX_II_PATH_FAILURE = "diff.EX_II_PATH_FAILURE";
    public static final String EX_II_FAILURE_UNREADABLE_DIR = "diff.EX_II_FAILURE_UNREADABLE_DIR";
    public static final String EX_DUPLICATE_ENTRY = "diff.EX_DUPLICATE_ENTRY";
    public static final String EX_PLATFORM_INIT = "diff.EX_PLATFORM_INIT";
    public static final String EX_PLATFORM_DIFF = "diff.EX_PLATFORM_DIFF";
    public static final String EX_GENERIC_LINK = "diff.EX_GENERIC_LINK";
    public static final String EX_GENERIC_FILE = "diff.EX_GENERIC_FILE";
    public static final String EX_GENERIC_DIRECTORY = "diff.EX_GENERIC_DIRECTORY";
    public static final String EX_REPORT = "diff.EX_REPORT";
    public static final String EX_REPORT_EVENT = "diff.EX_REPORT_EVENT";
    public static final String EX_HOSTDB = "diff.EX_HOSTDB";

    private PackageInfo() {
    }

    public static DifferenceException createBadSnapshotQuery(DifferencePath path, Exception ex) {
        return new DifferenceException(EX_BAD_SNAPSHOT_QUERY, (Throwable)ex, new Object[]{path.toString()});
    }

    public static DifferenceException createPathFailure(DifferencePath path, Exception ex) {
        return new DifferenceException(EX_II_PATH_FAILURE, (Throwable)ex, new Object[]{path.toString()});
    }

    public static DifferenceException createUnreadableDirFailure(String path, Exception ex) {
        return new DifferenceException(EX_II_FAILURE_UNREADABLE_DIR, (Throwable)ex, new Object[]{path});
    }

    public static DifferenceException createDuplicateEntry(String name, InstalledComponentID cID, SnapshotID ID2) {
        return new DifferenceException(EX_DUPLICATE_ENTRY, new Object[]{name, cID.toString(), ID2.toString()});
    }

    public static DifferenceException createPlatformInit(Exception ex) {
        return new DifferenceException(EX_PLATFORM_INIT, (Throwable)ex);
    }

    public static DifferenceException createPlatformDiff(DifferencePath path, Exception ex) {
        return new DifferenceException(EX_PLATFORM_DIFF, (Throwable)ex, new Object[]{path});
    }

    public static DifferenceException createGenericLink(DifferencePath path, Exception ex) {
        return new DifferenceException(EX_GENERIC_LINK, (Throwable)ex, new Object[]{path});
    }

    public static DifferenceException createGenericFile(DifferencePath path, Exception ex) {
        return new DifferenceException(EX_GENERIC_FILE, (Throwable)ex, new Object[]{path});
    }

    public static DifferenceException createGenericDirectory(DifferencePath path, Exception ex) {
        return new DifferenceException(EX_GENERIC_DIRECTORY, (Throwable)ex, new Object[]{path});
    }

    public static DifferenceException createReport(Exception ex) {
        return new DifferenceException(EX_REPORT, (Throwable)ex);
    }

    public static DifferenceException createReportEvent(ROXEvent e, Exception ex) {
        return new DifferenceException(EX_REPORT_EVENT, (Throwable)ex, new Object[]{e.describe()});
    }

    public static DifferenceException createReportEvent(ROXEvent e) {
        return new DifferenceException(EX_REPORT_EVENT, new Object[]{e.describe()});
    }

    public static DifferenceException createHostDB(Exception ex) {
        return new DifferenceException(EX_HOSTDB, (Throwable)ex);
    }
}

