/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.Ora;
import com.raplix.rolloutexpress.difference.ParseException;
import com.raplix.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Vector;

public class ORADifference
extends Difference {
    public static final int DIFF_KEY_MISSING = 200;
    public static final int DIFF_VALUES_MISSING = 201;
    public static final int DIFF_VALUE_TYPE_MISMATCH = 202;
    public static final int DIFF_VALUE_MISMATCH = 203;

    public ORADifference() {
    }

    public ORADifference(int type, String srcVal, String dstVal) {
        super(type, null, srcVal, dstVal, 0, 0);
    }

    private static Vector doDiff(Ora.PairVector src, Ora.PairVector dst) {
        Vector<ORADifference> diffs = new Vector<ORADifference>(0);
        Enumeration e = src.elements();
        while (e.hasMoreElements()) {
            int numVals;
            Pair srcPair = (Pair)e.nextElement();
            String srcKey = (String)srcPair.getKey();
            Pair dstPair = null;
            ListIterator de = dst.listIterator();
            while (de.hasNext()) {
                Pair p = (Pair)de.next();
                if (!p.getKey().equals(srcKey)) continue;
                dstPair = p;
                de.remove();
                break;
            }
            if (dstPair == null) {
                diffs.addElement(new ORADifference(200, srcKey, null));
                continue;
            }
            Vector srcVector = (Vector)srcPair.getValue();
            Vector dstVector = (Vector)dstPair.getValue();
            if (srcVector.size() < dstVector.size()) {
                numVals = srcVector.size();
                diffs.addElement(new ORADifference(201, null, srcKey));
            } else if (dstVector.size() < srcVector.size()) {
                numVals = dstVector.size();
                diffs.addElement(new ORADifference(201, srcKey, null));
            } else {
                numVals = srcVector.size();
            }
            for (int i = 0; i < numVals; ++i) {
                Object srcObject = srcVector.elementAt(i);
                Object dstObject = dstVector.elementAt(i);
                if (srcObject.getClass() != dstObject.getClass()) {
                    diffs.addElement(new ORADifference(202, srcKey, null));
                    continue;
                }
                if (srcObject instanceof String) {
                    if (((String)srcObject).equals((String)dstObject)) continue;
                    diffs.addElement(new ORADifference(203, srcKey + "=" + (String)srcObject, srcKey + "=" + (String)dstObject));
                    continue;
                }
                if (srcObject instanceof Ora.PairVector && dstObject instanceof Ora.PairVector) {
                    diffs.addAll(ORADifference.doDiff((Ora.PairVector)srcObject, (Ora.PairVector)dstObject));
                    continue;
                }
                if (!(srcObject instanceof Vector)) continue;
                ORADifference.diffVectors((Vector)srcObject, (Vector)dstObject, diffs, srcKey + "=");
            }
        }
        e = dst.elements();
        while (e.hasMoreElements()) {
            diffs.addElement(new ORADifference(200, null, (String)((Pair)e.nextElement()).getKey()));
        }
        return diffs;
    }

    private static void diffVectors(Vector src, Vector dst, Vector diffs, String prepend) {
        String theValue;
        int i;
        for (i = 0; i < src.size(); ++i) {
            theValue = (String)src.elementAt(i);
            if (ORADifference.stringInVector(dst, theValue)) continue;
            diffs.addElement(new ORADifference(201, prepend + theValue, null));
        }
        for (i = 0; i < dst.size(); ++i) {
            theValue = (String)dst.elementAt(i);
            if (ORADifference.stringInVector(src, theValue)) continue;
            diffs.addElement(new ORADifference(201, null, prepend + theValue));
        }
    }

    private static boolean stringInVector(Vector inVector, String inString) {
        for (int i = 0; i < inVector.size(); ++i) {
            if (!((String)inVector.elementAt(i)).equals(inString)) continue;
            return true;
        }
        return false;
    }

    private static Ora.PairVector parse(BufferedReader inFile) throws ParseException {
        Ora.ReInit(inFile);
        return Ora.Input();
    }

    public String toString() {
        switch (this.getType()) {
            case 200: {
                if (this.getSourceVal() != null) {
                    return "Key missing from destination: " + this.getSourceVal();
                }
                return "Key missing from source: " + this.getDestVal();
            }
            case 201: {
                if (this.getSourceVal() != null) {
                    return "Destination is missing values for the key: " + this.getSourceVal();
                }
                return "Source is missing values for the key: " + this.getDestVal();
            }
            case 202: {
                return "Value type mismatch (String vs. List) on key: " + this.getSourceVal();
            }
            case 203: {
                return "Value mismatch. Source is: " + this.getSourceVal() + ", destination is: " + this.getDestVal();
            }
        }
        throw new IllegalArgumentException("Invalid type: " + this.getType());
    }

    public static Vector diffORAFiles(InputStream inSourceFile, InputStream inDestFile) throws IOException {
        BufferedReader srcReader = new BufferedReader(new InputStreamReader(inSourceFile));
        BufferedReader destReader = new BufferedReader(new InputStreamReader(inDestFile));
        Ora.PairVector sourcePairs = null;
        Ora.PairVector destPairs = null;
        try {
            sourcePairs = ORADifference.parse(srcReader);
            destPairs = ORADifference.parse(destReader);
        }
        catch (Exception ex) {
            throw new IOException();
        }
        return ORADifference.doDiff(sourcePairs, destPairs);
    }
}

