/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.DifferenceException;
import com.raplix.rolloutexpress.difference.MMDifferencePath;
import com.raplix.rolloutexpress.difference.TeamContext;
import com.raplix.rolloutexpress.difference.TeamWorker;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.util.collections.Compare;
import com.raplix.util.collections.UnorderedListener;
import java.util.Enumeration;
import java.util.Hashtable;

class MMWorker
extends TeamWorker {
    private NotificationManager mNotification;
    private InstallDBSubsystem mInstallDB;

    MMWorker(TeamContext context, DifferenceSettings settings) {
        super(context, settings);
    }

    private void report(String ID2, int type, boolean source) {
        Difference d = source ? new Difference(type, ID2, null) : new Difference(type, null, ID2);
        this.reportDifference(d);
    }

    private void reportPaths(Hashtable pathMap, int type, boolean source) {
        Enumeration e = pathMap.keys();
        while (e.hasMoreElements()) {
            this.report(((Pair)pathMap.get(e.nextElement())).getID(), type, source);
        }
    }

    private Hashtable getComponents(String hIDstr) throws DifferenceException, InterruptedException {
        try {
            HostID hID = new HostID(hIDstr);
            InstalledComponent[] result = MultiInstalledComponentQuery.byHost(hID, TargetType.CURRENT).selectICView();
            Hashtable<String, Hashtable<String, Pair>> nameMap = new Hashtable<String, Hashtable<String, Pair>>();
            for (int index = 0; index < result.length; ++index) {
                InstalledComponent ic = result[index];
                InstalledComponentID icID = ic.getID();
                SummaryComponent c = ic.getComponentID().getByIDQuery().selectSummaryView();
                String name = c.getName();
                Hashtable<String, Pair> pathMap = (Hashtable<String, Pair>)nameMap.get(name);
                if (pathMap == null) {
                    pathMap = new Hashtable<String, Pair>();
                    nameMap.put(name, pathMap);
                }
                pathMap.put(ic.getInstallPath(), new Pair(c.getVersionNumber().getAsString(), icID.toString()));
            }
            return nameMap;
        }
        catch (RaplixException ex) {
            throw new DifferenceException("diff.ERR_COMP_QUERY", (Throwable)ex);
        }
    }

    protected void reportDifference(Difference d) {
        this.reportDifference(new MMDifferencePath(), d);
    }

    protected void runSelf() throws InterruptedException {
        Hashtable dstMap;
        Hashtable srcMap;
        try {
            this.mNotification = this.getApplication().getNotificationManager();
            this.mInstallDB = this.getApplication().getInstallDBSubsystem();
        }
        catch (UnsupportedSubsystemException ex) {
            this.reportError(new DifferenceException("diff.ERR_MISSING_SUBSYS"));
            return;
        }
        try {
            srcMap = this.getComponents(this.getSettings().getSrcHostID());
            this.reportProgress(25.0);
            dstMap = this.getComponents(this.getSettings().getDstHostID());
            this.reportProgress(50.0);
        }
        catch (DifferenceException ex) {
            this.reportError(ex);
            return;
        }
        Compare.compareUnordered(srcMap.keySet(), dstMap.keySet(), new NameListener(srcMap, dstMap));
    }

    private class PathListener
    implements UnorderedListener {
        private Hashtable mSrcPathMap;
        private Hashtable mDstPathMap;

        PathListener(Hashtable srcPathMap, Hashtable dstPathMap) {
            this.mSrcPathMap = srcPathMap;
            this.mDstPathMap = dstPathMap;
        }

        public void missing1(Object o2, int i2) {
            MMWorker.this.report(((Pair)this.mDstPathMap.get(o2)).getID(), 4, false);
        }

        public void missing2(Object o1, int i1) {
            MMWorker.this.report(((Pair)this.mSrcPathMap.get(o1)).getID(), 4, true);
        }

        public void match(Object o1, int i1, Object o2, int i2) {
            Pair srcVersionPair = (Pair)this.mSrcPathMap.get(o1);
            Pair dstVersionPair = (Pair)this.mDstPathMap.get(o2);
            if (!srcVersionPair.getVersion().equals(dstVersionPair.getVersion())) {
                MMWorker.this.reportDifference(new Difference(5, srcVersionPair.getID(), dstVersionPair.getID()));
            }
        }
    }

    private class NameListener
    implements UnorderedListener {
        private Hashtable mSrcNameMap;
        private Hashtable mDstNameMap;

        NameListener(Hashtable srcNameMap, Hashtable dstNameMap) {
            this.mSrcNameMap = srcNameMap;
            this.mDstNameMap = dstNameMap;
        }

        public void missing1(Object o2, int i2) {
            MMWorker.this.reportPaths((Hashtable)this.mDstNameMap.get(o2), 3, false);
        }

        public void missing2(Object o1, int i1) {
            MMWorker.this.reportPaths((Hashtable)this.mSrcNameMap.get(o1), 3, true);
        }

        public void match(Object o1, int i1, Object o2, int i2) {
            Hashtable srcPathMap = (Hashtable)this.mSrcNameMap.get(o1);
            Hashtable dstPathMap = (Hashtable)this.mDstNameMap.get(o2);
            Compare.compareUnordered(srcPathMap.keySet(), dstPathMap.keySet(), new PathListener(srcPathMap, dstPathMap));
        }
    }

    private static class Pair {
        private String mVersion;
        private String mID;

        Pair(String version, String ID2) {
            this.mVersion = version;
            this.mID = ID2;
        }

        String getVersion() {
            return this.mVersion;
        }

        String getID() {
            return this.mID;
        }
    }
}

