/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenSubsystem;
import com.raplix.rolloutexpress.difference.DifferenceEngine;
import com.raplix.rolloutexpress.difference.DifferenceException;
import com.raplix.rolloutexpress.difference.DifferenceUtil;
import com.raplix.rolloutexpress.difference.MIContext;
import com.raplix.rolloutexpress.difference.MIDifferencePath;
import com.raplix.rolloutexpress.difference.TeamContext;
import com.raplix.rolloutexpress.difference.TeamWorker;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.executor.PlanSubsystem;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiSnapshotQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.Snapshot;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotStatus;
import com.raplix.util.Progress;

class MIWorker
extends TeamWorker {
    private HostID mDstHostID;
    private Host mDstHost;
    private ConfigGenSubsystem mConfig;
    private PlanSubsystem mPlan;
    private DifferenceEngine.AgentOperationValidator mAgentOpValidator;

    MIWorker(TeamContext context, DifferenceSettings settings) {
        super(context, settings);
    }

    private void diffRootComponent(Progress p, InstalledComponentID icID) throws InterruptedException {
        try {
            InstalledComponent[] result = MultiInstalledComponentQuery.byRootContainer(icID).selectICView();
            p = p.nest(result.length);
            for (int i = 0; i < result.length; ++i) {
                this.testFlow();
                this.diffComponent(p, result[i].getID());
                p.next();
            }
        }
        catch (RaplixException ex) {
            this.reportError(new DifferenceException("diff.ERR_COMP_QUERY", (Throwable)ex));
            return;
        }
    }

    private void diffComponent(Progress p, InstalledComponentID icID) throws InterruptedException {
        try {
            MIDifferencePath path = new MIDifferencePath();
            path.setComponentID(icID);
            InstalledComponent ic = icID.getByIDQuery().select();
            Component c = ic.getComponentID().getByIDQuery().select();
            path.setComponentVersion(c.getVersionNumber());
            path.setComponentName(c.getFullName());
            MultiSnapshotQuery q = icID.getSnapshotsQuery();
            q.setStatusFilter(null);
            Snapshot[] s = q.select();
            if (s.length == 0) {
                return;
            }
            p = p.nest(s.length);
            for (int i = 0; i < s.length; ++i) {
                this.testFlow();
                path.setSnapshotName(s[i].getName());
                if (s[i].getStatus().equals(SnapshotStatus.CREATED)) {
                    this.reportError(new DifferenceException("diff.ERR_SNAPSHOT_FAILED", new Object[]{path.getComponentName(), path.getComponentVersion().getAsString()}));
                } else {
                    path.setSnapshotID(s[i].getID());
                    this.diffSnapshot(p, path, ic, c, s[i]);
                }
                p.next();
            }
        }
        catch (RaplixException ex) {
            this.reportError(new DifferenceException("diff.ERR_IN_COMP_DIFF", (Throwable)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diffSnapshot(Progress p, MIDifferencePath path, InstalledComponent ic, Component c, Snapshot snapshot) throws InterruptedException {
        try {
            String[] oldIgnores = this.getSettings().getGlobalIgnorePaths();
            ComponentConfigManager gen = this.mConfig.getConfigGenerator().newComponentManager(ic.getVariableSettingsID());
            String[] cmpIgnores = c.getIgnorePaths(gen);
            String[] newIgnores = new String[oldIgnores.length + cmpIgnores.length];
            int j = 0;
            int i = 0;
            while (i < oldIgnores.length) {
                newIgnores[j] = oldIgnores[i];
                ++i;
                ++j;
            }
            i = 0;
            while (i < cmpIgnores.length) {
                newIgnores[j] = cmpIgnores[i];
                ++i;
                ++j;
            }
            this.getSettings().setGlobalIgnorePaths(newIgnores);
            try {
                this.mPlan.executeSnapshotSteps(snapshot, true, this, null);
                HostID[] physicalID = snapshot.getID().getVisitedHosts();
                try {
                    if (physicalID.length == 0) {
                        return;
                    }
                    p = p.nest(physicalID.length);
                    for (int i2 = 0; i2 < physicalID.length; ++i2) {
                        RoxAddress dstHostAddress;
                        this.testFlow();
                        this.reportProgress(p.getValue());
                        Host physical = physicalID[i2].getByIDQuery().select();
                        try {
                            dstHostAddress = physical.getRARoxAddress();
                        }
                        catch (HostDBException hostExp) {
                            this.reportError(hostExp);
                            this.mPlan.executeSnapshotSteps(snapshot, false, this, null);
                            this.getSettings().setGlobalIgnorePaths(oldIgnores);
                            return;
                        }
                        path.setHostName(physical.getName());
                        path.setHostID(physical.getID());
                        MIContext.MIAgentInfo info = (MIContext.MIAgentInfo)this.getAgentInfo(physical);
                        try {
                            this.mAgentOpValidator.expectOperationFor(dstHostAddress, this.getJobID());
                            MIContext.MIAgentInfo mIAgentInfo = info;
                            synchronized (mIAgentInfo) {
                                this.testFlow();
                                info.getAgentEngineMI().diffSnapshot(info.getHandle(), path);
                            }
                        }
                        finally {
                            this.mAgentOpValidator.doneWithOperationFor(dstHostAddress, this.getJobID());
                        }
                        p.next();
                    }
                }
                finally {
                    this.mPlan.executeSnapshotSteps(snapshot, false, this, null);
                }
            }
            finally {
                this.getSettings().setGlobalIgnorePaths(oldIgnores);
            }
        }
        catch (RaplixException ex) {
            this.reportError(new DifferenceException("diff.ERR_IN_SNAPSHOT_DIFF", (Throwable)ex, new Object[]{path.getComponentName(), path.getComponentVersion().getAsString()}));
        }
    }

    protected void runSelf() throws InterruptedException {
        DifferenceEngine diffEngine;
        this.mDstHostID = new HostID(this.getSettings().getDstHostID());
        try {
            this.mDstHost = DifferenceUtil.getHost(this.mDstHostID);
        }
        catch (DifferenceException ex) {
            this.reportError(ex);
            return;
        }
        try {
            this.mConfig = this.getApplication().getConfigGenSubsystem();
            this.mPlan = this.getApplication().getPlanSubsystem();
            diffEngine = this.getApplication().getDiffEngineSubsystem();
        }
        catch (UnsupportedSubsystemException ex) {
            this.reportError(new DifferenceException("diff.ERR_MISSING_SUBSYS"));
            return;
        }
        this.mAgentOpValidator = diffEngine.getAgentOpValidator();
        if (this.getSettings().getDiffScope() == 2) {
            int i;
            InstalledComponentID[] icIDs = null;
            try {
                InstalledComponent[] result = MultiInstalledComponentQuery.byHost(this.mDstHostID, TargetType.CURRENT).selectICView();
                if (result.length == 0) {
                    this.reportError(new DifferenceException("diff.ERR_NO_COMP_INSTALLED", new Object[]{this.mDstHost.getName()}));
                    return;
                }
                icIDs = new InstalledComponentID[result.length];
                for (i = 0; i < result.length; ++i) {
                    icIDs[i] = result[i].getID();
                }
            }
            catch (RaplixException ex) {
                this.reportError(new DifferenceException("diff.ERR_COMP_QUERY", (Throwable)ex));
                return;
            }
            Progress p = new Progress(icIDs.length);
            for (i = 0; i < icIDs.length; ++i) {
                this.testFlow();
                this.diffRootComponent(p, icIDs[i]);
                p.next();
            }
            return;
        }
        if (this.getSettings().getDiffScope() == 0) {
            this.diffRootComponent(new Progress(1), this.getSettings().getInstalledComponentID());
            return;
        }
    }
}

