/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.difference.DifferencePath;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotID;
import com.raplix.util.ObjectUtil;
import com.raplix.util.string.StringUtil;

public class MIDifferencePath
extends DifferencePath {
    private static final String NAME_SEPARATOR = ":";
    private static final char DISPLAY_NAME_SEPARATOR = '|';
    private String mHostName;
    private HostID mHostID;
    private String mComponentName;
    private VersionNumber mComponentVersion;
    private InstalledComponentID mComponentID;
    private String mSnapshotName;
    private SnapshotID mSnapshotID;
    private String mFilePath;
    private String mDisplayName;

    public void inflate(String str) {
        String[] parts = StringUtil.split(str, NAME_SEPARATOR, "");
        this.setHostName(parts[0]);
        this.setComponentName(parts[1]);
        this.setSnapshotName(parts[2]);
        StringBuffer buffer = new StringBuffer();
        for (int i = 3; i < parts.length; ++i) {
            if (i > 3) {
                buffer.append(NAME_SEPARATOR);
            }
            buffer.append(parts[i]);
        }
        String tail = buffer.toString();
        int index = tail.indexOf(124);
        if (index == -1) {
            this.setFilePath(tail);
        } else {
            this.setFilePath(tail.substring(0, index));
            this.setDisplayName(tail.substring(index + 1));
        }
    }

    public String deflate() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getHostName());
        buffer.append(NAME_SEPARATOR);
        buffer.append(this.getComponentName());
        buffer.append(NAME_SEPARATOR);
        buffer.append(this.getSnapshotName());
        buffer.append(NAME_SEPARATOR);
        buffer.append(this.getFilePath());
        if (!StringUtil.isEmpty(this.getDisplayName())) {
            buffer.append('|');
            buffer.append(this.getDisplayName());
        }
        return buffer.toString();
    }

    String getKey() {
        return this.getFilePath();
    }

    public DifferencePath extend(String extension) {
        MIDifferencePath copy = (MIDifferencePath)super.copy();
        copy.setFilePath(copy.getFilePath() + EXT_SEPARATOR + extension);
        return copy;
    }

    public int hashCode() {
        return ObjectUtil.hashCode(this.getHostName()) + ObjectUtil.hashCode(this.getComponentName()) + ObjectUtil.hashCode(this.getSnapshotName()) + ObjectUtil.hashCode(this.getFilePath()) + ObjectUtil.hashCode(this.getDisplayName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        MIDifferencePath p = (MIDifferencePath)o;
        if (!ObjectUtil.equals(this.getHostName(), p.getHostName())) {
            return false;
        }
        if (!ObjectUtil.equals(this.getComponentName(), p.getComponentName())) {
            return false;
        }
        if (!ObjectUtil.equals(this.getSnapshotName(), p.getSnapshotName())) {
            return false;
        }
        if (!ObjectUtil.equals(this.getFilePath(), p.getFilePath())) {
            return false;
        }
        return ObjectUtil.equals(this.getDisplayName(), p.getDisplayName());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getHostName());
        buffer.append(NAME_SEPARATOR);
        buffer.append(this.getComponentName());
        buffer.append(NAME_SEPARATOR);
        buffer.append(this.getFilePath());
        if (!StringUtil.isEmpty(this.getDisplayName())) {
            buffer.append('|');
            buffer.append(this.getDisplayName());
        }
        return buffer.toString();
    }

    public void setHostName(String name) {
        this.mHostName = name;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public void setHostID(HostID ID2) {
        this.mHostID = ID2;
    }

    public HostID getHostID() {
        return this.mHostID;
    }

    public void setComponentName(String name) {
        this.mComponentName = name;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentVersion(VersionNumber version) {
        this.mComponentVersion = version;
    }

    public VersionNumber getComponentVersion() {
        return this.mComponentVersion;
    }

    public void setComponentID(InstalledComponentID ID2) {
        this.mComponentID = ID2;
    }

    public InstalledComponentID getComponentID() {
        return this.mComponentID;
    }

    public void setSnapshotName(String name) {
        this.mSnapshotName = name;
    }

    public String getSnapshotName() {
        return this.mSnapshotName;
    }

    public void setSnapshotID(SnapshotID ID2) {
        this.mSnapshotID = ID2;
    }

    public SnapshotID getSnapshotID() {
        return this.mSnapshotID;
    }

    public void setFilePath(String filePath) {
        this.mFilePath = filePath;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public void setDisplayName(String displayName) {
        this.mDisplayName = displayName;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }
}

