/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.difference.DifferencePath;
import com.raplix.rolloutexpress.difference.DifferenceState;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.util.Util;
import com.raplix.util.logger.Logger;
import com.raplix.util.regex.REUtil;
import com.raplix.util.regex.RegEx;

public class IgnoreFilter {
    private DifferenceState mState;
    private Rule[] mRules;

    IgnoreFilter(DifferenceState state) {
        int i;
        this.mState = state;
        DifferenceSettings s = this.mState.getSettings();
        String[] jobIgnores = s.getIgnorePaths();
        String[] globalIgnores = s.getGlobalIgnorePaths();
        this.mRules = new Rule[jobIgnores.length + globalIgnores.length];
        int j = 0;
        for (i = 0; i < jobIgnores.length; ++i) {
            this.mRules[j++] = new Rule(jobIgnores[i]);
        }
        for (i = 0; i < globalIgnores.length; ++i) {
            this.mRules[j++] = new Rule(globalIgnores[i]);
        }
    }

    private String getForm(DifferencePath path) {
        String form = Util.convertToNetworkFileSeparators(path.getIgnoreForm());
        return this.mState.getIgnoreCase() ? form.toUpperCase() : form;
    }

    public boolean match(DifferencePath path) {
        String form = this.getForm(path);
        for (int i = 0; i < this.mRules.length; ++i) {
            if (!this.mRules[i].match(form)) continue;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Matched '" + path + "' to '" + this.mRules[i].getRaw() + "'", this);
            }
            return true;
        }
        return false;
    }

    public boolean matchImpreciseStart(DifferencePath path) {
        String form = this.getForm(path);
        for (int i = 0; i < this.mRules.length; ++i) {
            if (!this.mRules[i].matchImpreciseStart(form)) continue;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Matched imprecise start '" + path + "' to '" + this.mRules[i].getRaw() + "'", this);
            }
            return true;
        }
        return false;
    }

    public boolean matchImpreciseEnd(DifferencePath path) {
        String form = this.getForm(path);
        for (int i = 0; i < this.mRules.length; ++i) {
            if (!this.mRules[i].matchImpreciseEnd(form)) continue;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Matched imprecise end '" + path + "' to '" + this.mRules[i].getRaw() + "'", this);
            }
            return true;
        }
        return false;
    }

    private class Rule {
        private String mRaw;
        private RegEx mRegEx;
        private boolean mStartsImprecise;
        private boolean mEndsImprecise;

        Rule(String raw) {
            this.mRaw = raw;
            raw = Util.convertToNetworkFileSeparators(this.mRaw);
            if (IgnoreFilter.this.mState.getIgnoreCase()) {
                raw = raw.toUpperCase();
            }
            this.mRegEx = REUtil.compileWildcard(raw);
            this.mStartsImprecise = RegEx.wildcardStartsImprecise(raw);
            this.mEndsImprecise = RegEx.wildcardEndsImprecise(raw);
        }

        String getRaw() {
            return this.mRaw;
        }

        boolean match(String path) {
            return this.mRegEx.match(path);
        }

        boolean matchImpreciseStart(String path) {
            return this.mStartsImprecise && this.match(path);
        }

        boolean matchImpreciseEnd(String path) {
            return this.mEndsImprecise && this.match(path);
        }
    }
}

