/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import [Lcom.raplix.rolloutexpress.command.commandresult.FileSpec;;
import [Lcom.raplix.rolloutexpress.systemmodel.plandb.ExecStep;;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.commandresult.DirectorySpec;
import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.command.rpcinterfaces.FileOperationsInterface;
import com.raplix.rolloutexpress.difference.DifferenceEngine;
import com.raplix.rolloutexpress.difference.DifferenceException;
import com.raplix.rolloutexpress.difference.DifferenceUtil;
import com.raplix.rolloutexpress.difference.IIContext;
import com.raplix.rolloutexpress.difference.IIDifferencePath;
import com.raplix.rolloutexpress.difference.PackageInfo;
import com.raplix.rolloutexpress.difference.TeamContext;
import com.raplix.rolloutexpress.difference.TeamWorker;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.executor.PlanSubsystem;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.CallStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecNativeStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.util.DOMElementEnumeration;
import com.raplix.util.Util;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.file.XMLUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;

class IIWorker
extends TeamWorker {
    private Host mSrcHost;
    private IIContext.IIAgentInfo mDstInfo;
    private String mDstGiven;
    private FileOperationsInterface mDstFileOps;
    private PlanSubsystem mPlan;

    IIWorker(TeamContext context, DifferenceSettings settings) {
        super(context, settings);
    }

    private void createBatches(DirectorySpec srcSpec, IIDifferencePath path, Vector batches) throws InterruptedException, RaplixException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Creating batch for: '" + path + "'", this);
        }
        if (this.mDstInfo.getAgentEngineII().matchImpreciseEnd(this.mDstInfo.getHandle(), path)) {
            return;
        }
        this.testFlow();
        FileSpec[] specs = FileSpec.getDirectoryFileSpecs(this.getSettings().getFollowSymlinks(), this.getApplication(), this.mSrcHost, srcSpec.getPath());
        this.testFlow();
        File sourceDirectory = new File(FileSpec.convertPathSeparatorToLocal(srcSpec.getPath()));
        if (specs.length == 0 && !sourceDirectory.canRead()) {
            this.reportError(PackageInfo.createUnreadableDirFailure(sourceDirectory.getAbsolutePath(), null));
            return;
        }
        Vector<FileSpec> batch = new Vector<FileSpec>();
        Vector<FileSpec> subdirs = new Vector<FileSpec>();
        for (int i = 0; i < specs.length; ++i) {
            FileSpec spec = specs[i];
            if (spec.isDirectory()) {
                boolean common = true;
                try {
                    common = FileSpec.createFileSpec(this.getSettings().getFollowSymlinks(), this.mDstFileOps, this.mDstGiven + FileSpec.UNIVERSAL_FILE_SEPARATOR + path.getFilePath() + FileSpec.UNIVERSAL_FILE_SEPARATOR + spec.extractName()).isDirectory();
                }
                catch (RaplixException ex) {
                    common = false;
                }
                if (common) {
                    subdirs.addElement(spec);
                }
            }
            batch.addElement(spec);
            this.testFlow();
        }
        batches.addElement(new Batch(path, (FileSpec[])CollectionUtil.mapClass(batch, FileSpec;.class)));
        if (this.getSettings().getIncludeSubdirectories()) {
            Enumeration e = subdirs.elements();
            while (e.hasMoreElements()) {
                DirectorySpec srcDir = (DirectorySpec)e.nextElement();
                this.createBatches(srcDir, (IIDifferencePath)this.mDstInfo.getAgentEngineII().extend(path, srcDir.extractName()), batches);
                this.testFlow();
            }
        }
    }

    private void runMiniPlan(Vector steps, HostID hID, String defaultDir) throws InterruptedException {
        try {
            this.mPlan.execNonPlanSteps((ExecStep[])CollectionUtil.mapClass(steps, ExecStep;.class), hID, this, defaultDir, SystemPluginConstants.getInstance().MINIPLAN_FOLDER_ID);
        }
        catch (RaplixException ex) {
            this.reportError(new DifferenceException("diff.ERR_MINIPLAN_EXECUTION", (Throwable)ex));
        }
    }

    private Vector getMiniPlan(String miniPlan) throws SystemModelParseException {
        Vector<ExecNativeStep> steps = new Vector<ExecNativeStep>();
        if (StringUtil.isEmpty(miniPlan)) {
            return steps;
        }
        DOMElementEnumeration e = new DOMElementEnumeration(XMLUtil.parse(miniPlan).getFirstChild());
        while (e.hasMoreElements()) {
            Element element = e.nextElement();
            String name = element.getTagName();
            ExecStep step = null;
            if (name.equals("execNative")) {
                step = new ExecNativeStep(element);
            } else if (name.equals("call")) {
                step = new CallStep(element);
            } else {
                if (!Logger.isDebugEnabled(this)) continue;
                Logger.debug("Ignoring the step: " + name, this);
                continue;
            }
            steps.addElement((ExecNativeStep)step);
        }
        return steps;
    }

    private String getImpliedDirectory(String raw, FileSpec spec) {
        if (spec.isDirectory()) {
            return raw;
        }
        return new File(raw).getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void runSelf() throws InterruptedException {
        DifferenceEngine diffEngine = null;
        try {
            this.mPlan = this.getApplication().getPlanSubsystem();
            diffEngine = this.getApplication().getDiffEngineSubsystem();
        }
        catch (UnsupportedSubsystemException ex) {
            this.reportError(new DifferenceException("diff.ERR_MISSING_SUBSYS"));
            return;
        }
        DifferenceEngine.GetRequestValidator validator = diffEngine.getValidator();
        DifferenceEngine.AgentOperationValidator agentOpValidator = diffEngine.getAgentOpValidator();
        HostID srcID = new HostID(this.getSettings().getSrcHostID());
        HostID dstID = new HostID(this.getSettings().getDstHostID());
        try {
            this.mSrcHost = DifferenceUtil.getHost(srcID);
            Host dstHost = DifferenceUtil.getHost(dstID);
            this.mDstInfo = (IIContext.IIAgentInfo)this.getAgentInfo(dstHost);
            RoxAddress srcAddress = this.mSrcHost.getRARoxAddress();
            String srcGiven = Util.trimTrailingSlash(this.getSettings().getSrcDir());
            FileOperationsInterface srcFileOps = (FileOperationsInterface)this.getApplication().getRPCInterface(srcAddress, FileOperationsInterface.class);
            FileSpec srcSpec = FileSpec.createFileSpec(this.getSettings().getFollowSymlinks(), srcFileOps, srcGiven);
            RoxAddress dstAddress = dstHost.getRARoxAddress();
            this.mDstFileOps = (FileOperationsInterface)this.getApplication().getRPCInterface(dstAddress, FileOperationsInterface.class);
            this.mDstGiven = Util.trimTrailingSlash(this.getSettings().getDstDir());
            FileSpec dstSpec = FileSpec.createFileSpec(this.getSettings().getFollowSymlinks(), this.mDstFileOps, this.mDstGiven);
            String srcDir = this.getImpliedDirectory(srcGiven, srcSpec);
            String dstDir = this.getImpliedDirectory(this.mDstGiven, dstSpec);
            Vector srcPrepare = null;
            Vector dstPrepare = null;
            Vector srcCleanup = null;
            Vector dstCleanup = null;
            if (this.getSettings().getUseMiniPlans()) {
                srcPrepare = this.getMiniPlan(this.getSettings().getSrcPrepare());
                dstPrepare = this.getSettings().getDstUseSrcP() ? srcPrepare : this.getMiniPlan(this.getSettings().getDstPrepare());
                srcCleanup = this.getMiniPlan(this.getSettings().getSrcCleanup());
                dstCleanup = this.getSettings().getDstUseSrcC() ? srcCleanup : this.getMiniPlan(this.getSettings().getDstCleanup());
                this.runMiniPlan(srcPrepare, srcID, srcDir);
                this.reportProgress(5.0);
                this.runMiniPlan(dstPrepare, dstID, dstDir);
            }
            this.reportProgress(10.0);
            try {
                IIContext.IIAgentInfo srcInfo = (IIContext.IIAgentInfo)this.getAgentInfo(this.mSrcHost);
                srcSpec = FileSpec.createFileSpec(this.getSettings().getFollowSymlinks(), srcFileOps, srcGiven);
                dstSpec = FileSpec.createFileSpec(this.getSettings().getFollowSymlinks(), this.mDstFileOps, this.mDstGiven);
                this.testFlow();
                if (srcSpec.isDirectory() && dstSpec.isDirectory()) {
                    Vector batches = new Vector();
                    this.createBatches((DirectorySpec)srcSpec, new IIDifferencePath(), batches);
                    int i = 0;
                    Enumeration e = batches.elements();
                    while (e.hasMoreElements()) {
                        Object var26_27;
                        this.testFlow();
                        Batch b = (Batch)e.nextElement();
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("Comparing: " + b.getPath(), this);
                        }
                        try {
                            try {
                                validator.expectGetRequestsFor(b.getSpecs(), dstAddress, srcAddress, this.getJobID());
                                agentOpValidator.expectOperationFor(dstAddress, this.getJobID());
                                this.mDstInfo.getAgentEngineII().diffBatch(this.mDstInfo.getHandle(), b.getPath(), b.getSpecs());
                            }
                            catch (RaplixException ex) {
                                this.reportError(new DifferenceException("diff.ERR_SEND_FILE_BATCH", (Throwable)ex));
                                var26_27 = null;
                                validator.doneWithGetRequestsFor(b.getSpecs(), dstAddress, srcAddress, this.getJobID());
                                agentOpValidator.doneWithOperationFor(dstAddress, this.getJobID());
                            }
                            var26_27 = null;
                            validator.doneWithGetRequestsFor(b.getSpecs(), dstAddress, srcAddress, this.getJobID());
                            agentOpValidator.doneWithOperationFor(dstAddress, this.getJobID());
                        }
                        catch (Throwable throwable) {
                            var26_27 = null;
                            validator.doneWithGetRequestsFor(b.getSpecs(), dstAddress, srcAddress, this.getJobID());
                            agentOpValidator.doneWithOperationFor(dstAddress, this.getJobID());
                            throw throwable;
                        }
                        this.reportProgress(80.0 * (double)(++i) / (double)batches.size() + 10.0);
                    }
                } else {
                    try {
                        validator.expectGetRequestsFor(new FileSpec[]{srcSpec}, dstAddress, srcAddress, this.getJobID());
                        agentOpValidator.expectOperationFor(dstAddress, this.getJobID());
                        this.mDstInfo.getAgentEngineII().diffSingleFile(this.mDstInfo.getHandle(), srcSpec, dstSpec, new IIDifferencePath());
                        Object var28_29 = null;
                    }
                    catch (Throwable throwable) {
                        Object var28_30 = null;
                        validator.doneWithGetRequestsFor(new FileSpec[]{dstSpec}, dstAddress, srcAddress, this.getJobID());
                        agentOpValidator.doneWithOperationFor(dstAddress, this.getJobID());
                        throw throwable;
                    }
                    validator.doneWithGetRequestsFor(new FileSpec[]{dstSpec}, dstAddress, srcAddress, this.getJobID());
                    agentOpValidator.doneWithOperationFor(dstAddress, this.getJobID());
                    {
                    }
                }
                Object var30_32 = null;
                if (!this.getSettings().getUseMiniPlans()) return;
            }
            catch (Throwable throwable) {
                Object var30_33 = null;
                if (!this.getSettings().getUseMiniPlans()) throw throwable;
                this.runMiniPlan(srcCleanup, srcID, srcDir);
                this.reportProgress(95.0);
                this.runMiniPlan(dstCleanup, dstID, dstDir);
                throw throwable;
            }
            this.runMiniPlan(srcCleanup, srcID, srcDir);
            this.reportProgress(95.0);
            this.runMiniPlan(dstCleanup, dstID, dstDir);
            return;
        }
        catch (RaplixException ex) {
            this.reportError(new DifferenceException("diff.ERR_SETUP", (Throwable)ex));
        }
    }

    private static class Batch {
        private IIDifferencePath mPath;
        private FileSpec[] mSpecs;

        Batch(IIDifferencePath path, FileSpec[] specs) {
            this.mPath = path;
            this.mSpecs = specs;
        }

        IIDifferencePath getPath() {
            return this.mPath;
        }

        FileSpec[] getSpecs() {
            return this.mSpecs;
        }
    }
}

