/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.difference.DifferencePath;
import com.raplix.rolloutexpress.difference.DifferenceState;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.util.Util;
import com.raplix.util.logger.Logger;
import com.raplix.util.regex.REUtil;
import com.raplix.util.regex.RegEx;

public class FileTyper {
    public static final int TYPE_RAW = 1;
    public static final int TYPE_TEXT = 2;
    public static final int TYPE_ORA = 3;
    public static final int TYPE_XML = 4;
    public static final int TYPE_APACHE = 5;
    public static final int TYPE_CONF = 6;
    public static final int TYPE_PROPS = 7;
    public static final int TYPE_ZIP = 8;
    private DifferenceState mState;
    private Type[] mTypes;

    FileTyper(DifferenceState state) {
        this.mState = state;
        DifferenceSettings s = this.mState.getSettings();
        this.mTypes = new Type[]{new Type(s.getTextPaths(), 2), new Type(s.getOraPaths(), 3), new Type(s.getXMLPaths(), 4), new Type(s.getApachePaths(), 5), new Type(s.getConfPaths(), 6), new Type(s.getPropertiesPaths(), 7), new Type(s.getZipPaths(), 8)};
    }

    public int getType(DifferencePath path) {
        String form = Util.convertToNetworkFileSeparators(path.getTyperForm());
        if (this.mState.getIgnoreCase()) {
            form = form.toUpperCase();
        }
        int maxMatch = -1;
        int type = 1;
        for (int i = 0; i < this.mTypes.length; ++i) {
            int match = this.mTypes[i].match(form);
            if (match <= maxMatch) continue;
            type = this.mTypes[i].getType();
            maxMatch = match;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Typed '" + path + "' as " + type, this);
        }
        return type;
    }

    private class Type {
        private TypeRule[] mRules;
        private int mType;

        Type(String[] rules, int type) {
            this.mRules = new TypeRule[rules.length];
            for (int i = 0; i < rules.length; ++i) {
                this.mRules[i] = new TypeRule(rules[i]);
            }
            this.mType = type;
        }

        int match(String path) {
            int len = -1;
            for (int i = 0; i < this.mRules.length; ++i) {
                int newLen;
                if (!this.mRules[i].match(path) || (newLen = this.mRules[i].getLength()) <= len) continue;
                len = newLen;
            }
            return len;
        }

        int getType() {
            return this.mType;
        }
    }

    private class TypeRule {
        private int mLength;
        private RegEx mRegEx;

        TypeRule(String raw) {
            this.mLength = raw.length();
            raw = Util.convertToNetworkFileSeparators(raw);
            if (FileTyper.this.mState.getIgnoreCase()) {
                raw = raw.toUpperCase();
            }
            this.mRegEx = REUtil.compileWildcard(raw);
        }

        boolean match(String path) {
            return this.mRegEx.match(path);
        }

        int getLength() {
            return this.mLength;
        }
    }
}

