/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.DifferenceException;
import com.raplix.rolloutexpress.difference.DifferenceInfoException;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.DifferencePath;
import com.raplix.rolloutexpress.difference.DifferencePermission;
import com.raplix.rolloutexpress.difference.DifferenceServerInterface;
import com.raplix.rolloutexpress.difference.PackageInfo;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBAgentInterface;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsID;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.ROXDifferenceEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceFailedEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.executor.HostsUnpreparedException;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;

public final class DifferenceUtil {
    private DifferenceUtil() {
    }

    private static void notify(Application app, DifferenceJobID jobID, ROXEvent e) throws DifferenceException {
        try {
            ((DifferenceServerInterface)app.getNetSubsystem().getRPC().getLocalService(app.getNetSubsystem().getMSAddress(), DifferenceServerInterface.class)).notify(jobID, e);
        }
        catch (Exception ex) {
            throw PackageInfo.createReportEvent(e, ex);
        }
    }

    private static void notifySynchronous(Application app, ROXEvent e) throws DifferenceException {
        boolean notified = false;
        try {
            notified = ((NotificationRPCInterface)app.getNetSubsystem().getRPC().getLocalService(app.getNetSubsystem().getMSAddress(), NotificationRPCInterface.class)).notifyAndWait(e, true);
        }
        catch (Exception ex) {
            throw PackageInfo.createReportEvent(e, ex);
        }
        if (!notified) {
            throw PackageInfo.createReportEvent(e);
        }
    }

    public static Host getHost(HostID hID) throws DifferenceException {
        try {
            return hID.getByIDQuery().select();
        }
        catch (Exception ex) {
            throw PackageInfo.createHostDB(ex);
        }
    }

    public static void checkPermissions(DifferenceSettings settings) {
        String ID2 = settings.getSrcHostID();
        if (!StringUtil.isEmpty(ID2)) {
            AccessController.checkPermission(new DifferencePermission(new HostID(ID2)));
        }
        if (!StringUtil.isEmpty(ID2 = settings.getDstHostID())) {
            AccessController.checkPermission(new DifferencePermission(new HostID(ID2)));
        }
        if (!StringUtil.isEmpty(ID2 = settings.getDstHostSetID())) {
            AccessController.checkPermission(new DifferencePermission(new HostSetID(ID2)));
        }
    }

    public static void checkHostsPrepped(DifferenceSettings settings) throws DifferenceException {
        String ID2 = settings.getSrcHostID();
        if (!StringUtil.isEmpty(ID2)) {
            DifferenceUtil.checkHostPrepared(new HostID(ID2));
        }
        if (!StringUtil.isEmpty(ID2 = settings.getDstHostID())) {
            DifferenceUtil.checkHostPrepared(new HostID(ID2));
        }
        if (settings.getDiffScope() == 3 && !StringUtil.isEmpty(settings.getDstHostSetID())) {
            SummaryHost[] hosts;
            try {
                hosts = new HostSetID(settings.getDstHostSetID()).getAllHostsQuery().selectSummaryView();
            }
            catch (RPCException e) {
                throw new DifferenceException(e);
            }
            catch (PersistenceManagerException e) {
                throw new DifferenceException(e);
            }
            for (int i = 0; i < hosts.length; ++i) {
                DifferenceUtil.checkHostPrepared(hosts[i].getID());
            }
        }
    }

    public static void checkHostPrepared(HostID inHostID) throws DifferenceException {
        Host thePhysicalHost = null;
        try {
            thePhysicalHost = inHostID.getPhysicalHost().getID().getByIDQuery().select();
        }
        catch (RPCException e) {
            throw new DifferenceException(e);
        }
        catch (PersistenceManagerException e) {
            throw new DifferenceException(e);
        }
        final HostID thePhysicalID = thePhysicalHost.getID();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PersistenceManagerException, RPCException {
                    thePhysicalID.refreshMachineInfo();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new DifferenceException(pae.getException());
        }
        try {
            if (thePhysicalHost.isPrepared()) {
                return;
            }
        }
        catch (RPCException e) {
            throw new DifferenceException(e);
        }
        catch (PersistenceManagerException e) {
            throw new DifferenceException(e);
        }
        Vector<HostID> set = new Vector<HostID>(1);
        set.add(thePhysicalID);
        throw new DifferenceException(new HostsUnpreparedException(new HostIDSet(set)));
    }

    public static void reportDifference(Application app, DifferencePath path, Difference d, DifferenceJobID jobID) {
        if (Logger.isDebugEnabled(DifferenceUtil.class)) {
            Logger.debug("Difference at '" + path + "': " + d, DifferenceUtil.class);
        }
        try {
            DifferenceUtil.notify(app, jobID, ROXDifferenceEvent.found(jobID, ((DifferenceDBAgentInterface)app.getRPCInterface(app.getNetSubsystem().getMSAddress(), DifferenceDBAgentInterface.class)).saveDifference(d, jobID), path.deflate(), d.getType()));
        }
        catch (Exception ex) {
            DifferenceUtil.reportError(app, jobID, ex);
        }
    }

    public static void reportProgress(Application app, DifferenceJobID jobID, int p) {
        double progress = new Double(p) / 100.0;
        if (Logger.isDebugEnabled(DifferenceUtil.class)) {
            Logger.debug("Difference job is " + p + "% complete, normalized to " + progress, DifferenceUtil.class);
        }
        try {
            DifferenceUtil.notify(app, null, ROXDifferenceEvent.progress(jobID, progress));
        }
        catch (Exception ex) {
            DifferenceUtil.reportError(app, false, jobID, ex);
        }
    }

    public static void reportJobStarted(Application app, DifferenceJobID jobID, DifferenceSettingsID sID) {
        try {
            DifferenceUtil.notify(app, null, ROXDifferenceEvent.start(jobID, sID));
        }
        catch (Exception ex) {
            DifferenceUtil.reportError(app, false, jobID, ex);
        }
    }

    public static void reportJobAbortRequested(Application app, DifferenceJobID jobID) {
        try {
            DifferenceUtil.notify(app, null, ROXDifferenceEvent.abortRequested(jobID));
        }
        catch (Exception ex) {
            DifferenceUtil.reportError(app, false, jobID, ex);
        }
    }

    public static void reportJobAborted(Application app, DifferenceJobID jobID) {
        try {
            DifferenceUtil.notify(app, null, ROXDifferenceEvent.abort(jobID));
        }
        catch (Exception ex) {
            DifferenceUtil.reportError(app, false, jobID, ex);
        }
    }

    public static void reportJobCompleted(Application app, DifferenceJobID jobID, DifferenceSettingsID sID) {
        try {
            DifferenceUtil.notify(app, null, ROXDifferenceEvent.complete(jobID, sID));
        }
        catch (Exception ex) {
            DifferenceUtil.reportError(app, false, jobID, ex);
        }
    }

    public static void reportJobFailed(Application app, DifferenceJobID jobID, CommandException ex) {
        try {
            DifferenceUtil.notify(app, null, ROXDifferenceEvent.jobFailed(jobID, ex));
        }
        catch (Exception ex2) {
            DifferenceUtil.reportError(app, false, jobID, ex2);
        }
    }

    public static void reportError(Application app, boolean filter, DifferenceJobID jobID, Exception ex) {
        block4: {
            DifferenceException dEx = ex instanceof DifferenceException ? (DifferenceException)ex : PackageInfo.createReport(ex);
            if (Logger.isErrorEnabled(DifferenceUtil.class)) {
                Logger.error(ROXMessageManager.messageAsString("diff.REPORTING_FAILURE", new Object[]{dEx.getClass()}), dEx, DifferenceUtil.class);
            }
            try {
                ROXDifferenceFailedEvent e = ROXDifferenceEvent.failed(jobID, dEx);
                if (dEx instanceof DifferenceInfoException) {
                    e.setSeverity(2);
                }
                DifferenceUtil.notify(app, filter ? jobID : null, e);
            }
            catch (Exception ex2) {
                if (!Logger.isErrorEnabled(DifferenceUtil.class)) break block4;
                Logger.error(ROXMessageManager.messageAsString("diff.UNREPORTABLE_FAILURE"), ex2, DifferenceUtil.class);
            }
        }
    }

    public static void reportError(Application app, DifferenceJobID jobID, Exception ex) {
        DifferenceUtil.reportError(app, true, jobID, ex);
    }

    public static void reportJobFailedSynchronous(Application app, DifferenceJobID jobID, CommandException ex) {
        try {
            DifferenceUtil.notifySynchronous(app, ROXDifferenceEvent.jobFailed(jobID, ex));
        }
        catch (Exception ex2) {
            DifferenceUtil.reportError(app, jobID, ex2);
        }
    }

    public static void reportJobCompletedSynchronous(Application app, DifferenceJobID jobID, DifferenceSettingsID sID) {
        try {
            DifferenceUtil.notifySynchronous(app, ROXDifferenceEvent.complete(jobID, sID));
        }
        catch (Exception ex) {
            DifferenceUtil.reportError(app, jobID, ex);
        }
    }
}

