/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.Agent;
import com.raplix.rolloutexpress.difference.AccumulatorSink;
import com.raplix.rolloutexpress.difference.Comparator;
import com.raplix.rolloutexpress.difference.DifferenceException;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.FileTyper;
import com.raplix.rolloutexpress.difference.IgnoreFilter;
import com.raplix.rolloutexpress.difference.NotificationSink;
import com.raplix.rolloutexpress.difference.Reporter;
import com.raplix.rolloutexpress.difference.Sink;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import java.util.HashSet;

public class DifferenceState {
    private Agent mAgent;
    private DifferenceSettings mSettings;
    private DifferenceJobID mJobID;
    private boolean mIgnoreCase;
    private boolean mExtendDst;
    private IgnoreFilter mFilter;
    private FileTyper mTyper;
    private Comparator mComparator;
    private Sink mSink;
    private Sink mReporter;
    private HashSet mFiles = new HashSet();

    public DifferenceState(Agent agent, DifferenceSettings settings, DifferenceJobID jobID, boolean ignoreCase, boolean extendDst, boolean useNotification) throws DifferenceException {
        this.mAgent = agent;
        this.mSettings = settings;
        this.mJobID = jobID;
        this.mIgnoreCase = ignoreCase;
        this.mExtendDst = extendDst;
        this.mFilter = new IgnoreFilter(this);
        this.mTyper = new FileTyper(this);
        this.mComparator = new Comparator(this);
        this.mSink = useNotification ? new NotificationSink(this) : new AccumulatorSink();
        this.mReporter = new Reporter(this);
    }

    public Agent getAgent() {
        return this.mAgent;
    }

    public DifferenceSettings getSettings() {
        return this.mSettings;
    }

    public DifferenceJobID getJobID() {
        return this.mJobID;
    }

    public boolean getIgnoreCase() {
        return this.mIgnoreCase;
    }

    public boolean getExtendDst() {
        return this.mExtendDst;
    }

    public IgnoreFilter getFilter() {
        return this.mFilter;
    }

    public FileTyper getTyper() {
        return this.mTyper;
    }

    public Comparator getComparator() {
        return this.mComparator;
    }

    public Sink getRawSink() {
        return this.mSink;
    }

    public Sink getReporter() {
        return this.mReporter;
    }

    public boolean isProcessed(String name) {
        return this.mFiles.contains(name);
    }

    public void setProcessed(String name) {
        this.mFiles.add(name);
    }
}

