/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import [Ljava.lang.String;;
import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.CannotEnforceException;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.InconsistencyFixException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.SubsystemID;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.difference.DifferenceAgentEngine;
import com.raplix.rolloutexpress.difference.DifferenceException;
import com.raplix.rolloutexpress.difference.DifferenceInterface;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.DifferenceMessages;
import com.raplix.rolloutexpress.difference.DifferencePermission;
import com.raplix.rolloutexpress.difference.DifferenceServerInterface;
import com.raplix.rolloutexpress.difference.DifferenceUtil;
import com.raplix.rolloutexpress.difference.IIContext;
import com.raplix.rolloutexpress.difference.IIWorker;
import com.raplix.rolloutexpress.difference.MIContext;
import com.raplix.rolloutexpress.difference.MIWorker;
import com.raplix.rolloutexpress.difference.MMContext;
import com.raplix.rolloutexpress.difference.MMWorker;
import com.raplix.rolloutexpress.difference.RemoteAgentOperationListener;
import com.raplix.rolloutexpress.difference.SampleWorker;
import com.raplix.rolloutexpress.difference.TeamContext;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBException;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.difference.differencedb.SingleDifferenceJobQuery;
import com.raplix.rolloutexpress.event.ROXDifferenceEvent;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.query.bean.RunningDiffBean;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.AbsoluteFileSpec;
import com.raplix.rolloutexpress.resource.GetRemoteFileListener;
import com.raplix.rolloutexpress.resource.UnexpectedGetRequest;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.rwlock.LockContext;
import com.raplix.util.rwlock.RWLock;
import com.raplix.util.string.StringUtil;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.FIFOQueue;
import com.raplix.util.threads.ResourceID;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class DifferenceEngine
extends Subsystem
implements DifferenceServerInterface,
DifferenceInterface,
DifferenceMessages {
    public static final SubsystemID CLASS_SUBSYSTEM_ID = new SubsystemID(DifferenceAgentEngine.class.getName());
    private static final String CFG_PREFIX = "diff.";
    private static final String CFG_VAR_THROTTLE = "maxThreads";
    private static final String CFG_VAR_THROTTLE_VALUE = "10";
    private static final String CFG_VAR_PAT_IGNORE = "ignorePatterns";
    private static final String CFG_VAR_PAT_IGNORE_VALUE = "*~,*.class,*.log,*.lck";
    private static final String CFG_VAR_PAT_TEXT = "textPatterns";
    private static final String CFG_VAR_PAT_TEXT_VALUE = "*.txt,*.htm,*.html,*.sh,*.cmd,*.policy,*.jsp,*.h,*.c,*.java";
    private static final String CFG_VAR_PAT_ORA = "oraPatterns";
    private static final String CFG_VAR_PAT_ORA_VALUE = "*.ora";
    private static final String CFG_VAR_PAT_XML = "xmlPatterns";
    private static final String CFG_VAR_PAT_XML_VALUE = "*.xml,*.xsl,*.xslt";
    private static final String CFG_VAR_XML_ORDERED = "xmlOrdered";
    private static final String CFG_VAR_XML_ORDERED_VALUE = "*.xsl:*,*.xslt:*";
    private static final String CFG_VAR_PAT_APACHE = "apachePatterns";
    private static final String CFG_VAR_PAT_APACHE_VALUE = "*httpd.conf";
    private static final String CFG_VAR_PAT_CONF = "confPatterns";
    private static final String CFG_VAR_PAT_CONF_VALUE = "*.conf";
    private static final String CFG_VAR_PAT_PROPERTIES = "propertiesPatterns";
    private static final String CFG_VAR_PAT_PROPERTIES_VALUE = "*.properties";
    private static final String CFG_VAR_PAT_ZIP = "zipPatterns";
    private static final String CFG_VAR_PAT_ZIP_VALUE = "*.zip,*.jar,*.war,*.ear";
    private Context mContext;
    private ResourceID mThrottle;
    private boolean mSuppressFiltering;
    private GetRequestValidator mValidator;
    private AgentOperationValidator mAgentOpValidator;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$difference$DifferenceEngine;

    private DifferenceEngine() {
    }

    public DifferenceEngine(Application app) throws ConfigurationException {
        super(app, CLASS_SUBSYSTEM_ID);
        RPCManager rpc;
        try {
            rpc = app.getNetSubsystem().getRPC();
            rpc.registerService(DifferenceServerInterface.class, this);
        }
        catch (RPCException ex) {
            throw new ConfigurationException("diff.ERR_REGISTER_RPC_MS", (Throwable)ex);
        }
        try {
            this.getApplication().getHostDBSubsystem().addHostSetUpdateListener(this.getApplication().getUserDBSubsystem().getHostPermissionManager(DifferencePermission.class));
        }
        catch (UnsupportedSubsystemException usex) {
        }
        catch (Exception e) {
            throw new ConfigurationException("unable to register the difference engine with the host permission manager");
        }
        this.mValidator = new GetRequestValidator(rpc);
        this.mAgentOpValidator = new AgentOperationValidator(rpc);
        try {
            this.getApplication().getResourceSubsystem().setGetRequestListener(this.mValidator);
            this.getApplication().getDiffDBSubsystem().setAgentOpListener(this.mAgentOpValidator);
        }
        catch (UnsupportedSubsystemException e) {
            throw new ConfigurationException("diff.ERR_REGISTER_GET_REQUEST_VALIDATOR");
        }
        this.mContext = new Context("DifferenceEngine");
        this.mThrottle = this.mContext.register(new FIFOQueue(this.getConfigurationAsInt(CFG_VAR_THROTTLE)));
    }

    private String[] getList(String name) throws ConfigurationException {
        String list = this.getConfigurationAsString(name);
        if (StringUtil.isEmpty(list)) {
            return new String[0];
        }
        Vector<String> diffList = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(list, ",");
        while (tokenizer.hasMoreTokens()) {
            diffList.addElement(tokenizer.nextToken().trim());
        }
        return (String[])CollectionUtil.mapClass(diffList, String;.class);
    }

    public String getSubsystemName() {
        return ROXMessageManager.messageAsString("diff.SUBSYSTEM_NAME_MS");
    }

    protected String getConfigurationPropertyPrefix() {
        return CFG_PREFIX;
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        if (this.getApplication() == null) {
            return null;
        }
        return new DefaultConfiguration[]{new DefaultConfiguration(CFG_VAR_THROTTLE, CFG_VAR_THROTTLE_VALUE, "Maximum number of concurrent comparison threads"), new DefaultConfiguration(CFG_VAR_PAT_IGNORE, CFG_VAR_PAT_IGNORE_VALUE, "Pattern for files to ignore during comparisons"), new DefaultConfiguration(CFG_VAR_PAT_TEXT, CFG_VAR_PAT_TEXT_VALUE, "Pattern for text files"), new DefaultConfiguration(CFG_VAR_PAT_ORA, CFG_VAR_PAT_ORA_VALUE, "Pattern for Oracle configuration files"), new DefaultConfiguration(CFG_VAR_PAT_XML, CFG_VAR_PAT_XML_VALUE, "Pattern for XML files"), new DefaultConfiguration(CFG_VAR_XML_ORDERED, CFG_VAR_XML_ORDERED_VALUE, "Name pattern for XML elements with ordered children"), new DefaultConfiguration(CFG_VAR_PAT_APACHE, CFG_VAR_PAT_APACHE_VALUE, "Pattern for Apache configuration files"), new DefaultConfiguration(CFG_VAR_PAT_CONF, CFG_VAR_PAT_CONF_VALUE, "Pattern for UNIX configuration files"), new DefaultConfiguration(CFG_VAR_PAT_PROPERTIES, CFG_VAR_PAT_PROPERTIES_VALUE, "Pattern for Java properties files"), new DefaultConfiguration(CFG_VAR_PAT_ZIP, CFG_VAR_PAT_ZIP_VALUE, "Pattern for Zip archive files")};
    }

    public void notify(DifferenceJobID jobID, ROXEvent event) throws RPCException, DifferenceException, DifferenceDBException {
        RPCManager rpcManager = this.getApplication().getNetSubsystem().getRPC();
        if (rpcManager.getInvokerTransportInfo().isClientSide()) {
            try {
                this.getApplication().getDiffDBSubsystem().getAgentOpListener().operationInvoked(rpcManager.getInvokerAddress(), jobID == null ? ((ROXDifferenceEvent)event).getDifferenceJobID() : jobID);
            }
            catch (UnsupportedSubsystemException usex) {
                Logger.error("Unable to access DifferenceDB Subsystem.", this);
                return;
            }
        }
        if (this.mSuppressFiltering || jobID == null) {
            this.notify(event);
            return;
        }
        TeamContext context = (TeamContext)this.getRunningTask(jobID.toString());
        if (context == null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Rejecting event '" + event + "'", this);
            }
            return;
        }
        context.notify(event);
    }

    public void enforceConsistency() throws CannotEnforceException {
        try {
            Vector runningDiffs = this.getApplication().getNotificationManager().queryRunningDiffs(0);
            RunningDiffBean bean = null;
            Enumeration enu = runningDiffs.elements();
            while (enu.hasMoreElements()) {
                bean = (RunningDiffBean)enu.nextElement();
                if (Logger.isInfoEnabled(this)) {
                    Logger.info(ROXMessageManager.messageAsString("diff.POSTING_EVENTS", new Object[]{bean.getDifferenceJobID()}), this);
                }
                DifferenceUtil.reportJobFailedSynchronous(this.getApplication(), bean.getDifferenceJobID(), new InconsistencyFixException());
                DifferenceUtil.reportJobCompletedSynchronous(this.getApplication(), bean.getDifferenceJobID(), bean.getDifferenceSettingsID());
            }
        }
        catch (Exception e) {
            throw new CannotEnforceException(new ROXMessage("diff.ERR_ENFORCING_CONSISTENCY"), (Throwable)e);
        }
    }

    public String[] getGlobalIgnorePaths() throws RPCException, DifferenceException {
        Object[] result;
        try {
            result = this.getList(CFG_VAR_PAT_IGNORE);
        }
        catch (ConfigurationException ex) {
            throw new DifferenceException("diff.ERR_READ_IGNORE_CONFIG", (Throwable)ex);
        }
        Arrays.sort(result);
        return result;
    }

    public DifferenceJobID diff(DifferenceSettings settings) throws RPCException, DifferenceException {
        return this.diff(settings, false);
    }

    public boolean halt(DifferenceJobID jobID) throws RPCException {
        return this.stopSubsystemTask(jobID.toString());
    }

    public DifferenceJobID diff(final DifferenceSettings settings, final boolean testWorker) throws RPCException, DifferenceException {
        RWLock lock = PersistenceManager.getInstance().getSystemLockObject();
        LockContext lockContext = new LockContext(){

            public Object execute() throws RPCException, DifferenceException {
                return DifferenceEngine.this.lockDiff(settings, testWorker);
            }
        };
        try {
            String inMsg = ROXMessageManager.messageAsString("diff.LOCK_MESSAGE", new Object[]{settings.getName(), settings.getDescription()});
            DifferenceJobID theResult = (DifferenceJobID)lock.readLock(inMsg, lockContext);
            long theBestEffortTimeout = 300000L;
            SingleDifferenceJobQuery theQuery = theResult.getByIDQuery();
            long theStart = System.currentTimeMillis();
            while (!theQuery.selectExists()) {
                if (System.currentTimeMillis() - theStart > 300000L) {
                    if (!Logger.isWarnEnabled(this)) break;
                    Logger.warn(ROXMessageManager.messageAsString("diff.NO_BACKEND_PROPAGATION", new Object[]{theResult}), this);
                    break;
                }
                Thread.sleep(125L);
            }
            return theResult;
        }
        catch (DifferenceException de) {
            throw de;
        }
        catch (RPCException re) {
            throw re;
        }
        catch (AccessControlException ace) {
            throw ace;
        }
        catch (Exception ex) {
            throw new DifferenceException(ex);
        }
    }

    private DifferenceJobID lockDiff(DifferenceSettings settings, boolean testWorker) throws RPCException, DifferenceException {
        block24: {
            if (this.isShuttingDown()) {
                throw new DifferenceException("diff.SHUTDOWN_IN_PROGRESS");
            }
            DifferenceUtil.checkPermissions(settings);
            DifferenceUtil.checkHostsPrepped(settings);
            try {
                settings.assertValid();
            }
            catch (DifferenceDBException ex) {
                throw new DifferenceException("diff.INVALID_DIFF_SETTINGS", (Throwable)ex);
            }
            try {
                settings.setGlobalIgnorePaths(this.getList(CFG_VAR_PAT_IGNORE));
                settings.setTextPaths(this.getList(CFG_VAR_PAT_TEXT));
                settings.setOraPaths(this.getList(CFG_VAR_PAT_ORA));
                settings.setXMLPaths(this.getList(CFG_VAR_PAT_XML));
                settings.setXMLOrderedNames(this.getList(CFG_VAR_XML_ORDERED));
                settings.setApachePaths(this.getList(CFG_VAR_PAT_APACHE));
                settings.setConfPaths(this.getList(CFG_VAR_PAT_CONF));
                settings.setPropertiesPaths(this.getList(CFG_VAR_PAT_PROPERTIES));
                settings.setZipPaths(this.getList(CFG_VAR_PAT_ZIP));
            }
            catch (ConfigurationException ex) {
                if (!Logger.isErrorEnabled(this)) break block24;
                Logger.error(ROXMessageManager.messageAsString("diff.CONFIG_EXCEPTION"), ex, this);
            }
        }
        DifferenceJobID jobID = DifferenceJobID.generateDifferenceJobID();
        TeamContext context = null;
        if (testWorker) {
            context = new TeamContext(this.mContext, this, settings, jobID);
            context.addWorker(new SampleWorker(context, settings));
        } else {
            switch (settings.getDiffStyle()) {
                case 0: {
                    context = new MMContext(this.mContext, this, settings, jobID);
                    context.addWorker(new MMWorker(context, settings));
                    break;
                }
                case 1: {
                    context = new MIContext(this.mContext, this, settings, jobID);
                    if (settings.getDiffScope() == 3) {
                        SummaryHost[] hosts;
                        try {
                            hosts = new HostSetID(settings.getDstHostSetID()).getAllHostsQuery().selectSummaryView();
                        }
                        catch (PersistenceManagerException ex) {
                            throw new DifferenceException("diff.ERR_HOSTS_MODEL_INST", (Throwable)ex);
                        }
                        if (hosts.length == 0) {
                            throw new DifferenceException("diff.ERR_NO_HOSTS_IN_HOSTSET");
                        }
                        for (int i = 0; i < hosts.length; ++i) {
                            String hID = hosts[i].getID().toString();
                            DifferenceSettings clone = new DifferenceSettings(settings);
                            clone.setName(clone.getName() + "-" + hID);
                            clone.setDstHostID(hID);
                            clone.setDiffScope(2);
                            context.addWorker(new MIWorker(context, clone));
                        }
                        break;
                    }
                    context.addWorker(new MIWorker(context, settings));
                    break;
                }
                case 2: {
                    context = new IIContext(this.mContext, this, settings, jobID);
                    context.addWorker(new IIWorker(context, settings));
                }
            }
        }
        try {
            this.startSubsystemTask(context);
        }
        catch (RaplixShutdownException ex) {
            throw new DifferenceException("diff.SHUTDOWN_IN_PROGRESS", (Throwable)ex);
        }
        catch (UnsupportedSubsystemException ex) {
            throw new DifferenceException("diff.ERR_MISSING_SUBSYS", (Throwable)ex);
        }
        long theBestEffortTimeout = 60000L;
        long theStart = System.currentTimeMillis();
        while (!context.getDidGrabLock()) {
            if (System.currentTimeMillis() - theStart > 60000L) {
                if (!Logger.isWarnEnabled(this)) break;
                Logger.warn(ROXMessageManager.messageAsString("diff.BG_NO_GRAB_THREAD"), this);
                break;
            }
            try {
                Thread.sleep(125L);
            }
            catch (InterruptedException e) {
                Logger.warn(ROXMessageManager.messageAsString("diff.INTERRUPTED_WAITING_FOR_GRAB"), this);
            }
        }
        return jobID;
    }

    public ResourceID getThrottle() {
        return this.mThrottle;
    }

    public void setSuppressFiltering(boolean suppressFiltering) {
        this.mSuppressFiltering = suppressFiltering;
    }

    public void notify(ROXEvent event) throws RPCException, DifferenceException {
        try {
            this.getApplication().getNotificationManager().notify(event, true);
        }
        catch (UnsupportedSubsystemException ex) {
            throw new DifferenceException("diff.ERR_MISSING_SUBSYS", (Throwable)ex);
        }
    }

    GetRequestValidator getValidator() {
        return this.mValidator;
    }

    AgentOperationValidator getAgentOpValidator() {
        return this.mAgentOpValidator;
    }

    static class GetOperationTuple {
        private RoxAddress mFromAddress;
        private DifferenceJobID mJobID;

        public GetOperationTuple(RoxAddress inFromAddress, DifferenceJobID inJobID) {
            this.mFromAddress = inFromAddress;
            this.mJobID = inJobID;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GetOperationTuple)) {
                return false;
            }
            GetOperationTuple tuple = (GetOperationTuple)o;
            return this.mFromAddress.equals(tuple.mFromAddress) && this.mJobID.equals(tuple.mJobID);
        }

        public int hashCode() {
            return this.mFromAddress.hashCode() ^ this.mJobID.hashCode();
        }

        public String toString() {
            return "GetOperationTuple{mFromAddress=" + this.mFromAddress + ", mJobID=" + this.mJobID + "}";
        }
    }

    static class AgentOperationValidator
    implements RemoteAgentOperationListener {
        private static Set mExpectedRequests = Collections.synchronizedSet(new HashSet());
        private RPCManager mRPC = null;

        public void operationInvoked(RoxAddress remoteAddress, DifferenceJobID diffJobID) throws DifferenceDBException {
            RoxAddress fromAddress = this.mRPC.getInvokerAddress();
            GetOperationTuple tuple = new GetOperationTuple(fromAddress, diffJobID);
            if (!mExpectedRequests.contains(tuple)) {
                if (Logger.isWarnEnabled(class$com$raplix$rolloutexpress$difference$DifferenceEngine == null ? (class$com$raplix$rolloutexpress$difference$DifferenceEngine = DifferenceEngine.class$("com.raplix.rolloutexpress.difference.DifferenceEngine")) : class$com$raplix$rolloutexpress$difference$DifferenceEngine)) {
                    Logger.warn("GetOperationTuple tuple not found:" + tuple, class$com$raplix$rolloutexpress$difference$DifferenceEngine == null ? (class$com$raplix$rolloutexpress$difference$DifferenceEngine = DifferenceEngine.class$("com.raplix.rolloutexpress.difference.DifferenceEngine")) : class$com$raplix$rolloutexpress$difference$DifferenceEngine);
                }
                throw new DifferenceDBException("diff.INVALID_AGENT_OP_REQUEST", new Object[]{fromAddress.toString()});
            }
        }

        void expectOperationFor(RoxAddress inRemoteAddress, DifferenceJobID diffJobID) {
            GetOperationTuple tuple = new GetOperationTuple(inRemoteAddress, diffJobID);
            if (Logger.isDebugEnabled(class$com$raplix$rolloutexpress$difference$DifferenceEngine == null ? (class$com$raplix$rolloutexpress$difference$DifferenceEngine = DifferenceEngine.class$("com.raplix.rolloutexpress.difference.DifferenceEngine")) : class$com$raplix$rolloutexpress$difference$DifferenceEngine)) {
                Logger.debug("Adding GetOperationTuple tuple:" + tuple, class$com$raplix$rolloutexpress$difference$DifferenceEngine == null ? (class$com$raplix$rolloutexpress$difference$DifferenceEngine = DifferenceEngine.class$("com.raplix.rolloutexpress.difference.DifferenceEngine")) : class$com$raplix$rolloutexpress$difference$DifferenceEngine);
            }
            mExpectedRequests.add(tuple);
        }

        AgentOperationValidator(RPCManager inRPC) {
            this.mRPC = inRPC;
        }

        void doneWithOperationFor(RoxAddress inRemoteAddress, DifferenceJobID diffJobID) {
            GetOperationTuple tuple = new GetOperationTuple(inRemoteAddress, diffJobID);
            if (Logger.isDebugEnabled(class$com$raplix$rolloutexpress$difference$DifferenceEngine == null ? (class$com$raplix$rolloutexpress$difference$DifferenceEngine = DifferenceEngine.class$("com.raplix.rolloutexpress.difference.DifferenceEngine")) : class$com$raplix$rolloutexpress$difference$DifferenceEngine)) {
                Logger.debug("Removing GetOperationTuple tuple:" + tuple, class$com$raplix$rolloutexpress$difference$DifferenceEngine == null ? (class$com$raplix$rolloutexpress$difference$DifferenceEngine = DifferenceEngine.class$("com.raplix.rolloutexpress.difference.DifferenceEngine")) : class$com$raplix$rolloutexpress$difference$DifferenceEngine);
            }
            mExpectedRequests.remove(tuple);
        }
    }

    static class GetRequestTuple {
        private String mAbsPath;
        private RoxAddress mFromAddress;
        private RoxAddress mTargetAddress;
        private DifferenceJobID mJobID;

        public GetRequestTuple(String inAbsPath, RoxAddress inFromAddress, RoxAddress inTargetAddress, DifferenceJobID inJobID) {
            this.mAbsPath = FileSpec.convertPathSeparatorToUniversal(inAbsPath);
            this.mFromAddress = inFromAddress;
            this.mTargetAddress = inTargetAddress;
            this.mJobID = inJobID;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GetRequestTuple)) {
                return false;
            }
            GetRequestTuple tuple = (GetRequestTuple)o;
            return this.mFromAddress.equals(tuple.mFromAddress) && this.mTargetAddress.equals(tuple.mTargetAddress) && this.mAbsPath.equals(tuple.mAbsPath) && this.mJobID.equals(tuple.mJobID);
        }

        public int hashCode() {
            return this.mAbsPath.hashCode() ^ this.mFromAddress.hashCode() ^ this.mTargetAddress.hashCode() ^ this.mJobID.hashCode();
        }

        public String toString() {
            return "GetRequestTuple{mAbsPath='" + this.mAbsPath + "'" + ", mFromAddress=" + this.mFromAddress + ", mTargetAddress=" + this.mTargetAddress + ", mJobID=" + this.mJobID + "}";
        }
    }

    static class GetRequestValidator
    implements GetRemoteFileListener {
        private Set mExpectedRequests = Collections.synchronizedSet(new HashSet());
        private RPCManager mRPC = null;

        public void receivedRequest(RoxAddress targetAddress, AbsoluteFileSpec requestedFile, ObjectID inJobID) throws UnexpectedGetRequest {
            RoxAddress fromAddress = this.mRPC.getInvokerAddress();
            GetRequestTuple tuple = new GetRequestTuple(requestedFile.toFile().getPath(), fromAddress, targetAddress, (DifferenceJobID)inJobID);
            if (!this.mExpectedRequests.contains(tuple)) {
                if (Logger.isWarnEnabled(class$com$raplix$rolloutexpress$difference$DifferenceEngine == null ? (class$com$raplix$rolloutexpress$difference$DifferenceEngine = DifferenceEngine.class$("com.raplix.rolloutexpress.difference.DifferenceEngine")) : class$com$raplix$rolloutexpress$difference$DifferenceEngine)) {
                    Logger.warn("tuple not found:" + tuple, class$com$raplix$rolloutexpress$difference$DifferenceEngine == null ? (class$com$raplix$rolloutexpress$difference$DifferenceEngine = DifferenceEngine.class$("com.raplix.rolloutexpress.difference.DifferenceEngine")) : class$com$raplix$rolloutexpress$difference$DifferenceEngine);
                }
                throw new UnexpectedGetRequest("diff.INVALID_FILE_REQUEST", new Object[]{requestedFile.toFile().getPath(), fromAddress.toString(), targetAddress.toString()});
            }
        }

        void expectGetRequestsFor(FileSpec[] inSpecs, RoxAddress inFromAddress, RoxAddress inTargetAddress, DifferenceJobID diffJobID) {
            for (int i = 0; i < inSpecs.length; ++i) {
                GetRequestTuple tuple = new GetRequestTuple(inSpecs[i].getPath(), inFromAddress, inTargetAddress, diffJobID);
                this.mExpectedRequests.add(tuple);
                if (!Logger.isDebugEnabled(class$com$raplix$rolloutexpress$difference$DifferenceEngine == null ? DifferenceEngine.class$("com.raplix.rolloutexpress.difference.DifferenceEngine") : class$com$raplix$rolloutexpress$difference$DifferenceEngine)) continue;
                Logger.debug("Added Expected tuple:" + tuple, class$com$raplix$rolloutexpress$difference$DifferenceEngine == null ? DifferenceEngine.class$("com.raplix.rolloutexpress.difference.DifferenceEngine") : class$com$raplix$rolloutexpress$difference$DifferenceEngine);
            }
        }

        public GetRequestValidator(RPCManager inRPC) {
            this.mRPC = inRPC;
        }

        void doneWithGetRequestsFor(FileSpec[] inSpecs, RoxAddress inFromAddress, RoxAddress inTargetAddress, DifferenceJobID diffJobID) {
            for (int i = 0; i < inSpecs.length; ++i) {
                GetRequestTuple tuple = new GetRequestTuple(inSpecs[i].getPath(), inFromAddress, inTargetAddress, diffJobID);
                this.mExpectedRequests.remove(tuple);
                if (!Logger.isDebugEnabled(class$com$raplix$rolloutexpress$difference$DifferenceEngine == null ? DifferenceEngine.class$("com.raplix.rolloutexpress.difference.DifferenceEngine") : class$com$raplix$rolloutexpress$difference$DifferenceEngine)) continue;
                Logger.debug("Removed Expected tuple:" + tuple, class$com$raplix$rolloutexpress$difference$DifferenceEngine == null ? DifferenceEngine.class$("com.raplix.rolloutexpress.difference.DifferenceEngine") : class$com$raplix$rolloutexpress$difference$DifferenceEngine);
            }
        }
    }
}

