/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import [Ljava.io.File;;
import com.raplix.rolloutexpress.Agent;
import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.command.commandresult.SymlinkSpec;
import com.raplix.rolloutexpress.command.stickydata.BagID;
import com.raplix.rolloutexpress.command.stickydata.ItemID;
import com.raplix.rolloutexpress.command.stickydata.Table;
import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.DifferenceAgentInterface;
import com.raplix.rolloutexpress.difference.DifferenceAgentInterfaceII;
import com.raplix.rolloutexpress.difference.DifferenceAgentInterfaceMI;
import com.raplix.rolloutexpress.difference.DifferenceEngine;
import com.raplix.rolloutexpress.difference.DifferenceException;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.DifferenceMessages;
import com.raplix.rolloutexpress.difference.DifferencePath;
import com.raplix.rolloutexpress.difference.DifferenceState;
import com.raplix.rolloutexpress.difference.IIDifferencePath;
import com.raplix.rolloutexpress.difference.MIDifferencePath;
import com.raplix.rolloutexpress.difference.PackageInfo;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.executor.task.DirectoryListing;
import com.raplix.rolloutexpress.executor.task.FileType;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.resource.AbsoluteFileSpec;
import com.raplix.rolloutexpress.resource.DirPath;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.capture.ContentsTableEntry;
import com.raplix.rolloutexpress.resource.capture.OwnedCaptureType;
import com.raplix.rolloutexpress.resource.capture.SnapshotOwnerTable;
import com.raplix.rolloutexpress.resource.capture.SnapshotOwnerTableEntry;
import com.raplix.rolloutexpress.resource.capture.SnapshotOwnerTransaction;
import com.raplix.rolloutexpress.resource.exception.CaptureException;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.collections.Compare;
import com.raplix.util.collections.UnorderedListener;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.file.FileInfo;
import com.raplix.util.iowrappers.TempFile;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.Link;
import com.raplix.util.string.CaseString;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

public class DifferenceAgentEngine
extends Subsystem
implements DifferenceAgentInterface,
DifferenceAgentInterfaceMI,
DifferenceAgentInterfaceII,
DifferenceMessages {
    private Table mStickyTable;
    private ResourceSubsystem mResourceSubsystem;

    private DifferenceAgentEngine() {
    }

    public DifferenceAgentEngine(Application app) throws ConfigurationException, UnsupportedSubsystemException {
        super(app);
        this.mStickyTable = ((Agent)app).getStickySubsystem().getTable(DifferenceEngine.CLASS_SUBSYSTEM_ID);
        this.mResourceSubsystem = app.getResourceSubsystem();
        RPCManager rpc = app.getNetSubsystem().getRPC();
        try {
            rpc.registerService(DifferenceAgentInterface.class, this);
            rpc.registerService(DifferenceAgentInterfaceMI.class, this);
            rpc.registerService(DifferenceAgentInterfaceII.class, this);
        }
        catch (RPCException ex) {
            throw new ConfigurationException("diff.ERR_REGISTER_RPC_RA", (Throwable)ex);
        }
    }

    private DifferenceState getState(ItemID handle) throws DifferenceException {
        try {
            return (DifferenceState)this.mStickyTable.getItem(handle);
        }
        catch (IllegalArgumentException ex) {
            throw new DifferenceException("diff.ERR_STATE_HANDLE", (Throwable)ex, new Object[]{handle});
        }
    }

    private void reportMissing(DifferenceState state, MIDifferencePath path, File file, int type) {
        String name;
        File parent;
        while ((parent = file.getParentFile()) != null && !new FileInfo(parent).exists()) {
            file = parent;
            type = 1;
        }
        if (parent == null) {
            name = file.getAbsolutePath();
        } else {
            path = (MIDifferencePath)path.copy();
            path.setFilePath(parent.getAbsolutePath());
            name = file.getName();
        }
        state.getReporter().reportDifference(path, new Difference(type, name, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diffLinkSnapshot(DifferenceState state, MIDifferencePath path, final SnapshotOwnerTableEntry oe) {
        try {
            File dst = new File(path.getFilePath());
            if (!new FileInfo(dst).isLink()) {
                this.reportMissing(state, path, dst, 9);
                return;
            }
            String dstContents = Link.read(path.getFilePath());
            TempFile t = new TempFile();
            try {
                final File src = t.getFile();
                new SnapshotOwnerTransaction(this.mResourceSubsystem){

                    public Object innerTransact(SnapshotOwnerTable table) throws CaptureException {
                        return table.getOwnedCaptureContents(oe.getOwnedCaptureID(), src);
                    }
                }.transact();
                String srcContents = new String(CopyUtil.readBinary(src.getAbsolutePath()));
                if (srcContents.equals(dstContents)) {
                    return;
                }
                state.getReporter().reportDifference(path, new Difference(10, srcContents, dstContents));
            }
            finally {
                t.close();
            }
        }
        catch (Exception ex) {
            state.getReporter().reportError(PackageInfo.createGenericLink(path, ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diffFileSnapshot(DifferenceState state, MIDifferencePath path, final SnapshotOwnerTableEntry oe) {
        try {
            File dst = new File(path.getFilePath());
            if (!new FileInfo(dst).isPlain()) {
                this.reportMissing(state, path, dst, 0);
                return;
            }
            if (state.getSettings().getDiffLevel() == 1) {
                if (oe.getByteCount() != dst.length()) {
                    state.getReporter().reportDifference(path, new Difference(2, (int)oe.getByteCount(), (int)dst.length()));
                }
                return;
            }
            TempFile t = new TempFile();
            try {
                final File src = t.getFile();
                new SnapshotOwnerTransaction(this.mResourceSubsystem){

                    public Object innerTransact(SnapshotOwnerTable table) throws CaptureException {
                        return table.getOwnedCaptureContents(oe.getOwnedCaptureID(), src);
                    }
                }.transact();
                state.getComparator().apply(src, dst, path);
            }
            finally {
                t.close();
            }
        }
        catch (Exception ex) {
            state.getReporter().reportError(PackageInfo.createGenericFile(path, ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diffDirSnapshot(DifferenceState state, MIDifferencePath path, final SnapshotOwnerTableEntry oe) {
        try {
            File dst = new File(path.getFilePath());
            if (!new FileInfo(dst).isDirectory()) {
                this.reportMissing(state, path, dst, 1);
                return;
            }
            TempFile t = new TempFile();
            try {
                final File src = t.getFile();
                new SnapshotOwnerTransaction(this.mResourceSubsystem){

                    public Object innerTransact(SnapshotOwnerTable table) throws CaptureException {
                        return table.getOwnedCaptureContents(oe.getOwnedCaptureID(), src);
                    }
                }.transact();
                DirectoryListing srcList = DirectoryListing.readFrom(src);
                Vector<CaseString> srcLinks = new Vector<CaseString>();
                Vector<CaseString> srcDirs = new Vector<CaseString>();
                Vector<CaseString> srcFiles = new Vector<CaseString>();
                Enumeration e = srcList.fileList();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    CaseString caseName = new CaseString(name, state.getIgnoreCase());
                    FileType type = srcList.getFileType(name);
                    if (FileType.SYM_LINK.equals(type)) {
                        srcLinks.addElement(caseName);
                        continue;
                    }
                    if (FileType.DIRECTORY.equals(type)) {
                        srcDirs.addElement(caseName);
                        continue;
                    }
                    srcFiles.addElement(caseName);
                }
                File[] dstList = dst.listFiles();
                Vector<CaseString> dstLinks = new Vector<CaseString>();
                Vector<CaseString> dstDirs = new Vector<CaseString>();
                Vector<CaseString> dstFiles = new Vector<CaseString>();
                for (int i = 0; i < dstList.length; ++i) {
                    CaseString caseName = new CaseString(dstList[i].getName(), state.getIgnoreCase());
                    FileInfo info = new FileInfo(dstList[i]);
                    if (info.isLink()) {
                        dstLinks.addElement(caseName);
                        continue;
                    }
                    if (info.isDirectory()) {
                        dstDirs.addElement(caseName);
                        continue;
                    }
                    if (!info.isPlain()) continue;
                    dstFiles.addElement(caseName);
                }
                Compare.compareUnordered(srcLinks, dstLinks, new MIDirectoryListener(state, path, 9));
                Compare.compareUnordered(srcDirs, dstDirs, new MIDirectoryListener(state, path, 1));
                Compare.compareUnordered(srcFiles, dstFiles, new MIDirectoryListener(state, path, 0));
            }
            finally {
                t.close();
            }
        }
        catch (Exception ex) {
            state.getReporter().reportError(PackageInfo.createGenericDirectory(path, ex));
        }
    }

    private static boolean isLink(DifferenceState state, FileInfo dstInfo) {
        return !state.getSettings().getFollowSymlinks() && dstInfo.isLink();
    }

    private static boolean isDirectory(DifferenceState state, FileInfo dstInfo) {
        if (state.getSettings().getFollowSymlinks()) {
            return dstInfo.getFile().isDirectory();
        }
        return dstInfo.isDirectory();
    }

    private static void reportMissing(DifferenceState state, IIDifferencePath path, FileSpec src) {
        int type = src.isSymlink() ? 9 : (src.isDirectory() ? 1 : 0);
        state.getReporter().reportDifference(path, new Difference(type, src.extractName(), null));
    }

    private static void reportMissing(DifferenceState state, IIDifferencePath path, FileInfo dstInfo) {
        int type = DifferenceAgentEngine.isLink(state, dstInfo) ? 9 : (DifferenceAgentEngine.isDirectory(state, dstInfo) ? 1 : 0);
        state.getReporter().reportDifference(path, new Difference(type, null, dstInfo.getFile().getName()));
    }

    private void diffSymlinks(DifferenceState state, IIDifferencePath path, SymlinkSpec src, File dst) {
        String dstContents;
        try {
            dstContents = Link.read(dst.getAbsolutePath());
        }
        catch (IllegalArgumentException ex) {
            state.getReporter().reportError(PackageInfo.createGenericLink(path, ex));
            return;
        }
        if (src.getContents().equals(dstContents)) {
            return;
        }
        state.getReporter().reportDifference(path, new Difference(10, src.getContents(), dstContents));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diffFiles(DifferenceState state, IIDifferencePath path, FileSpec src, File dst) {
        if (state.getFilter().matchImpreciseEnd(path)) {
            return;
        }
        if (state.getSettings().getDiffLevel() == 1) {
            if (src.getSize() != dst.length()) {
                state.getReporter().reportDifference(path, new Difference(2, (int)src.getSize(), (int)dst.length()));
            }
            return;
        }
        try {
            TempFile t = new TempFile();
            try {
                File remote = new File(src.getPath());
                File local = t.getFile();
                this.mResourceSubsystem.getRemoteFile(new AbsoluteFileSpec(new DirPath(remote.getParentFile().getAbsolutePath()), remote.getName()), src.getRoxAddress(), new AbsoluteFileSpec(new DirPath(local.getParentFile().getAbsolutePath()), local.getName()), state.getJobID());
                state.getComparator().apply(local, dst, path);
            }
            finally {
                t.close();
            }
        }
        catch (RPCException ex) {
            state.getReporter().reportError(new DifferenceException("diff.ERR_OBTAIN_RMT_RSRC", (Throwable)ex));
        }
        catch (ResourceException ex) {
            state.getReporter().reportError(new DifferenceException("diff.ERR_OBTAIN_RMT_RSRC", (Throwable)ex));
        }
        catch (IOException ex) {
            state.getReporter().reportError(new DifferenceException("diff.IO_ERR_DURING_DIFF", (Throwable)ex));
        }
    }

    public String getSubsystemName() {
        return ROXMessageManager.messageAsString("diff.SUBSYSTEM_NAME_RA");
    }

    public ItemID createState(BagID bagID, DifferenceSettings settings, DifferenceJobID jobID) throws RPCException, DifferenceException {
        if (this.isShuttingDown()) {
            throw new DifferenceException("diff.SHUTDOWN_IN_PROGRESS");
        }
        return this.mStickyTable.addItem(new DifferenceState((Agent)this.getApplication(), settings, jobID, PlatformUtil.isWin32(), true, true), bagID, null);
    }

    public void deleteState(ItemID handle) throws RPCException {
        this.mStickyTable.removeItem(handle);
    }

    public void diffSnapshot(ItemID handle, MIDifferencePath path) throws RPCException, DifferenceException {
        if (this.isShuttingDown()) {
            throw new DifferenceException("diff.SHUTDOWN_IN_PROGRESS");
        }
        DifferenceState state = this.getState(handle);
        try {
            ContentsTableEntry[] ces = this.mResourceSubsystem.getSnapshotContentsTable().get(path.getSnapshotID());
            for (int i = 0; i < ces.length; ++i) {
                ContentsTableEntry ce = ces[i];
                final String name = ce.getEntryName();
                path.setFilePath(name);
                path.setDisplayName(ce.getDisplayName());
                if (state.getFilter().matchImpreciseEnd(path)) continue;
                SnapshotOwnerTableEntry[] oes = (SnapshotOwnerTableEntry[])new SnapshotOwnerTransaction(this.mResourceSubsystem){

                    public Object innerTransact(SnapshotOwnerTable table) throws CaptureException {
                        return table.queryByName(name);
                    }
                }.transact();
                if (oes.length == 0) {
                    state.getReporter().reportDifference(path, new Difference(7, path.getComponentID().toString(), ""));
                    continue;
                }
                SnapshotOwnerTableEntry fullMatch = null;
                boolean foundPartialMatch = false;
                HashSet<String> ownerIDs = new HashSet<String>();
                for (int j = 0; j < oes.length; ++j) {
                    SnapshotOwnerTableEntry oe = oes[j];
                    InstalledComponentID ID2 = oe.getInstalledComponentID();
                    if (ID2.equals(path.getComponentID())) {
                        if (oe.getSnapshotID().equals(path.getSnapshotID())) {
                            if (fullMatch != null) {
                                state.getReporter().reportError(PackageInfo.createDuplicateEntry(name, path.getComponentID(), path.getSnapshotID()));
                            }
                            fullMatch = oe;
                        }
                        foundPartialMatch = true;
                        continue;
                    }
                    ownerIDs.add(ID2.toString());
                }
                if (fullMatch == null) {
                    if (foundPartialMatch || state.getSettings().getDiffScope() != 0) continue;
                    state.getReporter().reportDifference(path, new Difference(7, path.getComponentID().toString(), CollectionUtil.toString(ownerIDs, "", ",")));
                    continue;
                }
                if (state.isProcessed(name)) continue;
                OwnedCaptureType type = fullMatch.getOwnedCaptureType();
                if (OwnedCaptureType.LINK_VALUE.equals(type)) {
                    this.diffLinkSnapshot(state, path, fullMatch);
                } else if (OwnedCaptureType.FILE_CONTENTS.equals(type)) {
                    this.diffFileSnapshot(state, path, fullMatch);
                } else if (OwnedCaptureType.DIR_LISTING.equals(type)) {
                    this.diffDirSnapshot(state, path, fullMatch);
                }
                state.setProcessed(name);
            }
        }
        catch (Exception ex) {
            state.getReporter().reportError(PackageInfo.createBadSnapshotQuery(path, ex));
        }
    }

    public void diffBatch(ItemID handle, IIDifferencePath path, FileSpec[] src) throws RPCException, DifferenceException {
        class DirectoryUnreadableException
        extends Exception {
            DirectoryUnreadableException() {
            }
        }
        if (this.isShuttingDown()) {
            throw new DifferenceException("diff.SHUTDOWN_IN_PROGRESS");
        }
        DifferenceState state = this.getState(handle);
        File destinationDirectory = new File(state.getSettings().getDstDir(), path.getFilePath());
        try {
            CaseString[] srcNames = new CaseString[src.length];
            for (int i = 0; i < src.length; ++i) {
                srcNames[i] = new CaseString(src[i].extractName(), state.getIgnoreCase());
            }
            File[] dstRaw = destinationDirectory.listFiles();
            if (dstRaw == null) {
                if (!destinationDirectory.canRead()) {
                    throw new DirectoryUnreadableException();
                }
                dstRaw = new File[]{};
            }
            Vector<File> dstAccessible = new Vector<File>();
            for (int i = 0; i < dstRaw.length; ++i) {
                File f;
                block13: {
                    f = dstRaw[i];
                    if (!state.getSettings().getFollowSymlinks()) {
                        FileInfo info = new FileInfo(f);
                        try {
                            if (!(info.isLink() || info.isDirectory() || info.isPlain())) {
                            }
                            break block13;
                        }
                        catch (IllegalArgumentException ex) {
                            if (!Logger.isErrorEnabled(this)) continue;
                            Logger.error(ROXMessageManager.messageAsString("diff.IGNORING_FILE", new Object[]{f.getAbsolutePath()}), ex, this);
                        }
                        continue;
                    }
                    if (!f.exists() || !f.isDirectory() && !f.isFile()) continue;
                }
                dstAccessible.addElement(f);
            }
            File[] dst = (File[])CollectionUtil.mapClass(dstAccessible, File;.class);
            CaseString[] dstNames = new CaseString[dst.length];
            for (int i = 0; i < dst.length; ++i) {
                dstNames[i] = new CaseString(dst[i].getName(), state.getIgnoreCase());
            }
            Compare.compareUnordered(srcNames, dstNames, new IIDirectoryListener(state, path, src, dst));
        }
        catch (DirectoryUnreadableException ex) {
            state.getReporter().reportError(PackageInfo.createUnreadableDirFailure(destinationDirectory.getAbsolutePath(), null));
        }
        catch (Exception ex) {
            state.getReporter().reportError(PackageInfo.createPathFailure(path, ex));
        }
    }

    public void diffSingleFile(ItemID handle, FileSpec src, FileSpec dst, IIDifferencePath path) throws RPCException, DifferenceException {
        if (this.isShuttingDown()) {
            throw new DifferenceException("diff.SHUTDOWN_IN_PROGRESS");
        }
        DifferenceState state = this.getState(handle);
        try {
            CaseString[] dummy = new CaseString[]{new CaseString("dummy", false)};
            Compare.compareUnordered(dummy, dummy, new IIDirectoryListener(state, path, new FileSpec[]{src}, new File[]{new File(dst.getPath())}));
        }
        catch (Exception ex) {
            state.getReporter().reportError(PackageInfo.createPathFailure(path, ex));
        }
    }

    public DifferencePath extend(IIDifferencePath path, String extension) throws RPCException, DifferenceException {
        if (this.isShuttingDown()) {
            throw new DifferenceException("diff.SHUTDOWN_IN_PROGRESS");
        }
        return path.extend(extension);
    }

    public boolean matchImpreciseEnd(ItemID handle, IIDifferencePath path) throws RPCException, DifferenceException {
        if (this.isShuttingDown()) {
            throw new DifferenceException("diff.SHUTDOWN_IN_PROGRESS");
        }
        return this.getState(handle).getFilter().matchImpreciseEnd(path);
    }

    private class IIDirectoryListener
    implements UnorderedListener {
        private DifferenceState mState;
        private IIDifferencePath mPath;
        private FileSpec[] mSrc;
        private File[] mDst;

        IIDirectoryListener(DifferenceState state, IIDifferencePath path, FileSpec[] src, File[] dst) {
            this.mState = state;
            this.mPath = path;
            this.mSrc = src;
            this.mDst = dst;
        }

        public void missing1(Object o2, int i2) {
            try {
                DifferenceAgentEngine.reportMissing(this.mState, this.mPath, new FileInfo(this.mDst[i2]));
            }
            catch (IllegalArgumentException ex) {
                this.mState.getReporter().reportError(PackageInfo.createGenericFile(this.mPath, ex));
            }
        }

        public void missing2(Object o1, int i1) {
            DifferenceAgentEngine.reportMissing(this.mState, this.mPath, this.mSrc[i1]);
        }

        public void match(Object o1, int i1, Object o2, int i2) {
            FileSpec src = this.mSrc[i1];
            File dst = this.mDst[i2];
            try {
                FileInfo dstInfo = new FileInfo(dst);
                if (src.isSymlink() || DifferenceAgentEngine.isLink(this.mState, dstInfo)) {
                    if (src.isSymlink() != DifferenceAgentEngine.isLink(this.mState, dstInfo)) {
                        DifferenceAgentEngine.reportMissing(this.mState, this.mPath, src);
                        DifferenceAgentEngine.reportMissing(this.mState, this.mPath, dstInfo);
                        return;
                    }
                    DifferenceAgentEngine.this.diffSymlinks(this.mState, (IIDifferencePath)this.mPath.extend(this.mState.getExtendDst() ? dst.getName() : src.extractName()), (SymlinkSpec)src, dst);
                    return;
                }
                if (src.isDirectory() || DifferenceAgentEngine.isDirectory(this.mState, dstInfo)) {
                    if (src.isDirectory() != DifferenceAgentEngine.isDirectory(this.mState, dstInfo)) {
                        DifferenceAgentEngine.reportMissing(this.mState, this.mPath, src);
                        DifferenceAgentEngine.reportMissing(this.mState, this.mPath, dstInfo);
                    }
                    return;
                }
            }
            catch (IllegalArgumentException ex) {
                this.mState.getReporter().reportError(PackageInfo.createGenericFile(this.mPath, ex));
                return;
            }
            DifferenceAgentEngine.this.diffFiles(this.mState, (IIDifferencePath)this.mPath.extend(this.mState.getExtendDst() ? dst.getName() : src.extractName()), src, dst);
        }
    }

    private class MIDirectoryListener
    implements UnorderedListener {
        private DifferenceState mState;
        private MIDifferencePath mPath;
        private int mType;

        MIDirectoryListener(DifferenceState state, MIDifferencePath path, int type) {
            this.mState = state;
            this.mPath = path;
            this.mType = type;
        }

        public void missing1(Object o2, int i2) {
            this.mState.getReporter().reportDifference(this.mPath, new Difference(this.mType, null, ((CaseString)o2).getValue()));
        }

        public void missing2(Object o1, int i1) {
            DifferenceAgentEngine.this.reportMissing(this.mState, this.mPath, new File(this.mPath.getFilePath(), ((CaseString)o1).getValue()), this.mType);
        }

        public void match(Object o1, int i1, Object o2, int i2) {
        }
    }
}

