/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.difference.DifferenceID;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.util.ObjectUtil;

public class Difference
extends PersistentObject
implements RPCSerializable,
HasObjectID {
    public static final int DIFF_FILE_MISSING = 0;
    public static final int DIFF_DIR_MISSING = 1;
    public static final int DIFF_FILE_SIZE = 2;
    public static final int DIFF_COMPONENT_MISSING = 3;
    public static final int DIFF_COMPONENT_MISSING_PATH = 4;
    public static final int DIFF_COMPONENT_VERSION_MISMATCH = 5;
    public static final int DIFF_DIFF = 6;
    public static final int DIFF_FC = 8;
    public static final int DIFF_NEW_COMPONENT = 7;
    public static final int DIFF_LINK_MISSING = 9;
    public static final int DIFF_LINK_VALUE = 10;
    private String mTrueClass;
    private int mType;
    private String mIdentifier;
    private String mSrcVal;
    private String mDstVal;
    private int mSrcOrd;
    private int mDstOrd;

    public Difference() {
    }

    public Difference(int type, String srcVal, String dstVal) {
        this(type, null, srcVal, dstVal, 0, 0);
    }

    public Difference(int type, int srcOrder, int dstOrder) {
        this(type, null, null, null, srcOrder, dstOrder);
    }

    public Difference(int type, String identifier, String srcVal, String dstVal, int srcOrder, int dstOrder) {
        this.mType = type;
        this.mIdentifier = identifier;
        this.mSrcVal = srcVal;
        this.mDstVal = dstVal;
        this.mSrcOrd = srcOrder;
        this.mDstOrd = dstOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Difference d = (Difference)o;
        if (this.getType() != d.getType()) {
            return false;
        }
        if (!ObjectUtil.equals(this.getIdentifier(), d.getIdentifier())) {
            return false;
        }
        if (!ObjectUtil.equals(this.getSourceVal(), d.getSourceVal())) {
            return false;
        }
        if (!ObjectUtil.equals(this.getDestVal(), d.getDestVal())) {
            return false;
        }
        if (this.getSourceOrder() != d.getSourceOrder()) {
            return false;
        }
        return this.getDestOrder() == d.getDestOrder();
    }

    public int hashCode() {
        return this.getType() + ObjectUtil.hashCode(this.getIdentifier()) + ObjectUtil.hashCode(this.getSourceVal()) + ObjectUtil.hashCode(this.getDestVal()) + this.getSourceOrder() + this.getDestOrder();
    }

    public String toString() {
        switch (this.getType()) {
            case 0: {
                if (this.getSourceVal() != null) {
                    return "File absent from destination: " + this.getSourceVal();
                }
                return "File absent from source: " + this.getDestVal();
            }
            case 9: {
                if (this.getSourceVal() != null) {
                    return "Symbolic link absent from destination: " + this.getSourceVal();
                }
                return "Symbolic link absent from source: " + this.getDestVal();
            }
            case 1: {
                if (this.getSourceVal() != null) {
                    return "Directory absent from destination: " + this.getSourceVal();
                }
                return "Directory absent from source: " + this.getDestVal();
            }
            case 2: {
                return "File sizes are different: " + this.getSourceOrder() + " in source, " + this.getDestOrder() + " in destination";
            }
            case 10: {
                return "Symbolic links point to different files: " + this.getSourceVal() + " in source, " + this.getDestVal() + " in destination";
            }
            case 3: {
                if (this.getSourceVal() != null) {
                    return "Component absent from destination: " + this.getSourceVal();
                }
                return "Component absent from source: " + this.getDestVal();
            }
            case 5: {
                return "Component version mismatch: " + this.getSourceVal() + " in source, " + this.getDestVal() + " in destination";
            }
            case 4: {
                if (this.getSourceVal() != null) {
                    return "Component absent at source path in destination: " + this.getSourceVal();
                }
                return "Component absent at destination path in source: " + this.getDestVal();
            }
            case 6: {
                return "Result of UNIX diff: " + this.getSourceVal();
            }
            case 8: {
                return "Result of Windows fc: " + this.getSourceVal();
            }
            case 7: {
                return "Ownership changed from installed component " + this.getSourceVal() + " in source to " + this.getDestVal() + " in destination";
            }
        }
        throw new IllegalArgumentException("Invalid type: " + this.getType());
    }

    public void setTrueClass(String trueClass) {
        this.mTrueClass = trueClass;
    }

    public String getTrueClass() {
        return this.mTrueClass;
    }

    public void setType(int type) {
        this.mType = type;
    }

    public int getType() {
        return this.mType;
    }

    public void setIdentifier(String identifier) {
        this.mIdentifier = identifier;
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public void setSourceVal(String srcVal) {
        this.mSrcVal = srcVal;
    }

    public String getSourceVal() {
        return this.mSrcVal;
    }

    public void setDestVal(String dstVal) {
        this.mDstVal = dstVal;
    }

    public String getDestVal() {
        return this.mDstVal;
    }

    public void setSourceOrder(int srcOrd) {
        this.mSrcOrd = srcOrd;
    }

    public int getSourceOrder() {
        return this.mSrcOrd;
    }

    public void setDestOrder(int dstOrd) {
        this.mDstOrd = dstOrd;
    }

    public int getDestOrder() {
        return this.mDstOrd;
    }

    public DifferenceID getDifferenceID() {
        return (DifferenceID)this.getObjectID();
    }

    public DifferenceID getID() {
        return this.getDifferenceID();
    }
}

