/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.difference.Difference;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ConfDifference
extends Difference {
    public static final int DIFF_CONF = 500;

    public ConfDifference() {
    }

    public ConfDifference(String ID2, String srcVal, String dstVal, int srcOrder, int dstOrder) {
        super(500, ID2, srcVal, dstVal, srcOrder, dstOrder);
    }

    private static Hashtable parse(BufferedReader inFile, boolean caseInsensitiveTags) throws IOException {
        String line;
        Hashtable<String, DirectiveList> table = new Hashtable<String, DirectiveList>();
        while ((line = inFile.readLine()) != null) {
            int whitesp;
            if (line.startsWith("#")) continue;
            line = line.trim();
            for (whitesp = 0; whitesp < line.length() && !Character.isWhitespace(line.charAt(whitesp)); ++whitesp) {
            }
            String tag = line.substring(0, whitesp);
            String val = whitesp < line.length() ? line.substring(whitesp + 1) : "";
            val = val.trim();
            DirectiveList dl = (DirectiveList)table.get(tag);
            if (dl != null) {
                dl.mValues.addElement(val);
                continue;
            }
            dl = new DirectiveList();
            dl.mDirectiveID = tag;
            dl.mValues.addElement(val);
            if (caseInsensitiveTags) {
                table.put(tag.toLowerCase(), dl);
                continue;
            }
            table.put(tag, dl);
        }
        return table;
    }

    public String toString() {
        switch (this.getType()) {
            case 500: {
                if (this.getSourceVal() == null) {
                    return this.getIdentifier() + ": missing from source \"" + this.getDestVal() + "\" (#" + this.getDestOrder() + ")";
                }
                if (this.getDestVal() == null) {
                    return this.getIdentifier() + ": missing from destination \"" + this.getSourceVal() + "\" (#" + this.getSourceOrder() + ")";
                }
                return this.getIdentifier() + ": source is \"" + this.getSourceVal() + "\" (#" + this.getSourceOrder() + "), destination is \"" + this.getDestVal() + "\" (#" + this.getDestOrder() + ")";
            }
        }
        throw new IllegalArgumentException("Invalid type: " + this.getType());
    }

    public static Vector diffConfs(InputStream inSourceStr, InputStream inDestStr, boolean caseInsensitiveTags) throws IOException {
        String s;
        int i;
        Enumeration vals;
        DirectiveList dl;
        BufferedReader srcReader = new BufferedReader(new InputStreamReader(inSourceStr));
        BufferedReader destReader = new BufferedReader(new InputStreamReader(inDestStr));
        Hashtable src = ConfDifference.parse(srcReader, caseInsensitiveTags);
        Hashtable dest = ConfDifference.parse(destReader, caseInsensitiveTags);
        Vector<ConfDifference> diffs = new Vector<ConfDifference>();
        Enumeration elems = src.elements();
        while (elems.hasMoreElements()) {
            dl = (DirectiveList)elems.nextElement();
            DirectiveList inDest = caseInsensitiveTags ? (DirectiveList)dest.get(dl.mDirectiveID.toLowerCase()) : (DirectiveList)dest.get(dl.mDirectiveID);
            if (inDest == null) {
                vals = dl.mValues.elements();
                i = 1;
                while (vals.hasMoreElements()) {
                    s = (String)vals.nextElement();
                    diffs.addElement(new ConfDifference(dl.mDirectiveID, s, null, i, 0));
                    ++i;
                }
                continue;
            }
            vals = dl.mValues.elements();
            i = 1;
            while (vals.hasMoreElements()) {
                String aVal = (String)vals.nextElement();
                int position = inDest.mValues.indexOf(aVal);
                if (position < 0) {
                    diffs.addElement(new ConfDifference(dl.mDirectiveID, aVal, inDest.mValues.elementAt(i - 1).toString(), i, i));
                } else if (position + 1 != i) {
                    diffs.addElement(new ConfDifference(dl.mDirectiveID, aVal, aVal, i, position + 1));
                }
                ++i;
            }
        }
        elems = dest.elements();
        while (elems.hasMoreElements()) {
            dl = (DirectiveList)elems.nextElement();
            DirectiveList inSrc = caseInsensitiveTags ? (DirectiveList)src.get(dl.mDirectiveID.toLowerCase()) : (DirectiveList)src.get(dl.mDirectiveID);
            if (inSrc != null) continue;
            vals = dl.mValues.elements();
            i = 1;
            while (vals.hasMoreElements()) {
                s = (String)vals.nextElement();
                diffs.addElement(new ConfDifference(dl.mDirectiveID, null, s, 0, i));
                ++i;
            }
        }
        return diffs;
    }

    private static class DirectiveList {
        String mDirectiveID;
        Vector mValues = new Vector();

        private DirectiveList() {
        }
    }
}

