/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.difference.ApacheDifference;
import com.raplix.rolloutexpress.difference.BinaryDifference;
import com.raplix.rolloutexpress.difference.ConfDifference;
import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.DifferenceException;
import com.raplix.rolloutexpress.difference.DifferencePath;
import com.raplix.rolloutexpress.difference.DifferenceState;
import com.raplix.rolloutexpress.difference.ORADifference;
import com.raplix.rolloutexpress.difference.PackageInfo;
import com.raplix.rolloutexpress.difference.PlatformDifferencer;
import com.raplix.rolloutexpress.difference.PropertiesDifference;
import com.raplix.rolloutexpress.difference.XMLDifferencer;
import com.raplix.rolloutexpress.difference.ZipDifferencer;
import com.raplix.util.Checksum;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.InputStreamWrapper;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class Comparator {
    private DifferenceState mState;
    private PlatformDifferencer mPlatform;

    Comparator(DifferenceState state) throws DifferenceException {
        this.mState = state;
        this.mPlatform = new PlatformDifferencer(this.mState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getChecksum(File file) throws IOException {
        InputStreamWrapper in = new InputStreamWrapper(file);
        try {
            long l = Checksum.calculateChecksum(in.getStream());
            return l;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(File src, File dst, DifferencePath path) {
        try {
            int type = this.mState.getTyper().getType(path);
            if (type == 8 ? this.mState.getFilter().matchImpreciseEnd(path) : this.mState.getFilter().match(path)) {
                return;
            }
            if (Comparator.getChecksum(src) == Comparator.getChecksum(dst)) {
                return;
            }
            if (type != 2) {
                Closer c = new Closer();
                Vector diffs = null;
                try {
                    InputStreamWrapper srcW = new InputStreamWrapper(src);
                    c.register(srcW);
                    InputStream srcS = srcW.getStream();
                    InputStreamWrapper dstW = new InputStreamWrapper(dst);
                    c.register(dstW);
                    InputStream dstS = dstW.getStream();
                    try {
                        switch (type) {
                            case 1: {
                                diffs = BinaryDifference.diffBinaries(srcS, dstS);
                                break;
                            }
                            case 3: {
                                diffs = ORADifference.diffORAFiles(srcS, dstS);
                                break;
                            }
                            case 4: {
                                XMLDifferencer.apply(srcS, dstS, path, this.mState);
                                diffs = new Vector();
                                break;
                            }
                            case 5: {
                                diffs = ApacheDifference.diffApacheFiles(srcS, dstS);
                                break;
                            }
                            case 6: {
                                diffs = ConfDifference.diffConfs(srcS, dstS, true);
                                break;
                            }
                            case 7: {
                                diffs = PropertiesDifference.diffProperties(srcS, dstS);
                                break;
                            }
                            case 8: {
                                ZipDifferencer.apply(src, dst, path, this.mState);
                                diffs = new Vector();
                                break;
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("Failed: source '" + src.getAbsolutePath() + "'; destination '" + dst.getAbsolutePath() + "'; type " + type + "; path '" + path + "'", ex, this);
                        }
                    }
                }
                finally {
                    c.closeAll();
                }
                if (diffs != null) {
                    for (int i = 0; i < diffs.size(); ++i) {
                        this.mState.getReporter().reportDifference(path, (Difference)diffs.elementAt(i));
                    }
                    return;
                }
            }
            this.mPlatform.apply(src, dst, path);
        }
        catch (Exception ex) {
            this.mState.getReporter().reportError(PackageInfo.createGenericFile(path, ex));
        }
    }
}

