/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.difference;

import com.raplix.rolloutexpress.difference.Difference;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class BinaryDifference
extends Difference {
    public static final int DIFF_FILE_LENGTH = 300;
    public static final int DIFF_BYTES = 301;
    public static final int DIFF_BYTES_AND_LENGTH = 302;

    public BinaryDifference() {
    }

    public BinaryDifference(int type, int srcOrder, int dstOrder) {
        super(type, null, null, null, srcOrder, dstOrder);
    }

    public String toString() {
        switch (this.getType()) {
            case 301: {
                return "Binaries are different. First change: " + this.getSourceOrder();
            }
            case 300: {
                return "Files are different lengths.";
            }
            case 302: {
                return "Files are different lengths, binaries are different. First change: " + this.getSourceOrder();
            }
        }
        throw new IllegalArgumentException("Invalid type: " + this.getType());
    }

    public static Vector diffBinaries(InputStream inSourceBytes, InputStream inDestBytes) throws IOException {
        int s;
        Vector<Difference> diffs = new Vector<Difference>();
        int i = 0;
        BufferedInputStream bufSrc = new BufferedInputStream(inSourceBytes);
        BufferedInputStream bufDst = new BufferedInputStream(inDestBytes);
        Difference theDifference = null;
        while ((s = bufSrc.read()) != -1) {
            int d = bufDst.read();
            if (d == -1 && theDifference == null) {
                theDifference = new BinaryDifference(300, 0, 0);
                break;
            }
            if (s != d && theDifference == null) {
                theDifference = new BinaryDifference(301, i, 0);
            }
            ++i;
        }
        if (bufDst.available() > 0) {
            theDifference = theDifference != null && theDifference.getType() == 301 ? new BinaryDifference(302, theDifference.getSourceOrder(), 0) : new BinaryDifference(300, 0, 0);
        }
        if (theDifference != null) {
            diffs.addElement(theDifference);
        }
        return diffs;
    }
}

